/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.magstripereaders;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.bbpos.swiper.SwiperController;
import com.roam.roamreaderunifiedapi.BaseDeviceManager;
import com.roam.roamreaderunifiedapi.ConfigurationManager;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.DisplayControl;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.TransactionManager;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListener;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListenerWithDevice;
import com.roam.roamreaderunifiedapi.callback.CalibrationListener;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.ReleaseHandler;
import com.roam.roamreaderunifiedapi.callback.SearchListener;
import com.roam.roamreaderunifiedapi.callback.TurnOnDeviceCallback;
import com.roam.roamreaderunifiedapi.constants.CalibrationResult;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceStatus;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.FirmwareChecksumType;
import com.roam.roamreaderunifiedapi.constants.FirmwareComponentType;
import com.roam.roamreaderunifiedapi.constants.LanguageCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.constants.VasMode;
import com.roam.roamreaderunifiedapi.data.ApplicationIdentifier;
import com.roam.roamreaderunifiedapi.data.CalibrationParameters;
import com.roam.roamreaderunifiedapi.data.Device;
import com.roam.roamreaderunifiedapi.data.PublicKey;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class G4XDeviceManager
extends BaseDeviceManager
implements ConfigurationManager,
TransactionManager {
    private static final String a = G4XDeviceManager.class.getSimpleName();
    private static DeviceManager b;
    private SwiperController c;
    private DeviceStatusHandler d;
    private DeviceResponseHandler e;
    private DeviceResponseHandler f;
    private Command g;
    private final AtomicBoolean h = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Command> i = new ArrayBlockingQueue(20);
    private boolean j;

    public static DeviceManager getInstance() {
        if (b == null) {
            b = new G4XDeviceManager();
        }
        return b;
    }

    private G4XDeviceManager() {
        LogUtils.write(a, "BBPOS API version::" + SwiperController.getSwiperAPIVersion());
    }

    @Override
    public DeviceType getType() {
        return DeviceType.G4x;
    }

    @Override
    public boolean initialize(Context context, DeviceStatusHandler statusHandler) {
        if (context != null) {
            if (this.c == null) {
                this.a(context);
            }
            if (this.c != null) {
                LogUtils.write(a, "initReader: Swiper state = " + (Object)((Object)this.c.getSwiperControllerState()));
                if (this.c.getSwiperControllerState() == SwiperController.SwiperControllerState.STATE_IDLE) {
                    this.c.isSwiperHere();
                }
            }
            this.d = statusHandler;
            this.j = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean initialize(Context context, boolean noDelay, DeviceStatusHandler statusHandler) {
        return this.initialize(context, statusHandler);
    }

    @Override
    public boolean initialize(Context context, DeviceStatusHandler statusHandler, CalibrationParameters calibrationParams) {
        return false;
    }

    @Override
    public boolean release() {
        this.h.set(false);
        this.i.clear();
        if (this.c != null) {
            if (this.c.getSwiperControllerState() != SwiperController.SwiperControllerState.STATE_IDLE) {
                this.c.stopSwiper();
            }
            this.c.deleteSwiper();
            this.c = null;
        }
        if (this.d != null) {
            this.d.onDisconnected();
        }
        this.j = false;
        this.d = null;
        return true;
    }

    @Override
    public void release(ReleaseHandler releaseHandler) {
        this.release();
        releaseHandler.done();
    }

    @Override
    public boolean isReady() {
        return this.c != null && this.c.isDevicePresent();
    }

    @Override
    public DeviceStatus getStatus() {
        if (this.isReady()) {
            return DeviceStatus.getReaderState(this.c.getSwiperControllerState());
        }
        return null;
    }

    @Override
    public ConfigurationManager getConfigurationManager() {
        return this;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this;
    }

    @Override
    public void resetDevice(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ResetDevice, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void readVersion(DeviceResponseHandler handler) {
        new a(handler).a();
    }

    @Override
    public void readKeyMappingInfo(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ReadKeyMappingInfo, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void generateBeep(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.GenerateBeep, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getDeviceCapabilities(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ReadCapabilities, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getFirmwareChecksumInfo(FirmwareChecksumType type, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.GetFirmwareChecksumInfo, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void configureBeep(Boolean disableReadMagneticCardBeep, Boolean disableRemoveCardBeep, Boolean disableEMVStartTransactionBeep, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureBeep, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setFirmwareVersion(FirmwareComponentType type, String version, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.SetFirmwareVersion, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getFirmwareVersion(FirmwareComponentType type, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.GetFirmwareVersion, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void clearPublicKeys(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ClearPublicKeys, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void submitAIDList(Set<ApplicationIdentifier> applicationIdentifiers, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.SubmitAIDsList, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void submitAIDWithTLVDataList(Set<ApplicationIdentifier> applicationIdentifiers, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.SubmitAIDsWithTLVDataList, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void submitPublicKey(PublicKey key, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.SubmitPublicKey, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void revokePublicKey(PublicKey key, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.RevokePublicKey, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setAmountDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureAmountDOLData, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setOnlineDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureOnlineDOLData, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setResponseDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureResponseDOLData, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void clearAIDSList(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ClearAIDsList, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void retrieveKSN(DeviceResponseHandler handler) {
        LogUtils.write(a, "retrieveKSN");
        if (this.c != null) {
            if (this.c.getSwiperControllerState() == SwiperController.SwiperControllerState.STATE_IDLE) {
                this.f = handler;
                this.g = Command.RetrieveKSN;
                this.c.getSwiperKsn();
            } else {
                this.notifyHandlerOfError((Object)Command.RetrieveKSN, ErrorCode.ReaderGeneralError, handler);
            }
        } else {
            this.notifyHandlerOfError((Object)Command.RetrieveKSN, ErrorCode.ReaderNotInitialized, handler);
        }
    }

    @Override
    public void readCertificateFilesVersion(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ReadCertificateFilesVersion, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setCommandTimeout(Integer timeout) {
        if (this.c != null && this.c.getSwiperControllerState() == SwiperController.SwiperControllerState.STATE_IDLE) {
            this.c.setSwipeTimeout(timeout.intValue());
        }
    }

    @Override
    public Boolean activateDevice(Device reader) {
        return true;
    }

    @Override
    public List<Device> getAvailableDevices() {
        return new ArrayList<Device>();
    }

    @Override
    public void waitForMagneticCardSwipe(DeviceResponseHandler handler) {
        LogUtils.write(a, "wait for magnetic card swipe");
        this.g = Command.WaitForMagneticCardSwipe;
        this.e = handler;
        this.a(Command.WaitForMagneticCardSwipe);
    }

    @Override
    public void cancelLastCommand() {
        this.stopWaitingForMagneticCardSwipe();
    }

    @Override
    public void stopWaitingForMagneticCardSwipe() {
        LogUtils.write(a, "stop waiting for magnetic card swipe");
        this.a(Command.StopWaitingForMagneticCardSwipe);
        this.e = null;
        this.g = null;
    }

    @Override
    public void sendCommand(Map<Parameter, Object> input, DeviceResponseHandler handler) {
        this.notifyHandlerOfError(input.get((Object)Parameter.Command), ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    private void a(Context context) {
        b b2 = new b();
        SwiperController.createInstance(context.getApplicationContext(), b2);
        this.c = SwiperController.getInstance();
        this.b();
    }

    private void b() {
        if (this.c != null) {
            this.c.setDetectDeviceChange(true);
            this.c.setFskRequired(false);
            this.c.setSwipeTimeout(-1.0);
            this.c.setChargeUpTime(0.6);
            this.c.setKsnChargeUpTime(0.6);
        }
    }

    @Override
    public void setUserInterfaceOptions(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureUserInterfaceOptions, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setEnergySaverModeTime(Integer seconds, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.EnergySaverModeTime, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setShutDownModeTime(Integer seconds, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ShutDownModeTime, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    private void a(Command command) {
        this.i.add(command);
        this.c();
    }

    private void c() {
        if (!this.h.getAndSet(true)) {
            try {
                Command command = this.i.poll();
                LogUtils.write(a, "about to execute command: " + (Object)((Object)command));
                if (null != command) {
                    if (null != this.c) {
                        SwiperController.SwiperControllerState swiperControllerState = this.c.getSwiperControllerState();
                        switch (command) {
                            case WaitForMagneticCardSwipe: {
                                if (SwiperController.SwiperControllerState.STATE_IDLE == swiperControllerState) {
                                    this.c.startSwiper();
                                    return;
                                }
                                LogUtils.write(a, "swiper not idle. not starting swiper");
                                break;
                            }
                            case StopWaitingForMagneticCardSwipe: {
                                if (SwiperController.SwiperControllerState.STATE_IDLE != swiperControllerState) {
                                    this.c.stopSwiper();
                                    return;
                                }
                                LogUtils.write(a, "swiper idle. not stopping swiper");
                                break;
                            }
                            default: {
                                LogUtils.write(a, "no action for command. clearing command running flag");
                                break;
                            }
                        }
                    } else {
                        LogUtils.write(a, "swiperController is not initialized");
                        this.notifyHandlerOfError((Object)command, ErrorCode.ReaderNotInitialized, this.e);
                        this.e = null;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                LogUtils.write(a, "illegal state exception: " + illegalStateException.toString());
            }
            this.h.set(false);
            if (0 < this.i.size()) {
                this.c();
            }
        } else {
            LogUtils.write(a, "unable to execute next command. command already running");
        }
    }

    @Override
    public void requestPairing(AudioJackPairingListener listener) {
        listener.onPairNotSupported();
    }

    @Override
    public void requestPairing(AudioJackPairingListenerWithDevice listener) {
        listener.onPairNotSupported();
    }

    @Override
    public void confirmPairing(Boolean isMatching) {
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, SearchListener listener) {
        this.searchDevices(ctx, true, listener);
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, SearchListener searchListener) {
        searchListener.onDeviceDiscovered(new Device(this.getType(), CommunicationType.AudioJack, "G4x", "Audio Jack"));
        searchListener.onDiscoveryComplete();
    }

    @Override
    public void searchDevices(Context ctx, SearchListener searchListener) {
        this.searchDevices(ctx, true, searchListener);
    }

    @Override
    public void registerDeviceStatusHandler(DeviceStatusHandler handler) {
        this.d = handler;
    }

    @Override
    public DisplayControl getDisplayControl() {
        return this.getNotSupportedDisplayControl();
    }

    @Override
    public KeyPadControl getKeypadControl() {
        return this.getNotSupportedKeyPadControl();
    }

    @Override
    public void sendRawcommand(String command, DeviceResponseHandler handler) {
        this.notifyHandlerOfError(command, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setExpectedAmountDOL(List<Parameter> list) {
    }

    @Override
    public void setExpectedOnlineDOL(List<Parameter> list) {
    }

    @Override
    public void setExpectedResponseDOL(List<Parameter> list) {
    }

    @Override
    public void loadSessionKey(Integer keyLength, String sessionKeyLocator, String masterKeyLocator, String encryptedKey, String checkValue, String id, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.LoadSessionKey, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void cancelSearch() {
    }

    @Override
    public void setUserInterfaceOptions(Integer cardInsertionTimeout, LanguageCode merchantLanguageCode, Byte pinPadOptions, Byte backlightControl, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.ConfigureUserInterfaceOptions, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void setContactlessOnlineDOL(List<Parameter> paramList, DeviceResponseHandler paramDeviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessOnlineDOLData, ErrorCode.NOT_SUPPORTED_BY_READER, paramDeviceResponseHandler);
    }

    @Override
    public void setContactlessResponseDOL(List<Parameter> paramList, DeviceResponseHandler paramDeviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessResponseDOLData, ErrorCode.NOT_SUPPORTED_BY_READER, paramDeviceResponseHandler);
    }

    @Override
    public void setExpectedContactlessOnlineDOL(List<Parameter> paramList) {
    }

    @Override
    public void setExpectedContactlessResponseDOL(List<Parameter> paramList) {
    }

    @Override
    public void submitContactlessAIDList(Set<ApplicationIdentifier> paramSet, DeviceResponseHandler paramDeviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.SubmitContactlessAIDsList, ErrorCode.NOT_SUPPORTED_BY_READER, paramDeviceResponseHandler);
    }

    @Override
    public void updateFirmware(String updateFilePath, DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.UpdateFirmware, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getBatteryStatus(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.BatteryInfo, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getBatteryLevelWithChargingStatus(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.BatteryInfo, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void getDeviceStatistics(DeviceResponseHandler handler) {
        this.notifyHandlerOfError((Object)Command.DeviceStatistics, ErrorCode.NOT_SUPPORTED_BY_READER, handler);
    }

    @Override
    public void enableContactless(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.EnableContactless, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void disableContactless(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.DisableContactless, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void enableFirmwareUpdateMode(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.EnableFirmwareUpdateMode, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, DeviceResponseHandler deviceResponseHandler) {
        this.configureContactlessTransactionOptions(isCVMSupported, isAMEXSupported, enableCryptogram17, enableOnlineCryptogram, enableOnline, enableMagStripe, enableMagChip, enableQVSDC, enableMSD, -1, deviceResponseHandler);
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, Integer contactlessOutcomeDisplayTime, DeviceResponseHandler deviceResponseHandler) {
        this.configureContactlessTransactionOptions(isCVMSupported, isAMEXSupported, enableCryptogram17, enableOnlineCryptogram, enableOnline, enableMagStripe, enableMagChip, enableQVSDC, enableMSD, false, false, contactlessOutcomeDisplayTime, deviceResponseHandler);
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, Boolean isDPASEmvSupported, Boolean isDPASMsrSupported, Integer contactlessOutcomeDisplayTime, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void startCalibration(Context context, CalibrationListener listener) {
        listener.onComplete(CalibrationResult.Ignored, null);
    }

    @Override
    public void stopCalibration(Context context) {
    }

    @Override
    public void waitForCardRemoval(Integer cardRemovalTimeout, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void getVasVersion(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void getVasMerchantCount(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void clearVasMerchants(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void getVasErrorMessage(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void activateVasExchangedMessageLog(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void deactivateVasExchangedMessageLog(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void getVasExchangedMessageLog(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void enableVasMode(VasMode vasMode, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void enableVasPlseState(Boolean isEnabled, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void getVasDataForMerchant(Integer merchantIndex, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void setVasApplicationVersion(String applicationVersion, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void setVasUnpredictableNumber(String unpredictableNumber, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void enableVasModeForMerchant(VasMode vasMode, String merchantID, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void addVasMerchant(VasMode vasMode, String merchantId, String merchantUrl, String categoryFilter, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.ConfigureContactlessTransaction, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void enableRkiMode(DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.EnableRkiMode, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void triggerRki(String deviceGroupName, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)Command.TriggerRki, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public CommunicationType getActiveCommunicationType() {
        return CommunicationType.AudioJack;
    }

    @Override
    public void turnOnDeviceViaAudioJack(Context context, TurnOnDeviceCallback turnOnDeviceCallback) {
        turnOnDeviceCallback.notSupported();
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, Short lowRssi, Short highRssi, SearchListener searchListener) {
        this.searchDevices(ctx, true, searchListener);
    }

    @Override
    public void stopInitialization() {
    }

    @Override
    public void cancelFirmwareUpdate() {
    }

    private class a
    extends AsyncTask<Void, Void, String> {
        DeviceResponseHandler a;

        a(DeviceResponseHandler deviceResponseHandler) {
            this.a = deviceResponseHandler;
        }

        protected String a(Void ... voidArray) {
            if (G4XDeviceManager.this.c.getSwiperControllerState() == SwiperController.SwiperControllerState.STATE_IDLE) {
                return "Firmware Version : " + G4XDeviceManager.this.c.getSwiperFirmwareVersion() + " API Version: " + SwiperController.getSwiperAPIVersion();
            }
            return null;
        }

        protected void a(String string) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.ReadVersion);
            if (TextUtils.isEmpty((CharSequence)string)) {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.ERROR_READING_VERSION);
            } else {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
                enumMap.put(Parameter.ReaderVersion, string);
            }
            this.a.onResponse(enumMap);
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((String)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private class b
    implements SwiperController.SwiperStateChangedListener {
        private b() {
        }

        @Override
        public void onCardSwipeDetected() {
            LogUtils.write(a, "onCardSwipeDetected");
            if (G4XDeviceManager.this.e != null) {
                G4XDeviceManager.this.e.onProgress(ProgressMessage.SwipeDetected, "Swipe detected...");
            }
        }

        @Override
        public void onDecodeError(SwiperController.DecodeResult decodeResult) {
            if (G4XDeviceManager.this.e != null) {
                ErrorCode errorCode;
                String string;
                if (decodeResult == SwiperController.DecodeResult.DECODE_SWIPE_FAIL) {
                    string = "Swipe fail";
                    errorCode = ErrorCode.G4X_DECODE_SWIPE_FAIL;
                } else if (decodeResult == SwiperController.DecodeResult.DECODE_TAP_FAIL) {
                    string = "Tap fail";
                    errorCode = ErrorCode.G4X_DECODE_TAP_FAIL;
                } else if (decodeResult == SwiperController.DecodeResult.DECODE_CRC_ERROR) {
                    string = "CRC error";
                    errorCode = ErrorCode.G4X_DECODE_CRC_ERROR;
                } else if (decodeResult == SwiperController.DecodeResult.DECODE_COMM_ERROR) {
                    string = "Communication error";
                    errorCode = ErrorCode.G4X_DECODE_COMM_ERROR;
                } else if (decodeResult == SwiperController.DecodeResult.DECODE_CARD_NOT_SUPPORTED) {
                    string = "Card not supported";
                    errorCode = ErrorCode.G4X_DECODE_CARD_NOT_SUPPORTED;
                } else {
                    string = "Unknown decode error";
                    errorCode = ErrorCode.G4x_DECODE_UNKNOWN_ERROR;
                }
                LogUtils.write(a, string);
                LogUtils.write(a, "Swiper state = " + (Object)((Object)G4XDeviceManager.this.c.getSwiperControllerState()));
                EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)errorCode);
                enumMap.put(Parameter.Command, (Object)Command.WaitForMagneticCardSwipe);
                G4XDeviceManager.this.e.onResponse(enumMap);
                G4XDeviceManager.this.e = null;
            }
            LogUtils.write(a, "decode error. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }

        @Override
        public void onError(String message) {
            LogUtils.write(a, "onError::" + message);
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.Command, (Object)G4XDeviceManager.this.g);
            enumMap.put(Parameter.ErrorDetails, message);
            if (G4XDeviceManager.this.g == Command.RetrieveKSN) {
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.ERROR_READING_KSN);
                if (G4XDeviceManager.this.f != null) {
                    G4XDeviceManager.this.f.onResponse(enumMap);
                }
            } else if (G4XDeviceManager.this.g == Command.WaitForMagneticCardSwipe) {
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.ReaderGeneralError);
                if (G4XDeviceManager.this.e != null) {
                    G4XDeviceManager.this.e.onResponse(enumMap);
                }
            }
            LogUtils.write(a, "general device error. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }

        @Override
        public void onGetKsnCompleted(String ksn) {
            LogUtils.write(a, "onGetKsnCompleted::" + ksn);
            if (G4XDeviceManager.this.g == Command.RetrieveKSN) {
                EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
                enumMap.put(Parameter.Command, (Object)Command.RetrieveKSN);
                if (!TextUtils.isEmpty((CharSequence)ksn)) {
                    enumMap.put(Parameter.KSN, ksn);
                    enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
                } else {
                    enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                    enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.ERROR_READING_KSN);
                }
                if (G4XDeviceManager.this.f != null) {
                    G4XDeviceManager.this.f.onResponse(enumMap);
                }
                G4XDeviceManager.this.f = null;
            }
        }

        @Override
        public void onInterrupted() {
            LogUtils.write(a, "onInterrupted");
            if (G4XDeviceManager.this.f != null) {
                G4XDeviceManager.this.notifyHandlerOfError((Object)Command.RetrieveKSN, ErrorCode.ReaderInterrupted, G4XDeviceManager.this.f);
            } else if (G4XDeviceManager.this.e != null) {
                G4XDeviceManager.this.notifyHandlerOfError((Object)Command.WaitForMagneticCardSwipe, ErrorCode.ReaderInterrupted, G4XDeviceManager.this.e);
            }
            LogUtils.write(a, "interrupted. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }

        @Override
        public void onNoDeviceDetected() {
            LogUtils.write(a, "onNoDeviceDetected");
        }

        @Override
        public void onTimeout() {
            LogUtils.write(a, "onTimeout");
            if (G4XDeviceManager.this.f != null) {
                G4XDeviceManager.this.notifyHandlerOfError((Object)Command.RetrieveKSN, ErrorCode.ReaderTimeout, G4XDeviceManager.this.f);
                G4XDeviceManager.this.f = null;
            } else if (G4XDeviceManager.this.e != null) {
                G4XDeviceManager.this.notifyHandlerOfError((Object)Command.WaitForMagneticCardSwipe, ErrorCode.ReaderTimeout, G4XDeviceManager.this.e);
                G4XDeviceManager.this.e = null;
            }
        }

        @Override
        public void onWaitingForCardSwipe() {
            LogUtils.write(a, "onWaitingForCardSwipe");
            if (G4XDeviceManager.this.e != null) {
                G4XDeviceManager.this.e.onProgress(ProgressMessage.WaitingforCardSwipe, "Waiting for card swipe...");
            }
            LogUtils.write(a, "waiting for swipe. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }

        @Override
        public void onWaitingForDevice() {
            LogUtils.write(a, "onWaitingForDevice");
        }

        @Override
        public void onDevicePlugged() {
            block3: {
                LogUtils.write(a, "onDevicePlugged");
                try {
                    if (G4XDeviceManager.this.c != null && G4XDeviceManager.this.c.getSwiperControllerState() == SwiperController.SwiperControllerState.STATE_IDLE) {
                        G4XDeviceManager.this.c.isSwiperHere();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    LogUtils.write(a, "Invalid state");
                    if (G4XDeviceManager.this.d == null) break block3;
                    G4XDeviceManager.this.d.onError("Swiper is in invalid state.");
                }
            }
            LogUtils.write(a, "device plugged in. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }

        @Override
        public void onDeviceUnplugged() {
            LogUtils.write(a, "onDeviceUnplugged");
            if (G4XDeviceManager.this.d != null) {
                G4XDeviceManager.this.d.onDisconnected();
            } else {
                LogUtils.write(a, "Swiper is in Invalid state.");
            }
            LogUtils.write(a, "device disconnected. clearing command running flag and command queue");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.i.clear();
        }

        @Override
        public void onSwiperHere(boolean isHere) {
            LogUtils.write(a, "onSwiperHere::" + isHere);
            if (G4XDeviceManager.this.d != null) {
                if (isHere) {
                    G4XDeviceManager.this.d.onConnected();
                } else {
                    LogUtils.write(a, "Swiper is in Invalid state.");
                    G4XDeviceManager.this.d.onDisconnected();
                    G4XDeviceManager.this.d.onError("Connected Device is not G4x");
                }
            }
        }

        @Override
        public void onDecodeCompleted(HashMap<String, String> decodeData) {
            LogUtils.write(a, "onDecodeCompleted");
            LogUtils.write(a, decodeData);
            if (null != G4XDeviceManager.this.e) {
                EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
                enumMap.put(Parameter.Command, (Object)Command.WaitForMagneticCardSwipe);
                enumMap.put(Parameter.PackedEncryptedTrack, SwiperController.packEncTrackData(decodeData.get("formatID"), decodeData.get("encTrack"), decodeData.get("partialTrack")));
                if (decodeData.get("encTrack") != null) {
                    enumMap.put(Parameter.EncryptedTrack, decodeData.get("encTrack"));
                }
                if (decodeData.get("formatID") != null) {
                    enumMap.put(Parameter.FormatID, decodeData.get("formatID"));
                }
                if (decodeData.get("partialTrack") != null) {
                    enumMap.put(Parameter.PartialTrackData, decodeData.get("partialTrack"));
                }
                if (decodeData.get("track1Status") != null) {
                    enumMap.put(Parameter.Track1Status, decodeData.get("track1Status"));
                }
                if (decodeData.get("track2Status") != null) {
                    enumMap.put(Parameter.Track2Status, decodeData.get("track2Status"));
                }
                if (decodeData.get("ksn") != null) {
                    enumMap.put(Parameter.KSN, decodeData.get("ksn"));
                }
                if (decodeData.get("maskedPAN") != null) {
                    enumMap.put(Parameter.PAN, decodeData.get("maskedPAN"));
                }
                if (decodeData.get("cardholderName") != null) {
                    enumMap.put(Parameter.CardHolderName, decodeData.get("cardholderName"));
                }
                if (decodeData.get("expiryDate") != null) {
                    enumMap.put(Parameter.CardExpDate, decodeData.get("expiryDate"));
                }
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
                G4XDeviceManager.this.e.onResponse(enumMap);
                G4XDeviceManager.this.e = null;
            }
            LogUtils.write(a, "decode completed. clearing command running flag");
            G4XDeviceManager.this.h.set(false);
            G4XDeviceManager.this.c();
        }
    }
}

