/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.IngenicoBluetoothDevice;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.AudioJackManager;
import java.util.Set;

class DeviceScanner
extends PayPalRetailObject {
    private static final String LOG_COMPONENT = "native.deviceScanner";
    private static final String LOG_TAG = DeviceScanner.class.getSimpleName();
    private static final String LOG_SCAN_TAG = "native.devicescanner";
    private V8Object mNativeReader;
    private V8Function mScanCompleteCallback;
    private static DeviceScanner sInstance;
    private static volatile boolean mScanInProgress;
    private static final String BLUETOOTH_DISABLED = "bluetoothDisabled";
    private static final String BLUETOOTH_ADAPTER_NULL = "bluetoothAdapterNull";

    private DeviceScanner() {
    }

    public static DeviceScanner getInstance() {
        if (sInstance == null) {
            sInstance = new DeviceScanner();
        }
        return sInstance;
    }

    public void createJSScanner() {
        RetailSDK.log(logLevel.debug, LOG_TAG, " createJSScanner for : ");
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                DeviceScanner.this.mNativeReader = PayPalRetailObject.getEngine().createJsObject();
                DeviceScanner.this.mNativeReader.registerJavaMethod((Object)DeviceScanner.this, "getBTList", "getBTList", new Class[]{V8Function.class});
                DeviceScanner.this.mNativeReader.registerJavaMethod((Object)DeviceScanner.this, "start", "start", new Class[]{V8Function.class});
                DeviceScanner.this.mNativeReader.registerJavaMethod((Object)DeviceScanner.this, "stop", "stop", null);
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)DeviceScanner.this.mNativeReader);
                DeviceScanner.this.impl = PayPalRetailObject.getEngine().createJsObject("DeviceScanner", args);
                RetailSDK.log(logLevel.debug, DeviceScanner.LOG_SCAN_TAG, "createJSScanner created the DeviceScanner");
            }
        });
    }

    public void getBTList(V8Function callback) {
        final V8Function cb = callback.twin();
        final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        try {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    Set devices;
                    V8Array arrBTs = RetailSDK.jsArgs();
                    if (adapter != null && adapter.isEnabled() && (devices = adapter.getBondedDevices()) != null) {
                        for (BluetoothDevice device : devices) {
                            if (device.getName() == null) continue;
                            RetailSDK.log(logLevel.info, DeviceScanner.LOG_COMPONENT, "Found reader device " + device.getName());
                            V8Object pd = PayPalRetailObject.getEngine().createJsObject();
                            pd.add("id", device.getName());
                            pd.add("address", device.getAddress());
                            arrBTs.push((V8Value)pd);
                        }
                    }
                    V8Array args = RetailSDK.jsArgs();
                    args.push((V8Value)arrBTs);
                    cb.call(DeviceScanner.this.mNativeReader, args);
                }
            });
        }
        catch (Exception e) {
            RetailSDK.log(logLevel.error, LOG_TAG, "getBTList -> Error from invoking JS callback: " + e.toString());
        }
    }

    public void start(V8Function jsCallback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, " DeviceScanner started");
        this.mScanCompleteCallback = jsCallback.twin();
        DeviceScanner.setScanInProgress(true);
        this.scan();
    }

    public void stop() {
        RetailSDK.log(logLevel.debug, LOG_TAG, " DeviceScanner stop");
        if (mScanInProgress) {
            RetailSDK.log(logLevel.debug, LOG_TAG, " DeviceScanner stopped");
            IngenicoBluetoothDevice.StopScanningForDevices();
            this.scanComplete(null, null);
        }
    }

    public void scanComplete(final String code, final String error) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "DeviceScanner scanComplete");
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (DeviceScanner.this.mScanCompleteCallback != null) {
                    RetailSDK.log(logLevel.debug, LOG_TAG, " DeviceScanner scanComplete callback with error: " + error);
                    V8Array args = error == null ? RetailSDK.jsArgs().pushUndefined() : RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError(error, code, ""));
                    DeviceScanner.this.mScanCompleteCallback.call(DeviceScanner.this.mNativeReader, args);
                    DeviceScanner.this.mScanCompleteCallback = null;
                }
            }
        });
        DeviceScanner.setScanInProgress(false);
    }

    private static synchronized void setScanInProgress(boolean isInProgress) {
        mScanInProgress = isInProgress;
    }

    public void onDiscovered(final String name, final String address) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                try {
                    RetailSDK.log(logLevel.debug, DeviceScanner.LOG_COMPONENT, "discovered device " + name + "-" + address + " to be listed");
                    V8Object args = PayPalRetailObject.getEngine().createJsObject();
                    args.add("id", name);
                    args.add("address", address);
                    DeviceScanner.this.impl.executeVoidFunction("onDiscovered", RetailSDK.jsArgs().push((V8Value)args));
                }
                catch (Exception e) {
                    RetailSDK.log(logLevel.error, LOG_TAG, "Error from invoking JS onDiscovered: " + e.toString());
                }
            }
        });
    }

    void scan() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            this.scanComplete(BLUETOOTH_ADAPTER_NULL, "Bluetooth adapter null");
            return;
        }
        if (!adapter.isEnabled()) {
            this.scanComplete(BLUETOOTH_DISABLED, "Bluetooth disabled");
            return;
        }
        Set devices = adapter.getBondedDevices();
        if (devices != null) {
            for (BluetoothDevice device : devices) {
                if (device.getName() == null) continue;
                RetailSDK.log(logLevel.info, LOG_COMPONENT, "Found reader device " + device.getName());
                this.onDiscovered(device.getName(), device.getAddress());
            }
        }
        this.scanRoamSwiper();
        IngenicoBluetoothDevice.ScanForDevices();
    }

    public void scanRoamSwiper() {
        if (AudioJackManager.getInstance().doesRoamPluggedIn()) {
            RetailSDK.log(logLevel.info, LOG_COMPONENT, "Found ROAM reader device");
            this.onDiscovered("PayPal Audio Reader", "RoamSwiper");
        }
    }

    static {
        mScanInProgress = false;
    }
}

