/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.BluetoothDevice;
import com.paypal.paypalretailsdk.DeviceScanner;
import com.paypal.paypalretailsdk.IngenicoDeviceConnectionManager;
import com.paypal.paypalretailsdk.NativeInterface;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.PaymentDevice;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.UnsolicitedEvent;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.RoamReaderUnifiedAPI;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.ProgressHandler;
import com.roam.roamreaderunifiedapi.callback.ReleaseHandler;
import com.roam.roamreaderunifiedapi.callback.SearchListener;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.data.Device;
import java.util.Locale;
import java.util.Map;

class IngenicoBluetoothDevice
extends PayPalRetailObject
implements BluetoothDevice {
    private static final String COMMAND_CANCELED_ERROR = "CommandCancelledUponReceiptOfACancelWaitCommand";
    private static final String CARD_READER_DISCONNECTED_ERROR = "CardReaderNotConnected";
    private static final String LOG_TAG = "native.ingenico";
    private static final String LOG_SCAN_TAG = "native.ingenico.scan";
    private static volatile boolean INGENICO_SCAN_IN_PROGRESS = false;
    private V8Function mConnectCallback;
    private V8Function mDisconnectCallback;
    private V8Function mRemoveCallback;
    private V8Function mSendCallback = null;
    private V8Function mFwUpdateCallback = null;
    private V8Function mFwUpdateProgressCallback = null;
    private volatile ConnectionStatus status = ConnectionStatus.None;
    private V8Object nativeReader;
    private IngenicoDeviceConnectionManager _mIngenicoDeviceConnectionManager;
    private static volatile IngenicoDeviceScanner scanner = new IngenicoDeviceScanner();
    private IngenicoReleaseHandler _releaseHandler = new IngenicoReleaseHandler();
    private InegnicoDeviceStatusHandler _deviceStatusHandler = new InegnicoDeviceStatusHandler();
    private IngenicoDeviceResponseHandler _deviceResponseHandler = new IngenicoDeviceResponseHandler();
    private IngenicoProgressHandler _progressHandler = new IngenicoProgressHandler();
    private String deviceName;
    private String deviceAddress;
    private String deviceLogId;

    static synchronized void ScanForDevices() {
        if (INGENICO_SCAN_IN_PROGRESS) {
            RetailSDK.log(logLevel.debug, LOG_SCAN_TAG, "Skip device scan request as either Ingenico device was already found: '" + IngenicoBluetoothDevice.isIngenicoDeviceFound() + "' or scan is in progress: '" + INGENICO_SCAN_IN_PROGRESS + "'");
            return;
        }
        IngenicoBluetoothDevice.setScanInProgress(true);
        if (scanner != null) {
            scanner = new IngenicoDeviceScanner();
        }
        scanner.scanIngenicoDevices();
    }

    static synchronized void StopScanningForDevices() {
        if (INGENICO_SCAN_IN_PROGRESS && scanner != null) {
            scanner.cancelIngenicoDevicesSearch();
        }
    }

    private static boolean isIngenicoDeviceFound() {
        return false;
    }

    private static synchronized void setScanInProgress(boolean isInProgress) {
        INGENICO_SCAN_IN_PROGRESS = isInProgress;
    }

    IngenicoBluetoothDevice(String deviceName, String deviceAddress, V8Function callback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "IngenicoBluetoothDevice create Paired Device with name " + deviceName + ", address " + deviceAddress);
        this.deviceName = deviceName;
        this.deviceAddress = deviceAddress;
        this.deviceLogId = NativeInterface.buildDevId(deviceName, deviceAddress);
        this._mIngenicoDeviceConnectionManager = new IngenicoDeviceConnectionManager(this, deviceName, deviceAddress, null, callback);
    }

    private IngenicoBluetoothDevice(String deviceName, String deviceAddress, DeviceManager deviceManager) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "IngenicoBluetoothDevice create New Device with name " + deviceName + " and address " + deviceAddress);
        this.deviceName = deviceName;
        this.deviceAddress = deviceAddress;
        this.deviceLogId = NativeInterface.buildDevId(deviceName, deviceAddress);
        this._mIngenicoDeviceConnectionManager = new IngenicoDeviceConnectionManager(this, deviceName, deviceAddress, deviceManager, null);
    }

    void createJSReader() {
        try {
            RetailSDK.log(logLevel.debug, LOG_TAG, "createJSReader " + this.deviceName);
            this.status = ConnectionStatus.Connecting;
            this.nativeReader = PayPalRetailObject.getEngine().createJsObject();
            this.nativeReader.registerJavaMethod((Object)this, "jsIsConnected", "isConnected", null);
            this.nativeReader.registerJavaMethod((Object)this, "jsConnect", "connect", new Class[]{V8Function.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsDisconnect", "disconnect", new Class[]{V8Function.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsSend", "send", new Class[]{String.class, Object.class, V8Object.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsEnableFirmwareUpdateMode", "enableFirmwareUpdateMode", new Class[]{Object.class, V8Object.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsUpdateFirmware", "updateFirmware", new Class[]{V8Object.class, V8Object.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsIsUnsFileValid", "isUnsFileValid", new Class[]{String.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsRemoved", "removed", new Class[]{V8Function.class});
            this.nativeReader.registerJavaMethod((Object)this, "jsCancelConnect", "cancelConnect", null);
            final V8Object deviceBuilder = PayPalRetailObject.getEngine().createJsObject("DeviceBuilder", RetailSDK.jsArgs());
            final V8Array args = IngenicoBluetoothDevice.getEngine().createJsArray().push("INGENICO").push(this._mIngenicoDeviceConnectionManager.getIngenicoDevice().getName()).push(false).push((V8Value)this.nativeReader).push("RP450").push(this.deviceAddress);
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    IngenicoBluetoothDevice.this.impl = deviceBuilder.executeObjectFunction("build", args);
                    RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "Build JS reader...! Emitting card discovered event for " + IngenicoBluetoothDevice.this.deviceName);
                    RetailSDK.getJsSdk().discoveredPaymentDevice(new PaymentDevice(IngenicoBluetoothDevice.this.impl));
                }
            });
        }
        catch (Exception ex) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error on provisioning new device " + ex.toString());
            this.status = ConnectionStatus.None;
        }
    }

    public void jsConnect(V8Function jsCallback) {
        this.mConnectCallback = jsCallback.twin();
        if (this.status.equals((Object)ConnectionStatus.Disconnecting)) {
            RetailSDK.log(logLevel.debug, LOG_TAG, this.deviceName + " is disconnecting... Will connect once the disconnect is successful");
        } else {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Initializing and connecting to the card reader");
            this._mIngenicoDeviceConnectionManager.connectToDevice(this._deviceStatusHandler);
            this._mIngenicoDeviceConnectionManager.registerProgressHandler(this._progressHandler);
        }
    }

    private void onDeviceConnectionResult(final String error) {
        if (StringUtil.isEmpty(error)) {
            this.status = ConnectionStatus.Connected;
        } else {
            RetailSDK.logToCal(logLevel.error, LOG_TAG, this.deviceLogId + " connection failed with error - " + error);
            this.status = ConnectionStatus.None;
        }
        RetailSDK.log(logLevel.debug, LOG_TAG, "Setting status to " + this.status.name());
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                V8Array args = RetailSDK.jsArgs();
                if (StringUtil.isNotEmpty(error)) {
                    args.push((V8Value)PayPalRetailObject.getEngine().asJsError(error, "", ""));
                } else {
                    args.pushUndefined();
                }
                if (IngenicoBluetoothDevice.this.mConnectCallback != null) {
                    IngenicoBluetoothDevice.this.mConnectCallback.call(IngenicoBluetoothDevice.this.nativeReader, args);
                    IngenicoBluetoothDevice.this.mConnectCallback = null;
                }
            }
        });
    }

    private void disconnect(final V8Function jsCallback) {
        if (this.jsIsConnected()) {
            this.status = ConnectionStatus.Disconnecting;
            this._mIngenicoDeviceConnectionManager.releaseDevice(this._releaseHandler);
            this._mIngenicoDeviceConnectionManager.unregisterProgressHandler(this._progressHandler);
            if (jsCallback != null) {
                this.mDisconnectCallback = jsCallback.twin();
            }
        } else {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    jsCallback.call(IngenicoBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
                }
            });
        }
    }

    public boolean jsIsConnected() {
        return this.status == ConnectionStatus.Connected;
    }

    public void jsCancelConnect() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "cancelConnect called when ConnectionStatus is " + this.status.toString());
        if (this.status == ConnectionStatus.Connecting) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Stopping device connection");
            this._mIngenicoDeviceConnectionManager.getIngenicoDeviceManager().stopInitialization();
        }
    }

    public void jsDisconnect(V8Function jsCallback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "Disconnecting card reader");
        this.disconnect(jsCallback);
    }

    public void jsRemoved(V8Function jsCallback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "jsRemoved triggered for : " + this.deviceName);
        this.mRemoveCallback = jsCallback.twin();
        if (this.status == ConnectionStatus.Disconnecting) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "mRemoveCallback will be handled in done() for : " + this.deviceName);
            return;
        }
        if (this.jsIsConnected()) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "First disconnect and let mRemoveCallback be executed in done() for : " + this.deviceName);
            this.status = ConnectionStatus.Disconnecting;
            this._mIngenicoDeviceConnectionManager.releaseDevice(this._releaseHandler);
            this._mIngenicoDeviceConnectionManager.unregisterProgressHandler(this._progressHandler);
        } else {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    if (IngenicoBluetoothDevice.this.mRemoveCallback != null) {
                        IngenicoBluetoothDevice.this.mRemoveCallback.call(IngenicoBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
                        IngenicoBluetoothDevice.this.mRemoveCallback = null;
                    }
                }
            });
        }
    }

    @Override
    public void removePaymentDevice() {
        if (this.status == ConnectionStatus.Connecting) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "connecting ingenico device '" + this.deviceName + "' so do NOT remove");
            return;
        }
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                IngenicoBluetoothDevice.this.impl.executeVoidFunction("removed", RetailSDK.jsArgs().pushUndefined());
            }
        });
    }

    private void onDeviceDisconnected() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "Executing js.onDisconnected() for " + this.deviceName);
    }

    private void invokeRequestCallback(final JsError err, final String data) {
        try {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    V8Array args = RetailSDK.jsArgs();
                    if (err == null) {
                        args.pushUndefined();
                    } else {
                        V8Object jsError = PayPalRetailObject.getEngine().asJsError(err.message, err.code, Log.getStackTraceString((Throwable)new Exception()));
                        args.push((V8Value)jsError);
                    }
                    if (data != null) {
                        args.push(data);
                    }
                    if (IngenicoBluetoothDevice.this.mSendCallback != null) {
                        IngenicoBluetoothDevice.this.mSendCallback.call(IngenicoBluetoothDevice.this.nativeReader, args);
                    }
                }
            });
        }
        catch (Exception e) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error from invoking JS callback: " + e.toString());
        }
    }

    private void invokeFwUpdateCallback(final JsError err, final String data) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "invokeFirmwareUpdateCallback");
        try {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    V8Array args = RetailSDK.jsArgs();
                    if (err == null) {
                        args.pushUndefined();
                    } else {
                        V8Object jsError = PayPalRetailObject.getEngine().asJsError(err.message, err.code, Log.getStackTraceString((Throwable)new Exception()));
                        args.push((V8Value)jsError);
                    }
                    if (data != null) {
                        args.push(data);
                    }
                    if (IngenicoBluetoothDevice.this.mFwUpdateCallback != null) {
                        IngenicoBluetoothDevice.this.mFwUpdateCallback.call(IngenicoBluetoothDevice.this.nativeReader, args);
                    }
                }
            });
        }
        catch (Exception e) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error from invoking JS callback: " + e.toString());
        }
    }

    private void pushUnsolicitedResponseToJs(final UnsolicitedEvent event, final JsError err, final String data) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                try {
                    V8Object args = PayPalRetailObject.getEngine().createJsObject();
                    args.add("event", event.toString());
                    args.add("data", data);
                    if (err != null) {
                        args.add("error", (V8Value)PayPalRetailObject.getEngine().asJsError(err.message, err.code, Log.getStackTraceString((Throwable)new Exception())));
                    }
                    IngenicoBluetoothDevice.this.impl.executeVoidFunction("received", RetailSDK.jsArgs().push((V8Value)args));
                }
                catch (Exception e) {
                    RetailSDK.log(logLevel.error, IngenicoBluetoothDevice.LOG_TAG, "Error from invoking JS received: " + e.toString());
                }
            }
        });
    }

    private String getResponseMap(Map<Parameter, Object> data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Parameter, Object> entry : data.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append(entry.getKey().toString()).append(":").append(entry.getValue().toString()).append("\n");
        }
        return sb.toString();
    }

    private void invokeFwUpdateProgressCallback(final String data) {
        try {
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    V8Array args = RetailSDK.jsArgs();
                    if (data != null) {
                        args.push(data);
                    }
                    if (IngenicoBluetoothDevice.this.mFwUpdateProgressCallback != null) {
                        IngenicoBluetoothDevice.this.mFwUpdateProgressCallback.call(IngenicoBluetoothDevice.this.nativeReader, args);
                    }
                }
            });
        }
        catch (Exception e) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error from invoking JS callback: " + e.toString());
        }
    }

    public boolean jsSend(String commandName, Object data, V8Object callback) {
        if (callback != null && !callback.isUndefined()) {
            V8Function jsCallback = (V8Function)callback;
            this.mSendCallback = jsCallback.twin();
        }
        if (!this.jsIsConnected()) {
            RetailSDK.log(logLevel.error, LOG_TAG, "DEVICE NOT CONNECTED <<<<<<<<<<<<<<<<<<<<");
            return false;
        }
        try {
            String command = data.toString();
            RetailSDK.log(logLevel.debug, LOG_TAG, "Pushing command (" + commandName + ")");
            this._mIngenicoDeviceConnectionManager.getIngenicoDeviceManager().getConfigurationManager().sendRawcommand(command, (DeviceResponseHandler)this._deviceResponseHandler);
        }
        catch (Exception ex) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error invoking jsSend for (" + commandName + ")" + ex.toString());
        }
        return true;
    }

    public void jsEnableFirmwareUpdateMode(Object data, V8Object callback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "jsEnableFirmwareUpdateMode");
        if (callback != null && !callback.isUndefined()) {
            V8Function jsCallback = (V8Function)callback;
            this.mFwUpdateCallback = jsCallback.twin();
        }
        this._mIngenicoDeviceConnectionManager.getIngenicoDeviceManager().enableFirmwareUpdateMode((DeviceResponseHandler)this._deviceResponseHandler);
    }

    public boolean jsIsUnsFileValid(String localFilePath) {
        try {
            return RoamReaderUnifiedAPI.isValidUnsFile((String)localFilePath);
        }
        catch (Throwable err) {
            RetailSDK.log(logLevel.warn, LOG_TAG, "Error on executing jsIsUnsFileValid: " + err.toString());
            return true;
        }
    }

    public void jsUpdateFirmware(V8Object options, V8Object callback) {
        V8Object opt = options.twin();
        String fwFileLocation = opt.getString("fwFileLocation");
        this.mFwUpdateProgressCallback = (V8Function)opt.getObject("progressCallback");
        this.mFwUpdateCallback = ((V8Function)callback).twin();
        this._mIngenicoDeviceConnectionManager.getIngenicoDeviceManager().updateFirmware(fwFileLocation, (DeviceResponseHandler)this._deviceResponseHandler);
    }

    private void showSwipeFailedToast() {
        Activity currentActivity = RetailSDK.getAppState().getCurrentActivity();
        Toast toast = new Toast((Context)currentActivity);
        LayoutInflater inflater = (LayoutInflater)currentActivity.getSystemService("layout_inflater");
        View toastView = inflater.inflate(R.layout.toast_swipe_failed, null);
        ImageView imageView = (ImageView)toastView.findViewById(R.id.swipe_failed_image);
        imageView.setImageResource(R.drawable.ic_swipe_failed);
        toast.setGravity(16, 0, 0);
        toast.setDuration(0);
        toast.setView(toastView);
        toast.show();
    }

    private class JsError {
        String message;
        String code;

        JsError(String message, String code) {
            this.message = message;
            this.code = code;
        }
    }

    private static enum ConnectionStatus {
        None,
        Connecting,
        Connected,
        Disconnecting;

    }

    private class IngenicoProgressHandler
    implements ProgressHandler {
        private IngenicoProgressHandler() {
        }

        public void onProgress(ProgressMessage messageType, String additionalMsg) {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, IngenicoBluetoothDevice.this.deviceName + " ProgressMessage: " + messageType + " additional msg: " + additionalMsg);
            if (messageType == ProgressMessage.CardInserted) {
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardInserted, null, null);
                return;
            }
            if (messageType == ProgressMessage.CardRemoved) {
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardRemoved, null, null);
            }
        }
    }

    private class IngenicoReleaseHandler
    implements ReleaseHandler {
        private IngenicoReleaseHandler() {
        }

        public void done() {
            IngenicoBluetoothDevice.this.status = ConnectionStatus.None;
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, IngenicoBluetoothDevice.this.deviceName + " released");
            if (IngenicoBluetoothDevice.this.mConnectCallback != null) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, IngenicoBluetoothDevice.this.deviceName + " has a queued connection call. Will connect to it now");
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        IngenicoBluetoothDevice.this.jsConnect(IngenicoBluetoothDevice.this.mConnectCallback);
                    }
                });
            }
            if (IngenicoBluetoothDevice.this.mDisconnectCallback != null) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "Executing mDisconnectCallback for " + IngenicoBluetoothDevice.this.deviceName);
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        IngenicoBluetoothDevice.this.mDisconnectCallback.call(IngenicoBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
                        IngenicoBluetoothDevice.this.mDisconnectCallback = null;
                    }
                });
            }
            if (IngenicoBluetoothDevice.this.mRemoveCallback != null) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "Executing mRemoveCallback for " + IngenicoBluetoothDevice.this.deviceName);
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        IngenicoBluetoothDevice.this.mRemoveCallback.call(IngenicoBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
                        IngenicoBluetoothDevice.this.mRemoveCallback = null;
                    }
                });
            }
        }
    }

    private class InegnicoDeviceStatusHandler
    implements DeviceStatusHandler {
        private InegnicoDeviceStatusHandler() {
        }

        public void onError(String s) {
            RetailSDK.log(logLevel.error, IngenicoBluetoothDevice.LOG_TAG, "onError - " + s);
            IngenicoBluetoothDevice.this.onDeviceConnectionResult(s);
        }

        public void onConnected() {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, IngenicoBluetoothDevice.this.deviceName + " connected");
            IngenicoBluetoothDevice.this.onDeviceConnectionResult(null);
        }

        public void onDisconnected() {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, IngenicoBluetoothDevice.this.deviceName + " disconnected");
            IngenicoBluetoothDevice.this.onDeviceDisconnected();
        }
    }

    private class IngenicoDeviceResponseHandler
    implements DeviceResponseHandler {
        private IngenicoDeviceResponseHandler() {
        }

        public void onResponse(Map<Parameter, Object> data) {
            Command cmd = (Command)data.get(Parameter.Command);
            ResponseCode responseCode = (ResponseCode)data.get(Parameter.ResponseCode);
            if (responseCode == ResponseCode.Error) {
                String errorMessage = "";
                String errorCode = "";
                if (data.containsKey(Parameter.ErrorCode)) {
                    errorCode = data.get(Parameter.ErrorCode).toString();
                }
                if (data.containsKey(Parameter.ErrorDetails)) {
                    errorMessage = data.get(Parameter.ErrorDetails).toString();
                }
                if (errorCode.equals(IngenicoBluetoothDevice.CARD_READER_DISCONNECTED_ERROR) && IngenicoBluetoothDevice.this.jsIsConnected()) {
                    IngenicoBluetoothDevice.this.status = ConnectionStatus.None;
                    IngenicoBluetoothDevice.this.disconnect(null);
                    PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                        @Override
                        public void run() {
                            IngenicoBluetoothDevice.this.impl.executeVoidFunction("onDisconnected", RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError(new Exception(IngenicoBluetoothDevice.CARD_READER_DISCONNECTED_ERROR))));
                        }
                    });
                }
                if (errorCode.equals(IngenicoBluetoothDevice.COMMAND_CANCELED_ERROR)) {
                    RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onResponse> Received Error with code: " + errorCode + ", details: " + errorMessage);
                } else {
                    RetailSDK.logToCal(logLevel.error, IngenicoBluetoothDevice.LOG_TAG, "onResponse> " + IngenicoBluetoothDevice.this.deviceLogId + " Received Error with code: " + errorCode + ", details: " + errorMessage);
                }
                IngenicoBluetoothDevice.this.invokeRequestCallback(new JsError(errorMessage, errorCode), null);
                return;
            }
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onResponse> responseCode: " + responseCode + ", cmd: " + cmd);
            switch (cmd) {
                case RawCommand: {
                    Object response = data.get(Parameter.RawResponse);
                    String hexResponse = response == null ? "" : response.toString();
                    RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "RAW COMMAND success: " + hexResponse);
                    IngenicoBluetoothDevice.this.invokeRequestCallback(null, hexResponse);
                    break;
                }
                case EnableFirmwareUpdateMode: {
                    String _enableFirmwareUpdateResponse = IngenicoBluetoothDevice.this.getResponseMap(data);
                    RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onResponse> EnableFirmwareUpdateMode: ");
                    IngenicoBluetoothDevice.this.invokeFwUpdateCallback(null, _enableFirmwareUpdateResponse);
                    break;
                }
                case UpdateFirmware: {
                    String _firmwareUpdateResponse = IngenicoBluetoothDevice.this.getResponseMap(data);
                    RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onResponse> UpdateFirmware: ");
                    IngenicoBluetoothDevice.this.invokeFwUpdateCallback(null, _firmwareUpdateResponse);
                    break;
                }
            }
        }

        public void onProgress(ProgressMessage messageType, String code) {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onProgress> messageType: " + messageType + ", code: " + code);
            if (messageType == null) {
                return;
            }
            if (messageType == ProgressMessage.SwipeErrorReswipeMagStripe) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onProgress> card swiped messageType: " + messageType + ",swipe has failed code: " + code);
                IngenicoBluetoothDevice.this.showSwipeFailedToast();
                return;
            }
            if (messageType == ProgressMessage.PleaseInsertCard) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onProgress> card swiped messageType: " + messageType + ", code: " + code);
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardSwiped, new JsError(messageType.toString(), code), null);
                return;
            }
            if (messageType == ProgressMessage.PleaseRemoveCard) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "Card inserted the wrong way");
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardInserted, new JsError(messageType.toString(), code), null);
                return;
            }
            if (messageType == ProgressMessage.MultipleContactlessCardsDetected || messageType == ProgressMessage.ContactlessInterfaceFailedTryContact || messageType == ProgressMessage.PleaseSeePhone) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "onProgress> card tapped messageType: " + messageType + ", code: " + code);
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardTapped, new JsError(messageType.toString(), code), null);
                return;
            }
            if (messageType == ProgressMessage.ICCErrorSwipeCard) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_TAG, "ICC Error from card insert");
                IngenicoBluetoothDevice.this.pushUnsolicitedResponseToJs(UnsolicitedEvent.CardInserted, new JsError(messageType.toString(), code), null);
                return;
            }
            if (messageType == ProgressMessage.UpdatingFirmware) {
                IngenicoBluetoothDevice.this.invokeFwUpdateProgressCallback(code);
            }
        }
    }

    private static class IngenicoDeviceScanner
    implements SearchListener {
        private DeviceManager ingenicoDeviceManager;
        private Device scannerDevice;

        private IngenicoDeviceScanner() {
        }

        public void onDeviceDiscovered(Device device) {
            if (device != null && device.getDeviceInfo().get(Parameter.BluetoothDeviceRssi) != null) {
                int rssival = (Integer)device.getDeviceInfo().get(Parameter.BluetoothDeviceRssi);
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, String.format(Locale.getDefault(), "onDeviceDiscovered Found Device: %s, RSSI = %d, DeviceType = %s", device.getName(), rssival, device.getDeviceType().getDisplayName()));
            }
            if (device != null && StringUtil.isNotEmpty(device.getName())) {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, "onDeviceDiscovered Found ingenico Device: " + device.getName());
                DeviceScanner.getInstance().onDiscovered(device.getName(), device.getIdentifier());
            } else {
                RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, String.format("onDeviceDiscovered NOT an ingenico Device: %s or it is too far", device != null ? device.getName() : "<null>"));
            }
        }

        private void createIngenicoBtDevice() {
            RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (IngenicoDeviceScanner.this.scannerDevice != null && StringUtil.isNotEmpty(IngenicoDeviceScanner.this.scannerDevice.getName())) {
                        RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, "Creating new IngenicoBluetoothDevice: " + IngenicoDeviceScanner.this.scannerDevice.getName());
                        IngenicoBluetoothDevice ingenicoBluetoothDevice = new IngenicoBluetoothDevice(IngenicoDeviceScanner.this.scannerDevice.getName(), IngenicoDeviceScanner.this.scannerDevice.getIdentifier(), IngenicoDeviceScanner.this.ingenicoDeviceManager);
                    }
                    IngenicoBluetoothDevice.setScanInProgress(false);
                }
            });
        }

        public void onDiscoveryComplete() {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, "IngenicoDeviceScanner onDiscoveryComplete");
            IngenicoBluetoothDevice.setScanInProgress(false);
            DeviceScanner.getInstance().scanRoamSwiper();
            DeviceScanner.getInstance().scanComplete(null, null);
        }

        void scanIngenicoDevices() {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, "scanIngenicoDevices");
            RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (IngenicoDeviceScanner.this.ingenicoDeviceManager == null) {
                        IngenicoDeviceScanner.this.ingenicoDeviceManager = RoamReaderUnifiedAPI.getDeviceManager((DeviceType)DeviceType.RP450c);
                    }
                    IngenicoDeviceScanner.this.scannerDevice = null;
                    IngenicoDeviceScanner.this.ingenicoDeviceManager.searchDevices(RetailSDK.sContext, Boolean.valueOf(false), (SearchListener)IngenicoDeviceScanner.this);
                }
            });
        }

        void cancelIngenicoDevicesSearch() {
            RetailSDK.log(logLevel.debug, IngenicoBluetoothDevice.LOG_SCAN_TAG, "Cancelling the Ingenico Device Search");
            this.ingenicoDeviceManager.cancelSearch();
            IngenicoBluetoothDevice.setScanInProgress(false);
        }
    }
}

