/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.IngenicoBluetoothDevice;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.RoamReaderUnifiedAPI;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.ProgressHandler;
import com.roam.roamreaderunifiedapi.callback.ReleaseHandler;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.data.Device;

class IngenicoDeviceConnectionManager {
    private static final String LOG_TAG = "native.ingenico.Manager";
    private IngenicoBluetoothDevice ingenicoBtDevice;
    private Device ingenicoDevice = null;
    private DeviceManager ingenicoDeviceManager;
    private final V8Function mCallback;

    IngenicoDeviceConnectionManager(IngenicoBluetoothDevice ingenicoDevice, String dName, String dAddr, DeviceManager deviceManager, V8Function callback) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "IngenicoDeviceConnectionManager create");
        this.ingenicoBtDevice = ingenicoDevice;
        this.ingenicoDeviceManager = deviceManager;
        this.mCallback = callback.twin();
        this.createIngenicoDevice(dName, dAddr);
    }

    void releaseDevice(final ReleaseHandler releaseHandler) {
        RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RetailSDK.log(logLevel.debug, IngenicoDeviceConnectionManager.LOG_TAG, "getIngenicoDeviceManager().release");
                IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager().release(releaseHandler);
            }
        });
    }

    void registerProgressHandler(final ProgressHandler handler) {
        RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RetailSDK.log(logLevel.debug, IngenicoDeviceConnectionManager.LOG_TAG, "getIngenicoDeviceManager().registerProgressHandler");
                IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager().registerProgressHandler(handler);
            }
        });
    }

    void unregisterProgressHandler(final ProgressHandler handler) {
        RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RetailSDK.log(logLevel.debug, IngenicoDeviceConnectionManager.LOG_TAG, "getIngenicoDeviceManager().unregisterProgressHandler");
                IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager().unregisterProgressHandler(handler);
            }
        });
    }

    Device getIngenicoDevice() {
        return this.ingenicoDevice;
    }

    DeviceManager getIngenicoDeviceManager() {
        return this.ingenicoDeviceManager;
    }

    void connectToDevice(final DeviceStatusHandler statusHandler) {
        RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager().getConfigurationManager().activateDevice(IngenicoDeviceConnectionManager.this.getIngenicoDevice());
                IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager().initialize(RetailSDK.sContext, statusHandler);
            }
        });
    }

    private void createIngenicoDevice(final String dName, final String dAddr) {
        RetailSDK.getAppState().getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (IngenicoDeviceConnectionManager.this.getIngenicoDeviceManager() == null) {
                    IngenicoDeviceConnectionManager.this.ingenicoDeviceManager = RoamReaderUnifiedAPI.getDeviceManager((DeviceType)DeviceType.RP450c);
                }
                IngenicoDeviceConnectionManager.this.ingenicoDevice = new Device(DeviceType.RP450c, CommunicationType.Bluetooth, dName, dAddr);
                RetailSDK.log(logLevel.debug, IngenicoDeviceConnectionManager.LOG_TAG, "Creating new IngenicoBluetoothDevice. Name= " + IngenicoDeviceConnectionManager.this.getIngenicoDevice().getName() + ", Address= " + dAddr);
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        IngenicoDeviceConnectionManager.this.ingenicoBtDevice.createJSReader();
                        IngenicoDeviceConnectionManager.this.mCallback.call(null, RetailSDK.jsArgs().pushNull().push((V8Value)((IngenicoDeviceConnectionManager)IngenicoDeviceConnectionManager.this).ingenicoBtDevice.impl));
                    }
                });
            }
        });
    }
}

