/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.IManticoreTypeConverter;
import com.paypal.paypalretailsdk.InvoiceAttachment;
import com.paypal.paypalretailsdk.InvoiceBillingInfo;
import com.paypal.paypalretailsdk.InvoiceCCInfo;
import com.paypal.paypalretailsdk.InvoiceCustomAmount;
import com.paypal.paypalretailsdk.InvoiceItem;
import com.paypal.paypalretailsdk.InvoiceMerchantInfo;
import com.paypal.paypalretailsdk.InvoiceMetaData;
import com.paypal.paypalretailsdk.InvoiceNotification;
import com.paypal.paypalretailsdk.InvoicePayment;
import com.paypal.paypalretailsdk.InvoicePaymentTerm;
import com.paypal.paypalretailsdk.InvoiceRefund;
import com.paypal.paypalretailsdk.InvoiceShippingInfo;
import com.paypal.paypalretailsdk.InvoiceStatus;
import com.paypal.paypalretailsdk.InvoiceTemplate;
import com.paypal.paypalretailsdk.PayPalError;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailInvoice;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class Invoice
extends PayPalRetailObject {
    Invoice(V8Object jsValue) {
        super(jsValue);
    }

    static Invoice nativeInstanceForObject(V8Object jsValue) {
        if (jsValue == null || jsValue.isUndefined()) {
            return null;
        }
        Object nativeClass = jsValue.get("_native");
        if (nativeClass == null || !(nativeClass instanceof String)) {
            return new Invoice(jsValue);
        }
        if ("InvoiceTemplate".equals(nativeClass)) {
            return new InvoiceTemplate(jsValue);
        }
        if ("RetailInvoice".equals(nativeClass)) {
            return new RetailInvoice(jsValue);
        }
        return new Invoice(jsValue);
    }

    public Invoice(final String currencyCode) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(currencyCode);
                Invoice.this.impl = PayPalRetailObject.getEngine().createJsObject("Invoice", args);
            }
        });
    }

    protected Invoice() {
    }

    public String getCurrency() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("currency");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _currency = Invoice.this.impl.getString("currency");
                return _currency;
            }
        });
    }

    public void setCurrency(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("currency", value);
            }
        });
    }

    public String getInvoiceDate() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("invoiceDate");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _invoiceDate = Invoice.this.impl.getString("invoiceDate");
                return _invoiceDate;
            }
        });
    }

    public void setInvoiceDate(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("invoiceDate", value);
            }
        });
    }

    public String getPayPalId() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("payPalId");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _payPalId = Invoice.this.impl.getString("payPalId");
                return _payPalId;
            }
        });
    }

    public String getNumber() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("number");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _number = Invoice.this.impl.getString("number");
                return _number;
            }
        });
    }

    public void setNumber(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("number", value);
            }
        });
    }

    public InvoiceStatus getStatus() {
        return (InvoiceStatus)((Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceStatus>(){

            @Override
            public InvoiceStatus call() {
                int _jsType = Invoice.this.impl.getType("status");
                if (_jsType == 99 || _jsType == 0) {
                    return InvoiceStatus.fromInt(0);
                }
                int _status = Invoice.this.impl.getInteger("status");
                return InvoiceStatus.fromInt(_status);
            }
        }));
    }

    public String getReference() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("reference");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _reference = Invoice.this.impl.getString("reference");
                return _reference;
            }
        });
    }

    public void setReference(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("reference", value);
            }
        });
    }

    public InvoiceMerchantInfo getMerchantInfo() {
        return (InvoiceMerchantInfo)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceMerchantInfo>(){

            @Override
            public InvoiceMerchantInfo call() {
                int _jsType = Invoice.this.impl.getType("merchantInfo");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _merchantInfo = Invoice.this.impl.getObject("merchantInfo");
                return (InvoiceMerchantInfo)PayPalRetailObject.getEngine().getConverter().asNative((Object)_merchantInfo, InvoiceMerchantInfo.class);
            }
        });
    }

    public void setMerchantInfo(final InvoiceMerchantInfo value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("merchantInfo", (V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)value));
            }
        });
    }

    public InvoiceBillingInfo getBillingInfo() {
        return (InvoiceBillingInfo)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceBillingInfo>(){

            @Override
            public InvoiceBillingInfo call() {
                int _jsType = Invoice.this.impl.getType("billingInfo");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _billingInfo = Invoice.this.impl.getObject("billingInfo");
                return (InvoiceBillingInfo)PayPalRetailObject.getEngine().getConverter().asNative((Object)_billingInfo, InvoiceBillingInfo.class);
            }
        });
    }

    public void setBillingInfo(final InvoiceBillingInfo value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("billingInfo", (V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)value));
            }
        });
    }

    public InvoiceShippingInfo getShippingInfo() {
        return (InvoiceShippingInfo)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceShippingInfo>(){

            @Override
            public InvoiceShippingInfo call() {
                int _jsType = Invoice.this.impl.getType("shippingInfo");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _shippingInfo = Invoice.this.impl.getObject("shippingInfo");
                return (InvoiceShippingInfo)PayPalRetailObject.getEngine().getConverter().asNative((Object)_shippingInfo, InvoiceShippingInfo.class);
            }
        });
    }

    public void setShippingInfo(final InvoiceShippingInfo value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("shippingInfo", (V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)value));
            }
        });
    }

    public Boolean getTaxInclusive() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("taxInclusive");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _taxInclusive = Invoice.this.impl.getBoolean("taxInclusive");
                return _taxInclusive;
            }
        });
    }

    public void setTaxInclusive(final Boolean value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("taxInclusive", value.booleanValue());
            }
        });
    }

    public Boolean getTaxCalculatedAfterDiscount() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("taxCalculatedAfterDiscount");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _taxCalculatedAfterDiscount = Invoice.this.impl.getBoolean("taxCalculatedAfterDiscount");
                return _taxCalculatedAfterDiscount;
            }
        });
    }

    public void setTaxCalculatedAfterDiscount(final Boolean value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("taxCalculatedAfterDiscount", value.booleanValue());
            }
        });
    }

    public List<InvoiceItem> getItems() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoiceItem>>(){

            @Override
            public List<InvoiceItem> call() {
                int _jsType = Invoice.this.impl.getType("items");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Array _items = Invoice.this.impl.getArray("items");
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(_items, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoiceItem>(){

                    public InvoiceItem convert(Object jsValue) {
                        return (InvoiceItem)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoiceItem.class);
                    }
                });
            }
        });
    }

    public void setItems(final List<InvoiceItem> value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("items", (V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(value, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<InvoiceItem>(){

                    public void push(V8Array dest, InvoiceItem nativeValue) {
                        dest.push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)nativeValue));
                    }
                }));
            }
        });
    }

    public Integer getItemCount() {
        return (Integer)Invoice.getEngine().getExecutor().run((Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                int _jsType = Invoice.this.impl.getType("itemCount");
                if (_jsType == 99 || _jsType == 0) {
                    return 0;
                }
                Integer _itemCount = Invoice.this.impl.getInteger("itemCount");
                return _itemCount;
            }
        });
    }

    public InvoicePaymentTerm getPaymentTerms() {
        return (InvoicePaymentTerm)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoicePaymentTerm>(){

            @Override
            public InvoicePaymentTerm call() {
                int _jsType = Invoice.this.impl.getType("paymentTerms");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _paymentTerms = Invoice.this.impl.getObject("paymentTerms");
                return (InvoicePaymentTerm)PayPalRetailObject.getEngine().getConverter().asNative((Object)_paymentTerms, InvoicePaymentTerm.class);
            }
        });
    }

    public void setPaymentTerms(final InvoicePaymentTerm value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("paymentTerms", (V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)value));
            }
        });
    }

    public BigDecimal getGratuityAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("gratuityAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _gratuityAmount = Invoice.this.impl.getObject("gratuityAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_gratuityAmount);
            }
        });
    }

    public void setGratuityAmount(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("gratuityAmount", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public BigDecimal getDiscountAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("discountAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _discountAmount = Invoice.this.impl.getObject("discountAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_discountAmount);
            }
        });
    }

    public void setDiscountAmount(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("discountAmount", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public BigDecimal getMinimumAmountDue() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("minimumAmountDue");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _minimumAmountDue = Invoice.this.impl.getObject("minimumAmountDue");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_minimumAmountDue);
            }
        });
    }

    public void setMinimumAmountDue(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("minimumAmountDue", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public BigDecimal getDiscountPercentage() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("discountPercentage");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _discountPercentage = Invoice.this.impl.getObject("discountPercentage");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_discountPercentage);
            }
        });
    }

    public void setDiscountPercentage(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("discountPercentage", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public String getNote() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("note");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _note = Invoice.this.impl.getString("note");
                return _note;
            }
        });
    }

    public void setNote(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("note", value);
            }
        });
    }

    public BigDecimal getShippingAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("shippingAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _shippingAmount = Invoice.this.impl.getObject("shippingAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_shippingAmount);
            }
        });
    }

    public void setShippingAmount(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("shippingAmount", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public BigDecimal getShippingTaxRate() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("shippingTaxRate");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _shippingTaxRate = Invoice.this.impl.getObject("shippingTaxRate");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_shippingTaxRate);
            }
        });
    }

    public void setShippingTaxRate(final BigDecimal value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("shippingTaxRate", PayPalRetailObject.getEngine().getConverter().asJsDecimal(value));
            }
        });
    }

    public String getShippingTaxName() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("shippingTaxName");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _shippingTaxName = Invoice.this.impl.getString("shippingTaxName");
                return _shippingTaxName;
            }
        });
    }

    public void setShippingTaxName(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("shippingTaxName", value);
            }
        });
    }

    public String getTermsAndConditions() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("termsAndConditions");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _termsAndConditions = Invoice.this.impl.getString("termsAndConditions");
                return _termsAndConditions;
            }
        });
    }

    public void setTermsAndConditions(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("termsAndConditions", value);
            }
        });
    }

    public String getMerchantMemo() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("merchantMemo");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _merchantMemo = Invoice.this.impl.getString("merchantMemo");
                return _merchantMemo;
            }
        });
    }

    public void setMerchantMemo(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("merchantMemo", value);
            }
        });
    }

    public Boolean getIsDirtyFromServer() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("isDirtyFromServer");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _isDirtyFromServer = Invoice.this.impl.getBoolean("isDirtyFromServer");
                return _isDirtyFromServer;
            }
        });
    }

    public Boolean getHasDetails() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("hasDetails");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _hasDetails = Invoice.this.impl.getBoolean("hasDetails");
                return _hasDetails;
            }
        });
    }

    public BigDecimal getTotal() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("total");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _total = Invoice.this.impl.getObject("total");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_total);
            }
        });
    }

    public BigDecimal getSubTotal() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("subTotal");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _subTotal = Invoice.this.impl.getObject("subTotal");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_subTotal);
            }
        });
    }

    public BigDecimal getItemTax() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("itemTax");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _itemTax = Invoice.this.impl.getObject("itemTax");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_itemTax);
            }
        });
    }

    public BigDecimal getItemDiscounts() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("itemDiscounts");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _itemDiscounts = Invoice.this.impl.getObject("itemDiscounts");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_itemDiscounts);
            }
        });
    }

    public BigDecimal getDiscountPrice() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("discountPrice");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _discountPrice = Invoice.this.impl.getObject("discountPrice");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_discountPrice);
            }
        });
    }

    public BigDecimal getTotalDiscount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("totalDiscount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _totalDiscount = Invoice.this.impl.getObject("totalDiscount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_totalDiscount);
            }
        });
    }

    public Map<String, ? super Object> getTaxBreakdown() {
        return (Map)Invoice.getEngine().getExecutor().run((Callable)new Callable<Map<String, ? super Object>>(){

            @Override
            public Map<String, ? super Object> call() {
                int _jsType = Invoice.this.impl.getType("taxBreakdown");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _taxBreakdown = Invoice.this.impl.getObject("taxBreakdown");
                return PayPalRetailObject.getEngine().getConverter().asNativeObject(_taxBreakdown);
            }
        });
    }

    public Boolean getAllowPartialPayment() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("allowPartialPayment");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _allowPartialPayment = Invoice.this.impl.getBoolean("allowPartialPayment");
                return _allowPartialPayment;
            }
        });
    }

    public void setAllowPartialPayment(final Boolean value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("allowPartialPayment", value.booleanValue());
            }
        });
    }

    public List<InvoiceCCInfo> getCCInfo() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoiceCCInfo>>(){

            @Override
            public List<InvoiceCCInfo> call() {
                int _jsType = Invoice.this.impl.getType("CCInfo");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Array _CCInfo = Invoice.this.impl.getArray("CCInfo");
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(_CCInfo, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoiceCCInfo>(){

                    public InvoiceCCInfo convert(Object jsValue) {
                        return (InvoiceCCInfo)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoiceCCInfo.class);
                    }
                });
            }
        });
    }

    public void setCCInfo(final List<InvoiceCCInfo> value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("CCInfo", (V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(value, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<InvoiceCCInfo>(){

                    public void push(V8Array dest, InvoiceCCInfo nativeValue) {
                        dest.push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)nativeValue));
                    }
                }));
            }
        });
    }

    public List<InvoicePayment> getPayments() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoicePayment>>(){

            @Override
            public List<InvoicePayment> call() {
                int _jsType = Invoice.this.impl.getType("payments");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Array _payments = Invoice.this.impl.getArray("payments");
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(_payments, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoicePayment>(){

                    public InvoicePayment convert(Object jsValue) {
                        return (InvoicePayment)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoicePayment.class);
                    }
                });
            }
        });
    }

    public List<InvoiceRefund> getRefunds() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoiceRefund>>(){

            @Override
            public List<InvoiceRefund> call() {
                int _jsType = Invoice.this.impl.getType("refunds");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Array _refunds = Invoice.this.impl.getArray("refunds");
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(_refunds, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoiceRefund>(){

                    public InvoiceRefund convert(Object jsValue) {
                        return (InvoiceRefund)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoiceRefund.class);
                    }
                });
            }
        });
    }

    public BigDecimal getPaidAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("paidAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _paidAmount = Invoice.this.impl.getObject("paidAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_paidAmount);
            }
        });
    }

    public BigDecimal getPaidAmountPayPal() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("paidAmountPayPal");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _paidAmountPayPal = Invoice.this.impl.getObject("paidAmountPayPal");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_paidAmountPayPal);
            }
        });
    }

    public BigDecimal getPaidAmountOther() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("paidAmountOther");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _paidAmountOther = Invoice.this.impl.getObject("paidAmountOther");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_paidAmountOther);
            }
        });
    }

    public BigDecimal getRefundedAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("refundedAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _refundedAmount = Invoice.this.impl.getObject("refundedAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_refundedAmount);
            }
        });
    }

    public BigDecimal getRefundedAmountPayPal() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("refundedAmountPayPal");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _refundedAmountPayPal = Invoice.this.impl.getObject("refundedAmountPayPal");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_refundedAmountPayPal);
            }
        });
    }

    public BigDecimal getRefundedAmountOther() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("refundedAmountOther");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _refundedAmountOther = Invoice.this.impl.getObject("refundedAmountOther");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_refundedAmountOther);
            }
        });
    }

    public BigDecimal getRemainingAmount() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("remainingAmount");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _remainingAmount = Invoice.this.impl.getObject("remainingAmount");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_remainingAmount);
            }
        });
    }

    public BigDecimal getAmountPaidNet() {
        return (BigDecimal)Invoice.getEngine().getExecutor().run((Callable)new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() {
                int _jsType = Invoice.this.impl.getType("amountPaidNet");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _amountPaidNet = Invoice.this.impl.getObject("amountPaidNet");
                return PayPalRetailObject.getEngine().getConverter().asNativeDecimal(_amountPaidNet);
            }
        });
    }

    public Boolean getHasBeenPaid() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("hasBeenPaid");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _hasBeenPaid = Invoice.this.impl.getBoolean("hasBeenPaid");
                return _hasBeenPaid;
            }
        });
    }

    public String getUri() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("uri");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _uri = Invoice.this.impl.getString("uri");
                return _uri;
            }
        });
    }

    public void setUri(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("uri", value);
            }
        });
    }

    public String getLogoURL() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("logoURL");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _logoURL = Invoice.this.impl.getString("logoURL");
                return _logoURL;
            }
        });
    }

    public void setLogoURL(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("logoURL", value);
            }
        });
    }

    public String getAdditionalData() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("additionalData");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _additionalData = Invoice.this.impl.getString("additionalData");
                return _additionalData;
            }
        });
    }

    public void setAdditionalData(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("additionalData", value);
            }
        });
    }

    public InvoiceCustomAmount getCustom() {
        return (InvoiceCustomAmount)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceCustomAmount>(){

            @Override
            public InvoiceCustomAmount call() {
                int _jsType = Invoice.this.impl.getType("custom");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _custom = Invoice.this.impl.getObject("custom");
                return (InvoiceCustomAmount)PayPalRetailObject.getEngine().getConverter().asNative((Object)_custom, InvoiceCustomAmount.class);
            }
        });
    }

    public void setCustom(final InvoiceCustomAmount value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("custom", (V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)value));
            }
        });
    }

    public InvoiceMetaData getMetadata() {
        return (InvoiceMetaData)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceMetaData>(){

            @Override
            public InvoiceMetaData call() {
                int _jsType = Invoice.this.impl.getType("metadata");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _metadata = Invoice.this.impl.getObject("metadata");
                return (InvoiceMetaData)PayPalRetailObject.getEngine().getConverter().asNative((Object)_metadata, InvoiceMetaData.class);
            }
        });
    }

    public Boolean getWasDeleted() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("wasDeleted");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _wasDeleted = Invoice.this.impl.getBoolean("wasDeleted");
                return _wasDeleted;
            }
        });
    }

    public void setWasDeleted(final Boolean value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("wasDeleted", value.booleanValue());
            }
        });
    }

    public List<InvoiceAttachment> getAttachments() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoiceAttachment>>(){

            @Override
            public List<InvoiceAttachment> call() {
                int _jsType = Invoice.this.impl.getType("attachments");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Array _attachments = Invoice.this.impl.getArray("attachments");
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(_attachments, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoiceAttachment>(){

                    public InvoiceAttachment convert(Object jsValue) {
                        return (InvoiceAttachment)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoiceAttachment.class);
                    }
                });
            }
        });
    }

    public void setAttachments(final List<InvoiceAttachment> value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("attachments", (V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(value, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<InvoiceAttachment>(){

                    public void push(V8Array dest, InvoiceAttachment nativeValue) {
                        dest.push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)nativeValue));
                    }
                }));
            }
        });
    }

    public String getTemplateID() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("templateID");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _templateID = Invoice.this.impl.getString("templateID");
                return _templateID;
            }
        });
    }

    public void setTemplateID(final String value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("templateID", value);
            }
        });
    }

    public Boolean getIsPastDue() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("isPastDue");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _isPastDue = Invoice.this.impl.getBoolean("isPastDue");
                return _isPastDue;
            }
        });
    }

    public String getPayerViewUrl() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = Invoice.this.impl.getType("payerViewUrl");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _payerViewUrl = Invoice.this.impl.getString("payerViewUrl");
                return _payerViewUrl;
            }
        });
    }

    public Boolean getAllowTip() {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = Invoice.this.impl.getType("allowTip");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _allowTip = Invoice.this.impl.getBoolean("allowTip");
                return _allowTip;
            }
        });
    }

    public void setAllowTip(final Boolean value) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                Invoice.this.impl.add("allowTip", value.booleanValue());
            }
        });
    }

    public static Invoice withInvoice(final Invoice invoice) {
        return (Invoice)Invoice.getEngine().getExecutor().run((Callable)new Callable<Invoice>(){

            @Override
            public Invoice call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)invoice));
                V8Object objectToExecuteOn = PayPalRetailObject.getEngine().getJSClass("Invoice");
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("withInvoice", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (Invoice)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, Invoice.class);
            }
        });
    }

    public static List<String> supportedCurrencies() {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() {
                V8Array retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = PayPalRetailObject.getEngine().getJSClass("Invoice");
                try {
                    retVal = objectToExecuteOn.executeArrayFunction("supportedCurrencies", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(retVal, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<String>(){

                    public String convert(Object jsValue) {
                        return (String)jsValue;
                    }
                });
            }
        });
    }

    public Invoice duplicate() {
        return (Invoice)Invoice.getEngine().getExecutor().run((Callable)new Callable<Invoice>(){

            @Override
            public Invoice call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("duplicate", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (Invoice)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, Invoice.class);
            }
        });
    }

    public List<InvoiceAttachment> addAttachment(final InvoiceAttachment attachment) {
        return (List)Invoice.getEngine().getExecutor().run((Callable)new Callable<List<InvoiceAttachment>>(){

            @Override
            public List<InvoiceAttachment> call() {
                V8Array retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)attachment));
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeArrayFunction("addAttachment", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return PayPalRetailObject.getEngine().getConverter().toNativeArray(retVal, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<InvoiceAttachment>(){

                    public InvoiceAttachment convert(Object jsValue) {
                        return (InvoiceAttachment)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, InvoiceAttachment.class);
                    }
                });
            }
        });
    }

    public Boolean removeAttachment(final InvoiceAttachment attachment) {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)attachment));
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("removeAttachment", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public InvoiceItem addItem(final String name, final BigDecimal quantity, final BigDecimal unitPrice, final Integer itemId, final String detailId) {
        return (InvoiceItem)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceItem>(){

            @Override
            public InvoiceItem call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(name).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(quantity)).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(unitPrice)).push(itemId.intValue()).push(detailId);
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("addItem", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (InvoiceItem)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, InvoiceItem.class);
            }
        });
    }

    public InvoiceItem addInvoiceItem(final InvoiceItem item) {
        return (InvoiceItem)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceItem>(){

            @Override
            public InvoiceItem call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)item));
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("addInvoiceItem", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (InvoiceItem)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, InvoiceItem.class);
            }
        });
    }

    public Boolean deepEqual(final Invoice invoice) {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)invoice));
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("deepEqual", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public void removeAllItems() {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("removeAllItems", args);
            }
        });
    }

    public Boolean removeItem(final InvoiceItem item) {
        return (Boolean)Invoice.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)item));
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("removeItem", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public InvoiceItem findItem(final Integer itemId, final String detailId) {
        return (InvoiceItem)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceItem>(){

            @Override
            public InvoiceItem call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(itemId.intValue()).push(detailId);
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("findItem", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (InvoiceItem)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, InvoiceItem.class);
            }
        });
    }

    public InvoiceItem getItem(final Integer itemIndex) {
        return (InvoiceItem)Invoice.getEngine().getExecutor().run((Callable)new Callable<InvoiceItem>(){

            @Override
            public InvoiceItem call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(itemIndex.intValue());
                V8Object objectToExecuteOn = Invoice.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("getItem", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (InvoiceItem)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, InvoiceItem.class);
            }
        });
    }

    public void getDetails(final GotDetailsCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("getDetails", args);
            }
        });
    }

    public void save(final SavedCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("save", args);
            }
        });
    }

    public void update(final Boolean shouldNotifyMerchant, final Boolean shouldNotifyCustomer, final SavedCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(shouldNotifyMerchant.booleanValue()).push(shouldNotifyCustomer.booleanValue()).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("update", args);
            }
        });
    }

    public void send(final Boolean shouldNotifyMerchant, final SentCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(shouldNotifyMerchant.booleanValue()).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("send", args);
            }
        });
    }

    public void deleteFromServer(final DeletedCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("deleteFromServer", args);
            }
        });
    }

    public void remind(final InvoiceNotification notification, final RemindedCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)notification)).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("remind", args);
            }
        });
    }

    public void cancel(final InvoiceNotification notification, final CancelledCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)notification)).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("cancel", args);
            }
        });
    }

    public void recordPayment(final InvoicePayment paymentInfo, final PaidCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)paymentInfo)).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("recordPayment", args);
            }
        });
    }

    public void recordRefund(final InvoiceRefund refundInfo, final PaidCallback callback) {
        Invoice.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)refundInfo)).push((V8Value)Invoice.wrapJavaFn(callback));
                V8Object objectToExecuteOn = Invoice.this.impl;
                objectToExecuteOn.executeVoidFunction("recordRefund", args);
            }
        });
    }

    public String toString() {
        return (String)Invoice.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                V8Object objectToExecuteOn = PayPalRetailObject.getEngine().getJsObject("JSON");
                V8Object objectStringify = Invoice.this.impl;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)objectStringify);
                String retVal = objectToExecuteOn.executeStringFunction("stringify", args);
                return retVal;
            }
        });
    }

    private static V8Object wrapJavaFn(final GotDetailsCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.gotDetails(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final SavedCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.saved(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final SentCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.sent(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final DeletedCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.deleted(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final RemindedCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.reminded(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final CancelledCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.cancelled(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final PaidCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.paid(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final RefundedCallback javaInterface) {
        return (V8Object)Invoice.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        PayPalError _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (PayPalError)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, PayPalError.class);
                        }
                        javaInterface.refunded(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    public static interface RefundedCallback {
        public void refunded(PayPalError var1);
    }

    public static interface PaidCallback {
        public void paid(PayPalError var1);
    }

    public static interface CancelledCallback {
        public void cancelled(PayPalError var1);
    }

    public static interface RemindedCallback {
        public void reminded(PayPalError var1);
    }

    public static interface DeletedCallback {
        public void deleted(PayPalError var1);
    }

    public static interface SentCallback {
        public void sent(PayPalError var1);
    }

    public static interface SavedCallback {
        public void saved(PayPalError var1);
    }

    public static interface GotDetailsCallback {
        public void gotDetails(PayPalError var1);
    }
}

