/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.github.tony19.timber.loggly.LogglyTree;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import java.util.ArrayList;
import timber.log.Timber;

public class Loggly {
    private static final String LOG_TAG = Loggly.class.getSimpleName();
    private static boolean sIsInitialized = false;
    private static boolean sEnableDebug = false;
    private static ArrayList<String> mTagsList = new ArrayList();
    private static Loggly sInstance;

    private Loggly() {
    }

    public static Loggly getInstance() {
        if (sInstance == null) {
            sInstance = new Loggly();
        }
        return sInstance;
    }

    public void initialize(String token) {
        if (sIsInitialized) {
            Log.d((String)LOG_TAG, (String)"it is already initialized.");
            return;
        }
        if (token == null) {
            Log.d((String)LOG_TAG, (String)"token is NULL!");
            return;
        }
        Log.d((String)LOG_TAG, (String)"received token.");
        Timber.plant((Timber.Tree)new LogglyTree(token));
        this.addTags();
        sIsInitialized = true;
    }

    public static void setDebugFlag(boolean doEnable) {
        sEnableDebug = doEnable;
    }

    private void addTags() {
        if (RetailSDK.getAppEnvInfo() != null) {
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getAppName())) {
                mTagsList.add("appName_" + RetailSDK.getAppEnvInfo().getAppName());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getAppBuild())) {
                mTagsList.add("appBuild_" + RetailSDK.getAppEnvInfo().getAppBuild());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getOsName())) {
                mTagsList.add("os_" + RetailSDK.getAppEnvInfo().getOsName());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getOsVersion())) {
                mTagsList.add("osVersion_" + RetailSDK.getAppEnvInfo().getOsVersion());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getMerchantId())) {
                mTagsList.add("merchantId_" + RetailSDK.getAppEnvInfo().getMerchantId());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getEnvironment())) {
                mTagsList.add("env_" + RetailSDK.getAppEnvInfo().getEnvironment());
            }
            if (StringUtil.isNotEmpty(RetailSDK.getAppEnvInfo().getCurrency())) {
                mTagsList.add("currency_" + RetailSDK.getAppEnvInfo().getCurrency());
            }
            mTagsList.add("deviceManufacturer_" + Build.MANUFACTURER);
            mTagsList.add("deviceModel_" + Build.MODEL);
            if (StringUtil.isNotEmpty(RetailSDK.getSdkVersion())) {
                mTagsList.add(RetailSDK.getSdkVersion());
            }
        }
    }

    public void log(String level, String component, Object message) {
        if (!sIsInitialized) {
            Log.d((String)LOG_TAG, (String)"NOT initialized so NOT logging yet!!! ");
            return;
        }
        try {
            ArrayList<String> newTagsList = new ArrayList<String>(mTagsList);
            newTagsList.add(component);
            String tag = TextUtils.join((CharSequence)",", newTagsList);
            Timber.tag((String)tag);
            String messageVal = message.toString();
            if ("ERROR".equalsIgnoreCase(level)) {
                Timber.e((String)messageVal, (Object[])new Object[0]);
            } else if ("WARN".equalsIgnoreCase(level)) {
                Timber.w((String)messageVal, (Object[])new Object[0]);
            } else if ("INFO".equalsIgnoreCase(level)) {
                Timber.i((String)messageVal, (Object[])new Object[0]);
            } else if (sEnableDebug) {
                Timber.d((String)messageVal, (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)("PayPalRetailSDK:" + component), (String)e.getMessage());
            e.printStackTrace();
        }
    }
}

