/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothSocket;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.BluetoothDevice;
import com.paypal.paypalretailsdk.NativeInterface;
import com.paypal.paypalretailsdk.PayPalError;
import com.paypal.paypalretailsdk.PayPalHereSdkError;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.PaymentDevice;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

class MiuraBluetoothDevice
extends PayPalRetailObject
implements BluetoothDevice {
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final String LOG_TAG = MiuraBluetoothDevice.class.getSimpleName();
    private ConnectionStatus status = ConnectionStatus.None;
    private android.bluetooth.BluetoothDevice device;
    private BluetoothSocket socket;
    private InputStream deviceIn;
    private V8Object nativeReader;
    private Thread readerThread;

    MiuraBluetoothDevice(android.bluetooth.BluetoothDevice device) {
        this.device = device;
    }

    void createJSReader() {
        this.nativeReader = PayPalRetailObject.getEngine().createJsObject();
        this.nativeReader.registerJavaMethod((Object)this, "isConnected", "isConnected", null);
        this.nativeReader.registerJavaMethod((Object)this, "jsConnect", "connect", new Class[]{V8Function.class});
        this.nativeReader.registerJavaMethod((Object)this, "jsDisconnect", "disconnect", new Class[]{V8Function.class});
        this.nativeReader.registerJavaMethod((Object)this, "send", "send", new Class[]{Object.class, V8Object.class});
        this.nativeReader.registerJavaMethod((Object)this, "jsRemoved", "removed", new Class[]{V8Function.class});
        final V8Object deviceBuilder = PayPalRetailObject.getEngine().createJsObject("DeviceBuilder", RetailSDK.jsArgs());
        final V8Array args = MiuraBluetoothDevice.getEngine().createJsArray().push("MIURA").push(this.device.getName()).push(false).push((V8Value)this.nativeReader).pushNull().push(this.device.getAddress());
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                MiuraBluetoothDevice.this.impl = deviceBuilder.executeObjectFunction("build", args);
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        RetailSDK.getJsSdk().discoveredPaymentDevice(new PaymentDevice(MiuraBluetoothDevice.this.impl));
                    }
                });
            }
        });
    }

    private void connectRfComm() throws IOException {
        this.socket = this.device.createInsecureRfcommSocketToServiceRecord(MY_UUID);
        this.socket.connect();
        this.startReadLoop(3);
    }

    private void forceDisconnect(final Exception ioException) {
        RetailSDK.log(logLevel.error, LOG_TAG, "Forcing disconnect on " + this.device.getName() + " due to " + ioException);
        ioException.printStackTrace();
        this.disconnect();
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                MiuraBluetoothDevice.this.impl.executeVoidFunction("onDisconnected", RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError(ioException)));
            }
        });
    }

    private void startReadLoop(final int remainingAttempts) throws IOException {
        final InputStream myDevice = this.deviceIn = this.socket.getInputStream();
        this.readerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[2048];
                while (MiuraBluetoothDevice.this.deviceIn == myDevice) {
                    try {
                        int bytes = MiuraBluetoothDevice.this.deviceIn.read(buffer);
                        if (bytes <= 0) continue;
                        final String base64Buffer = Base64.encodeToString((byte[])buffer, (int)0, (int)bytes, (int)2);
                        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

                            @Override
                            public void run() {
                                MiuraBluetoothDevice.this.impl.executeVoidFunction("received", RetailSDK.jsArgs().push(base64Buffer));
                            }
                        });
                    }
                    catch (IOException ioException) {
                        if (!MiuraBluetoothDevice.this.isConnected()) {
                            RetailSDK.log(logLevel.warn, LOG_TAG, "Device disconnected. Exiting read loop on " + MiuraBluetoothDevice.this.device.getName() + " with exception " + ioException);
                            return;
                        }
                        RetailSDK.log(logLevel.warn, LOG_TAG, "IOException from startReadLoop (Remaining attempts : " + remainingAttempts + ") on " + MiuraBluetoothDevice.this.device.getName() + ", " + ioException);
                        if (remainingAttempts > 0) {
                            try {
                                MiuraBluetoothDevice.this.startReadLoop(remainingAttempts - 1);
                            }
                            catch (Exception ex) {
                                MiuraBluetoothDevice.this.forceDisconnect(ex);
                            }
                        } else {
                            MiuraBluetoothDevice.this.forceDisconnect(ioException);
                        }
                        return;
                    }
                    catch (Exception ex) {
                        RetailSDK.log(logLevel.error, LOG_TAG, "Exception from startReadLoop on " + MiuraBluetoothDevice.this.device.getName() + ", " + ex);
                    }
                }
            }
        });
        this.readerThread.start();
    }

    private void disconnect() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "Disconnecting " + this.device.getName());
        if (this.socket != null) {
            this.status = ConnectionStatus.None;
            try {
                this.readerThread.interrupt();
            }
            catch (Exception x) {
                Log.d((String)LOG_TAG, (String)("Error on interrupting read loop " + x));
            }
            try {
                this.deviceIn.close();
            }
            catch (Exception x) {
                Log.d((String)LOG_TAG, (String)("Error on closing device input stream " + x));
            }
            try {
                this.socket.close();
            }
            catch (Exception x) {
                Log.d((String)LOG_TAG, (String)("Error on closing bt socket " + x));
            }
            this.socket = null;
            this.deviceIn = null;
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.status == ConnectionStatus.Connected;
    }

    private boolean isPairedToDevice() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return true;
        }
        Set devices = adapter.getBondedDevices();
        if (devices == null) {
            return false;
        }
        HashSet<String> deviceAddress = new HashSet<String>();
        for (android.bluetooth.BluetoothDevice d : devices) {
            deviceAddress.add(d.getAddress());
        }
        return deviceAddress.contains(this.device.getAddress());
    }

    public void jsConnect(V8Function jsCallback) {
        final V8Function callback = jsCallback.twin();
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MiuraBluetoothDevice.this.isPairedToDevice()) {
                    RetailSDK.log(logLevel.debug, LOG_TAG, "Device " + MiuraBluetoothDevice.this.device.getName() + " not paired to the phone");
                    MiuraBluetoothDevice.this.sendConnectionStatus(PayPalHereSdkError.CardReaderNotAvailable.getError(), callback);
                    return;
                }
                if (!MiuraBluetoothDevice.this.isConnected()) {
                    IOException err = null;
                    try {
                        MiuraBluetoothDevice.this.connectRfComm();
                    }
                    catch (IOException x) {
                        RetailSDK.logToCal(logLevel.error, LOG_TAG, NativeInterface.buildDevId(MiuraBluetoothDevice.this.device.getName(), MiuraBluetoothDevice.this.device.getAddress()) + " connection failed with error " + x.toString());
                        err = x;
                    }
                    MiuraBluetoothDevice.this.sendConnectionStatus(err, callback);
                }
            }
        });
    }

    private void sendConnectionStatus(final PayPalError err, final V8Function callback) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                V8Array args = RetailSDK.jsArgs();
                if (err == null) {
                    args.pushUndefined();
                } else {
                    args.push((V8Value)err.impl);
                }
                MiuraBluetoothDevice.this.status = err == null ? ConnectionStatus.Connected : ConnectionStatus.None;
                callback.call(MiuraBluetoothDevice.this.nativeReader, args);
            }
        });
    }

    private void sendConnectionStatus(final IOException err, final V8Function callback) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                V8Array args = RetailSDK.jsArgs();
                if (err == null) {
                    args.pushUndefined();
                } else {
                    args.push((V8Value)PayPalRetailObject.getEngine().asJsError(err.getMessage(), "-1", Arrays.toString(err.getStackTrace())));
                }
                MiuraBluetoothDevice.this.status = err == null ? ConnectionStatus.Connected : ConnectionStatus.None;
                callback.call(MiuraBluetoothDevice.this.nativeReader, args);
            }
        });
    }

    public void jsDisconnect(V8Function jsCallback) {
        if (this.isConnected()) {
            this.disconnect();
        }
        final V8Function callback = jsCallback.twin();
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                callback.call(MiuraBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
            }
        });
    }

    public void jsRemoved(V8Function jsCallback) {
        if (this.isConnected()) {
            this.disconnect();
        }
        RetailSDK.log(logLevel.debug, LOG_TAG, "jsRemoved triggered for : " + this.device.getName());
        final V8Function callback = jsCallback.twin();
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                callback.call(MiuraBluetoothDevice.this.nativeReader, RetailSDK.jsArgs().pushUndefined());
            }
        });
    }

    @Override
    public void removePaymentDevice() {
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                MiuraBluetoothDevice.this.impl.executeVoidFunction("removed", RetailSDK.jsArgs().pushUndefined());
            }
        });
    }

    public boolean send(Object data, V8Object callback) {
        byte[] decoded;
        if (data instanceof String) {
            decoded = Base64.decode((String)data.toString(), (int)0);
        } else {
            V8Object dataInfo = (V8Object)data;
            int offset = dataInfo.getInteger("offset");
            int len = dataInfo.getInteger("len");
            decoded = Arrays.copyOfRange(Base64.decode((String)dataInfo.getString("data"), (int)0), offset, len + offset);
        }
        V8Function jsCallback = null;
        if (callback != null && !callback.isUndefined()) {
            jsCallback = (V8Function)callback;
        }
        try {
            this.socket.getOutputStream().write(decoded);
            if (jsCallback != null && !jsCallback.isUndefined()) {
                jsCallback.call(this.nativeReader, RetailSDK.jsArgs().pushUndefined());
            }
            return true;
        }
        catch (IOException x) {
            if (jsCallback != null && !jsCallback.isUndefined()) {
                jsCallback.call(this.nativeReader, RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError((Exception)x)));
            }
            return false;
        }
    }

    static enum ConnectionStatus {
        None,
        Connecting,
        Connected;

    }
}

