/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.SharedPreferences;
import android.location.Location;
import android.util.Base64;
import android.util.Log;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.ManticoreEngine;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.DeviceConnectorOptions;
import com.paypal.paypalretailsdk.IngenicoBluetoothDevice;
import com.paypal.paypalretailsdk.Loggly;
import com.paypal.paypalretailsdk.MiuraBluetoothDevice;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ReceiptViewContent;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.RoamSwiperDevice;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.AudioJackManager;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.DeviceConnectionProxy;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderPresenter;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogProxy;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptOptionsPresenter;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;
import com.paypal.paypalretailsdk.ui.signature.SignaturePresenter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class NativeInterface {
    private static final String logComponent = "RetailSDKNative";
    private static String SECURE_TYPE = "S";
    private static String STRING_TYPE = "V";
    private static String SECURE_BLOB_TYPE = "E";
    private static String BLOB_TYPE = "B";
    private static String BLOB_DECODED_TYPE = "BD";
    private ManticoreEngine engine;
    private static NativeInterface sInstance;
    private final Set<String> logLevels = new HashSet<String>();

    private NativeInterface() {
        for (logLevel logLevel2 : logLevel.values()) {
            this.logLevels.add(logLevel2.name().toLowerCase());
        }
    }

    public static NativeInterface getInstance() {
        if (sInstance == null) {
            sInstance = new NativeInterface();
        }
        return sInstance;
    }

    public void inspect(Object object) {
        Log.d((String)logComponent, (String)object.toString());
    }

    public void ready(V8Object sdk) {
        RetailSDK.setJsSdk(sdk);
    }

    public V8Object alert(V8Object options, V8Function callback) {
        return SDKDialogProxy.displayAlert((V8Object)options, (V8Function)callback).impl.twin();
    }

    public V8Object jsScanAndDiscover(V8Object options, V8Function cb) {
        final V8Function onCompleteCallback = cb.twin();
        Log.d((String)logComponent, (String)"scanAndDiscover");
        DeviceConnectionProxy mDeviceConnectionProxy = DeviceConnectionProxy.getInstance();
        try {
            DeviceConnectionActivity.setScanJsInterfaces(CardReaderScanAndDiscoverOptions.nativeInstanceForObject(options.twin()), new ScanReadersPresenter.OnScanResult(){

                @Override
                public void doAction(final String action) {
                    PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                        @Override
                        public void run() {
                            onCompleteCallback.call(null, RetailSDK.jsArgs().push(action));
                        }
                    });
                }
            });
            RetailSDK.getAppState().getCurrentActivity().startActivity(mDeviceConnectionProxy.createGenericIntent().putExtra("PRESENTER_TO_OPEN", "SCAN"));
            return null;
        }
        catch (Exception ex) {
            Log.e((String)logComponent, (String)ex.toString());
            return null;
        }
    }

    public V8Object jsConnectLastReaderPrompt(V8Object options, V8Function callback) {
        DeviceConnectionProxy mDeviceConnectionProxy = DeviceConnectionProxy.getInstance();
        final V8Function onCompleteCallback = callback.twin();
        try {
            DeviceConnectionActivity.setConnectJsInterfaces(DeviceConnectorOptions.nativeInstanceForObject(options.twin()), new ConnectReaderPresenter.OnActivityResult(){

                @Override
                public void doAction(final String action) {
                    PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                        @Override
                        public void run() {
                            onCompleteCallback.call(null, RetailSDK.jsArgs().push(action));
                        }
                    });
                }
            });
            RetailSDK.getAppState().getCurrentActivity().startActivity(mDeviceConnectionProxy.createGenericIntent().putExtra("PRESENTER_TO_OPEN", "CONNECT_READER"));
            return mDeviceConnectionProxy.impl.twin();
        }
        catch (Exception ex) {
            Log.e((String)logComponent, (String)ex.toString());
            return null;
        }
    }

    public V8Object collectSignature(V8Object options, V8Function callback) {
        Log.d((String)logComponent, (String)"collectSignature");
        SDKDialogProxy.clearAlertDialog();
        V8Object signatureHandle = SignaturePresenter.getInstance().showActivity(null, options, callback);
        return signatureHandle;
    }

    public void offerReceipt(V8Object options, V8Function callback) {
        Log.d((String)logComponent, (String)"offerReceipt");
        SDKDialogProxy.clearAlertDialog();
        ReceiptOptionsPresenter.getInstance().showActivity(null, options, callback);
    }

    public void getLocation(V8Function cb) {
        Log.d((String)logComponent, (String)"getLocation");
        V8Function callback = cb.twin();
        Location location = RetailSDK.getLocationService().getCurrentLocation();
        V8Object locationObj = PayPalRetailObject.getEngine().createJsObject();
        double latitude = 0.0;
        double longitude = 0.0;
        float accuracy = 0.0f;
        if (location != null) {
            latitude = location.getLatitude();
            longitude = location.getLongitude();
            accuracy = location.getAccuracy();
        }
        locationObj.add("latitude", latitude);
        locationObj.add("longitude", longitude);
        locationObj.add("accuracy", (double)accuracy);
        callback.call(this.engine.getManticoreJsObject(), this.engine.createJsArray().pushUndefined().push((V8Value)locationObj));
    }

    public void getItem(String name, String storage, V8Function callback) {
        V8Array result = RetailSDK.jsArgs();
        if (BLOB_TYPE.equals(storage) || SECURE_BLOB_TYPE.equals(storage)) {
            try {
                int n;
                File f = RetailSDK.sContext.getFileStreamPath(this.filenameForStorage(storage, name));
                FileInputStream inputStream = RetailSDK.sContext.openFileInput(this.filenameForStorage(storage, name));
                InputStreamReader sr = new InputStreamReader((InputStream)inputStream, "UTF8");
                StringBuilder content = new StringBuilder((int)f.length());
                char[] buffer = new char[Math.min((int)f.length(), 65535)];
                while ((n = sr.read(buffer)) != -1) {
                    content.append(buffer, 0, n);
                }
                inputStream.close();
                result.pushNull().push(content.toString());
            }
            catch (IOException io) {
                callback.call(null, RetailSDK.jsArgs().push((V8Value)this.engine.asJsError(io.getMessage(), "1", io.getStackTrace().toString())));
                return;
            }
        } else {
            SharedPreferences sharedPref = RetailSDK.sContext.getSharedPreferences(RetailSDK.sContext.getString(R.string.preference_file_key), 0);
            String value = sharedPref.getString(name + storage, null);
            result.pushNull().push(value);
        }
        callback.call(null, result);
    }

    public void getItemPath(String name, String storage, V8Function callback) {
        V8Array result = RetailSDK.jsArgs();
        File f = RetailSDK.sContext.getFileStreamPath(this.filenameForStorage(storage, name));
        result.pushNull().push(f.getAbsolutePath());
        if (callback != null) {
            callback.call(null, result);
        }
    }

    public void deleteItem(String name, String storage, V8Function callback) {
        V8Array result = RetailSDK.jsArgs();
        if (BLOB_DECODED_TYPE.equals(storage)) {
            File f = RetailSDK.sContext.getFileStreamPath(this.filenameForStorage(storage, name));
            boolean deleted = f.delete();
            if (!deleted) {
                result.push((V8Value)this.engine.asJsError(new Exception("Could not delete item " + name)));
            } else {
                result.pushNull();
            }
            result.push(f.getAbsolutePath());
        } else {
            result.push((V8Value)this.engine.asJsError(new Exception("Delete not supported for type " + storage)));
        }
        if (callback != null) {
            callback.call(null, result);
        }
    }

    public boolean hasItem(String name, String storage) {
        if (BLOB_TYPE.equals(storage) || SECURE_BLOB_TYPE.equals(storage)) {
            File f = RetailSDK.sContext.getFileStreamPath(this.filenameForStorage(storage, name));
            return f.exists();
        }
        SharedPreferences sharedPref = RetailSDK.sContext.getSharedPreferences(RetailSDK.sContext.getString(R.string.preference_file_key), 0);
        return sharedPref.contains(name + storage);
    }

    public void setItem(String name, String storage, String value, V8Function callback) {
        if (BLOB_TYPE.equals(storage) || SECURE_BLOB_TYPE.equals(storage) || BLOB_DECODED_TYPE.equals(storage)) {
            try {
                FileOutputStream outputStream = RetailSDK.sContext.openFileOutput(this.filenameForStorage(storage, name), 0);
                if (BLOB_DECODED_TYPE.equals(storage)) {
                    outputStream.write(Base64.decode((String)value, (int)2));
                } else {
                    outputStream.write(value.getBytes("UTF8"));
                }
                outputStream.close();
            }
            catch (IOException io) {
                if (callback != null) {
                    callback.call(null, RetailSDK.jsArgs().push((V8Value)this.engine.asJsError((Exception)io)));
                }
            }
        } else {
            SharedPreferences sharedPref = RetailSDK.sContext.getSharedPreferences(RetailSDK.sContext.getString(R.string.preference_file_key), 0);
            SharedPreferences.Editor editor = sharedPref.edit();
            String key = name + storage;
            editor.putString(key, value);
            editor.commit();
        }
        if (callback != null) {
            this.getItemPath(name, storage, callback);
        }
    }

    public void register(final ManticoreEngine engine) {
        this.engine = engine;
        engine.getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Object nativeObject = engine.getManticoreJsObject();
                Class[] optsCallback = new Class[]{V8Object.class, V8Function.class};
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "ready", "ready", new Class[]{V8Object.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "inspect", "inspect", new Class[]{Object.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "alert", "alert", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "jsScanAndDiscover", "scanAndDiscover", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "collectSignature", "collectSignature", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "offerReceipt", "offerReceipt", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "getItem", "getItem", new Class[]{String.class, String.class, V8Function.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "deleteItem", "deleteItem", new Class[]{String.class, String.class, V8Function.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "getItemPath", "getItemPath", new Class[]{String.class, String.class, V8Function.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "setItem", "setItem", new Class[]{String.class, String.class, String.class, V8Function.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "hasItem", "hasItem", new Class[]{String.class, String.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "getLocation", "getLocation", new Class[]{V8Function.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "jsIsCardReaderAvailable", "isCardReaderAvailable", new Class[]{String.class, String.class});
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "jsCreateCardReader", "createCardReader", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "jsConnectLastReaderPrompt", "connectLastReaderPrompt", optsCallback);
                nativeObject.registerJavaMethod((Object)NativeInterface.this, "jsLog", "log", new Class[]{String.class, String.class, Object.class});
            }
        });
    }

    public void jsLog(String level, String component, Object messageValue) {
        String message = messageValue == V8.getUndefined() ? "undefined" : messageValue.toString();
        if (this.logLevels.contains(level = level.toLowerCase())) {
            // empty if block
        }
        Loggly.getInstance().log(level, component, message);
    }

    public void jsCreateCardReader(V8Object options, final V8Function callback) {
        Object device;
        String name = options.getString("name");
        String hardwareAddress = options.getString("address");
        String manufacturer = options.getString("manufacturer");
        RetailSDK.log(logLevel.debug, logComponent, "jsCreateCardReader invoked for card reader name: '" + name + "', manufacturer: '" + manufacturer + "', hardwareAddress: '" + hardwareAddress + "'");
        if (manufacturer.equalsIgnoreCase("MIURA")) {
            device = this.getPairedDevice(name, hardwareAddress);
            if (device == null) {
                RetailSDK.logToCal(logLevel.warn, logComponent, NativeInterface.buildDevId(name, hardwareAddress) + " was not paired");
                callback.call(null, RetailSDK.jsArgs().push((V8Value)this.engine.asJsError(new Exception("Device not paired"))));
                return;
            }
            final MiuraBluetoothDevice miuraBluetoothDevice = new MiuraBluetoothDevice((BluetoothDevice)device);
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    miuraBluetoothDevice.createJSReader();
                    callback.call(null, RetailSDK.jsArgs().pushNull().push((V8Value)miuraBluetoothDevice.impl));
                }
            });
        }
        if (manufacturer.equalsIgnoreCase("INGENICO")) {
            device = new IngenicoBluetoothDevice(name, hardwareAddress, callback);
        }
        if (manufacturer.equalsIgnoreCase("ROAM")) {
            final RoamSwiperDevice roamDevice = AudioJackManager.getInstance().getDevice();
            if (roamDevice != null) {
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        callback.call(null, RetailSDK.jsArgs().pushNull().push((V8Value)roamDevice.impl));
                    }
                });
            } else {
                RetailSDK.log(logLevel.error, logComponent, "jsCreateCardReader trying to create ROAM with null device!");
            }
        }
    }

    static String buildDevId(String name, String deviceAddress) {
        return "androidDevId=" + name + " (" + deviceAddress + ")";
    }

    private BluetoothDevice getPairedDevice(String name, String deviceAddress) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        String deviceId = NativeInterface.buildDevId(name, deviceAddress);
        if (adapter == null) {
            RetailSDK.logToCal(logLevel.warn, logComponent, deviceId + " is not available as bluetooth adapter is null");
            return null;
        }
        Set devices = adapter.getBondedDevices();
        if (devices == null) {
            RetailSDK.logToCal(logLevel.warn, logComponent, deviceId + " is not available as there were no bonded (paired) devices");
            return null;
        }
        RetailSDK.log(logLevel.debug, logComponent, "Searching for connected card reader with address=" + deviceAddress);
        StringBuilder builder = new StringBuilder();
        for (BluetoothDevice d : devices) {
            RetailSDK.log(logLevel.debug, logComponent, "Found device with name=" + d.getName() + ", address=" + d.getAddress());
            builder.append(d.getName() + "(" + d.getAddress() + "), ");
            if (!d.getAddress().equals(deviceAddress)) continue;
            return d;
        }
        RetailSDK.logToCal(logLevel.warn, logComponent, deviceId + " not found. Paired devices=" + builder.toString());
        return null;
    }

    public boolean jsIsCardReaderAvailable(String name, String deviceAddress) {
        return name.toLowerCase().contains("PayPal Audio Reader".toLowerCase()) || this.getPairedDevice(name, deviceAddress) != null;
    }

    private String filenameForStorage(String storage, String name) {
        String filename = NativeInterface.SHA256(name).replace('/', '_');
        return String.format("PayPalRetailSDK-%s-%s", storage, filename);
    }

    private static String SHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes());
            byte[] digest = md.digest();
            return Base64.encodeToString((byte[])digest, (int)2);
        }
        catch (NoSuchAlgorithmException n) {
            throw new RuntimeException("Core cryptography systems are broken. SHA-256 algorithm not found.");
        }
    }

    public static ReceiptViewContent GetReceiptViewContent(V8Object viewContent) {
        return ReceiptViewContent.nativeInstanceForObject(viewContent);
    }
}

