/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.google.gson.Gson;
import com.paypal.paypalretailsdk.AppInfo;
import com.paypal.paypalretailsdk.DeviceManager;
import com.paypal.paypalretailsdk.DeviceScanner;
import com.paypal.paypalretailsdk.Invoice;
import com.paypal.paypalretailsdk.Loggly;
import com.paypal.paypalretailsdk.Merchant;
import com.paypal.paypalretailsdk.NativeInterface;
import com.paypal.paypalretailsdk.NetworkRequest;
import com.paypal.paypalretailsdk.Page;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.PaymentDevice;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.SDK;
import com.paypal.paypalretailsdk.SdkCredential;
import com.paypal.paypalretailsdk.SdkEnvironmentInfo;
import com.paypal.paypalretailsdk.SoundNotification;
import com.paypal.paypalretailsdk.TransactionContext;
import com.paypal.paypalretailsdk.TransactionManager;
import com.paypal.paypalretailsdk.location.LocationService;
import com.paypal.paypalretailsdk.location.LocationServiceImpl;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.pph.PPHMerchant;
import com.paypal.paypalretailsdk.pph.PPHMerchantStatus;
import com.paypal.paypalretailsdk.pph.PPHMerchantUserInfo;
import com.paypal.paypalretailsdk.readers.common.AudioJackManager;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogPresenter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public final class RetailSDK {
    private static final String LOG_TAG = "PayPalHereSDK";
    public static SDK sJsSdk;
    public static Context sContext;
    public static SoundNotification sAudio;
    private static RetailSDKException sStartupError;
    private static DeviceScanner sScanner;
    private static LocationService sLocationService;
    private static AppState _appState;
    private static AudioJackManager sAudioJackManager;
    private static AppInfo sAppInfo;
    private static SdkEnvironmentInfo sEnvInfo;
    private static SdkCredential sCredentials;
    private static Loggly sLoggly;
    private static Map<DeviceDiscoveredObserver, DeviceDiscoveredProxy> deviceDiscoveredMap;
    private static Map<PageViewedObserver, PageViewedProxy> pageViewedMap;

    static AudioJackManager getAudioJackManager() {
        return sAudioJackManager;
    }

    public static void log(logLevel level, String component, String message) {
        NativeInterface.getInstance().jsLog(level.name(), component, message);
    }

    static void logToCal(final logLevel level, final String component, final String message) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(level.name()).push(component).push(message).push(0);
                V8Object objectToExecuteOn = RetailSDK.sJsSdk.impl;
                objectToExecuteOn.executeVoidFunction("logViaJs", args);
            }
        });
    }

    public static void setLogLevel(logLevel logLevel2) {
        sJsSdk.setLogLevel(logLevel2);
    }

    public static void initialize(Context context, AppState appState, AppInfo appInfo) throws RetailSDKException {
        String finalJs;
        sAppInfo = appInfo;
        _appState = appState;
        if (sContext == null) {
            sContext = context;
        }
        if (sStartupError != null) {
            throw sStartupError;
        }
        if (sJsSdk != null) {
            return;
        }
        try {
            InputStream resourceStream = context.getResources().openRawResource(R.raw.ppcert);
            byte[] encJsBytes = RetailSDK.convertStreamToByteArray(resourceStream);
            byte[] decJsBytes = Base64.decode((byte[])encJsBytes, (int)0);
            finalJs = new String(decJsBytes, "UTF-8");
            resourceStream.close();
        }
        catch (IOException jio) {
            throw new RetailSDKException(jio);
        }
        PayPalRetailObject.createManticoreEngine(context, finalJs);
        sAudio = new SoundNotification(context);
        sScanner = DeviceScanner.getInstance();
        sScanner.createJSScanner();
        sLocationService = new LocationServiceImpl(context);
        sLocationService.start();
        sAudioJackManager = AudioJackManager.getInstance();
        sLoggly = Loggly.getInstance();
    }

    static byte[] convertStreamToByteArray(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        while ((i = is.read(buff, 0, buff.length)) > 0) {
            baos.write(buff, 0, i);
        }
        return baos.toByteArray();
    }

    public static LocationService getLocationService() {
        return sLocationService;
    }

    public static SoundNotification getAudio() {
        return sAudio;
    }

    static void setJsSdk(V8Object sdk) {
        sJsSdk = new SDK(sdk.twin());
    }

    static SDK getJsSdk() {
        return sJsSdk;
    }

    public static SdkEnvironmentInfo getAppEnvInfo() {
        return sEnvInfo;
    }

    public static String getSdkVersion() {
        return sJsSdk.getSdkVersion();
    }

    public static AppState getAppState() {
        return _appState;
    }

    public static SdkCredential getSdkCredentials() {
        return sCredentials;
    }

    @SdkInitialized
    public static void initializeMerchant(final SdkCredential credentials, final MerchantInitializedCallback callback) throws Exception {
        RetailSDK.validate();
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                sCredentials = credentials;
                V8Object tokenObj = PayPalRetailObject.getEngine().createJsObject();
                tokenObj.add("accessToken", credentials.accessToken);
                tokenObj.add("refreshUrl", credentials.refreshUrl);
                tokenObj.add("refreshToken", credentials.refreshToken);
                tokenObj.add("appId", credentials.clientId);
                tokenObj.add("appSecret", credentials.clientSecret);
                tokenObj.add("environment", credentials.environment);
                V8Array args = RetailSDK.jsArgs().push((V8Value)tokenObj);
                try {
                    String token = RetailSDK.sJsSdk.impl.executeStringFunction("buildCompositeToken", args);
                    RetailSDK.initializeMerchant(token, credentials.repository, new MerchantInitializedCallback(){

                        @Override
                        public void merchantInitialized(RetailSDKException error, Merchant merchant) {
                            callback.merchantInitialized(error, merchant);
                        }
                    });
                }
                catch (Exception e) {
                    RetailSDKException re = new RetailSDKException(e);
                    callback.merchantInitialized(re, null);
                }
            }
        });
    }

    public static Merchant getMerchant() {
        return sJsSdk.getMerchant();
    }

    @SdkInitialized
    public static void initializeMerchant(final String token, final String repository, final MerchantInitializedCallback callback) {
        RetailSDK.validate();
        final JavaVoidCallback jsCallback = new JavaVoidCallback(){

            public void invoke(V8Object jsThis, V8Array v8Array) {
                RetailSDKException error = null;
                Merchant m = null;
                if (v8Array.length() > 0 && v8Array.get(0) != null) {
                    error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)v8Array.getObject(0), RetailSDKException.class);
                }
                if (v8Array.length() > 1 && v8Array.get(1) != null) {
                    m = new Merchant(v8Array.getObject(1));
                }
                if (error == null) {
                    RetailSDK.toDoAfterMI(m);
                }
                try {
                    callback.merchantInitialized(error, m);
                }
                catch (Exception e) {
                    Log.e((String)"RetailSDK", (String)"Exception during initializeMerchant callback.", (Throwable)e);
                }
            }
        };
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                V8Object cbHolder = PayPalRetailObject.getEngine().createJsObject().registerJavaMethod(jsCallback, "_");
                V8Object cbFn = cbHolder.getObject("_");
                V8Array args = RetailSDK.jsArgs().push(token).push(repository).push((V8Value)cbFn);
                RetailSDK.sJsSdk.impl.executeVoidFunction("initializeMerchant", args);
            }
        });
    }

    @SdkInitialized
    public static void InitializeMerchant(final PPHMerchant merchant, final MerchantInitializedCallback callback) {
        RetailSDK.validate();
        if (merchant == null) {
            V8Object error = PayPalRetailObject.getEngine().createJsObject();
            error.add("message", "Merchant object cannot be null");
            callback.merchantInitialized(new RetailSDKException(error), null);
        }
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                sCredentials = merchant.getCredential();
                V8Object tokenObj = PayPalRetailObject.getEngine().createJsObject();
                tokenObj.add("accessToken", sCredentials.accessToken);
                tokenObj.add("environment", sCredentials.environment);
                tokenObj.add("repository", sCredentials.repository);
                PPHMerchantUserInfo merchantUserInfo = merchant.getUserInfo();
                V8Object userInfo = PayPalRetailObject.getEngine().createJsObject();
                userInfo.add("name", merchantUserInfo.getName());
                userInfo.add("given_name", merchantUserInfo.getGivenName());
                userInfo.add("family_name", merchantUserInfo.getFamilyName());
                userInfo.add("email", merchantUserInfo.getEmail());
                userInfo.add("businessCategory", merchantUserInfo.getBusinessCategory());
                userInfo.add("businessSubCategory", merchantUserInfo.getBusinessSubCategory());
                userInfo.add("payer_id", merchantUserInfo.getPayerId());
                V8Object address = PayPalRetailObject.getEngine().createJsObject();
                address.add("street_address", merchantUserInfo.getAddress().getLine1());
                address.add("locality", merchantUserInfo.getAddress().getCity());
                address.add("country", merchantUserInfo.getAddress().getCountry());
                address.add("region", merchantUserInfo.getAddress().getState());
                address.add("postal_code", merchantUserInfo.getAddress().getPostalCode());
                userInfo.add("address", (V8Value)address);
                PPHMerchantStatus merchantStatus = merchant.getStatus();
                V8Object status = PayPalRetailObject.getEngine().createJsObject();
                status.add("status", merchantStatus.getStatus());
                status.add("currencyCode", merchantStatus.getCurrencyCode());
                status.add("categoryCode", merchantStatus.getBusinessCategoryExists());
                Gson gson = new Gson();
                String paymentTypesJson = gson.toJson(merchantStatus.getPaymentTypes());
                status.add("paymentTypes", paymentTypesJson);
                String cardSettingsJson = gson.toJson((Object)merchantStatus.getCardSettings());
                status.add("cardSettings", cardSettingsJson);
                status.add("businessCategoryExists", merchantStatus.getBusinessCategoryExists());
                String logglyToken = merchant.getLogglyAccessToken();
                V8Object merchantObj = PayPalRetailObject.getEngine().createJsObject();
                merchantObj.add("token", (V8Value)tokenObj);
                merchantObj.add("userInfo", (V8Value)userInfo);
                merchantObj.add("status", (V8Value)status);
                merchantObj.add("repository", sCredentials.repository);
                merchantObj.add("logglyAccessToken", logglyToken);
                try {
                    V8Array args = RetailSDK.jsArgs().push((V8Value)merchantObj);
                    V8Object merchant2 = RetailSDK.sJsSdk.impl.executeObjectFunction("setMerchant", args);
                    callback.merchantInitialized(null, new Merchant(merchant2));
                }
                catch (Exception e) {
                    RetailSDKException re = new RetailSDKException(e);
                    Log.e((String)"RetailSDK", (String)"Exception during MI .", (Throwable)re);
                }
                RetailSDK.toDoAfterMI(sJsSdk.getMerchant());
            }
        });
    }

    @SdkInitialized
    @MerchantInitialized
    @Deprecated
    public static TransactionContext createTransaction(final Invoice invoice) {
        RetailSDK.validate();
        V8Object txContext = (V8Object)PayPalRetailObject.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                return RetailSDK.sJsSdk.impl.executeObjectFunction("createTransaction", RetailSDK.jsArgs().push((V8Value)invoice.impl));
            }
        });
        return new TransactionContext(txContext);
    }

    public static void beginRoamSwiper() {
        if (RetailSDK.checkIfSwiperIsEligibleForMerchant()) {
            sAudioJackManager.register(sContext);
        }
    }

    public static void toDoAfterMI(Merchant merchant) {
        sEnvInfo = new SdkEnvironmentInfo();
        sEnvInfo.setMerchantId(merchant.getPayerId());
        sEnvInfo.setOsName("Android");
        sEnvInfo.setOsVersion(Build.VERSION.RELEASE);
        sEnvInfo.setAppName(RetailSDK.sAppInfo.name);
        sEnvInfo.setAppVersion(RetailSDK.sAppInfo.version);
        sEnvInfo.setAppBuild(RetailSDK.sAppInfo.build);
        sEnvInfo.setCurrency(merchant.getCurrency());
        sEnvInfo.setEnvironment(merchant.getEnvironment());
        sJsSdk.setExecutingEnvironment(sEnvInfo);
        RetailSDK.beginRoamSwiper();
        String token = RetailSDK.getLogglyAccessToken(merchant);
        Loggly loggly = Loggly.getInstance();
        loggly.initialize(token);
    }

    private static String getLogglyAccessToken(final Merchant merchant) {
        return (String)PayPalRetailObject.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = merchant.impl.getType("logglyAccessToken");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _logglyAccessToken = merchant.impl.getString("logglyAccessToken");
                return _logglyAccessToken;
            }
        });
    }

    static boolean checkIfSwiperIsEligibleForMerchant() {
        String currencyCode = sJsSdk.getMerchant().getCurrency();
        return currencyCode != null && !currencyCode.equalsIgnoreCase("GBP") && !currencyCode.equalsIgnoreCase("AUD");
    }

    @SdkInitialized
    @MerchantInitialized
    public static void endRoamSwiper() {
        RetailSDK.validate();
        sAudioJackManager.disconnect();
    }

    public static void logout() {
        RetailSDK.log(logLevel.info, LOG_TAG, "SDK logout invoked");
        sAudioJackManager.disconnect();
        sJsSdk.logout();
        SDKDialogPresenter.getInstance().setIsStarting(false);
    }

    public static void setCurrentApplicationActivity(Activity activity) {
        sContext = activity;
    }

    public static void setNetworkInterceptor(final NetworkInterceptorCallback interceptor) {
        SDK.InterceptCallback callback = new SDK.InterceptCallback(){

            @Override
            public void intercept(NetworkRequest request) {
                interceptor.networkInterceptor(request);
            }
        };
        sJsSdk.setNetworkInterceptor(callback);
    }

    public static void addDeviceDiscoveredObserver(DeviceDiscoveredObserver observer) {
        if (null == deviceDiscoveredMap) {
            deviceDiscoveredMap = new HashMap<DeviceDiscoveredObserver, DeviceDiscoveredProxy>();
        } else if (deviceDiscoveredMap.containsKey(observer)) {
            throw new IllegalArgumentException("That observer has already been added to the deviceDiscovered event.");
        }
        DeviceDiscoveredProxy proxy = new DeviceDiscoveredProxy(observer);
        sJsSdk.addDeviceDiscoveredObserver(proxy);
    }

    public static void removeDeviceDiscoveredObserver(DeviceDiscoveredObserver observer) {
        DeviceDiscoveredProxy p = null;
        if (deviceDiscoveredMap != null && (p = deviceDiscoveredMap.get(observer)) != null) {
            sJsSdk.removeDeviceDiscoveredObserver(p);
        }
    }

    public static void addPageViewedObserver(PageViewedObserver observer) {
        if (null == pageViewedMap) {
            pageViewedMap = new HashMap<PageViewedObserver, PageViewedProxy>();
        } else if (pageViewedMap.containsKey(observer)) {
            throw new IllegalArgumentException("That observer has already been added to the deviceDiscovered event.");
        }
        PageViewedProxy proxy = new PageViewedProxy(observer);
        sJsSdk.addPageViewedObserver(proxy);
    }

    public static void removePageViewedObserver(PageViewedObserver observer) {
        if (pageViewedMap == null) {
            return;
        }
        PageViewedProxy p = pageViewedMap.get(observer);
        if (p == null) {
            return;
        }
        sJsSdk.removePageViewedObserver(p);
    }

    public static DeviceManager getDeviceManager() {
        return sJsSdk.getDeviceManager();
    }

    public static TransactionManager getTransactionManager() {
        return sJsSdk.getTransactionManager();
    }

    static V8Object getJSClass(String className) {
        return RetailSDK.sJsSdk.impl.getObject(className);
    }

    public static V8Array jsArgs() {
        return PayPalRetailObject.getEngine().createJsArray();
    }

    private static void validate() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface MerchantInitialized {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface SdkInitialized {
    }

    static class PageViewedProxy
    implements SDK.PageViewedObserver {
        public PageViewedObserver mOriginal;

        public PageViewedProxy(PageViewedObserver original) {
            this.mOriginal = original;
        }

        @Override
        public void pageViewed(RetailSDKException error, Page page) {
            this.mOriginal.pageViewed(error, page);
        }
    }

    static class DeviceDiscoveredProxy
    implements SDK.DeviceDiscoveredObserver {
        public DeviceDiscoveredObserver mOriginal;

        public DeviceDiscoveredProxy(DeviceDiscoveredObserver original) {
            this.mOriginal = original;
        }

        @Override
        public void deviceDiscovered(PaymentDevice device) {
            this.mOriginal.deviceDiscovered(device);
        }
    }

    public static interface PageViewedObserver {
        public void pageViewed(RetailSDKException var1, Page var2);
    }

    public static interface DeviceDiscoveredObserver {
        public void deviceDiscovered(PaymentDevice var1);
    }

    public static interface NetworkInterceptorCallback {
        public void networkInterceptor(NetworkRequest var1);
    }

    public static interface LastActiveCardReaderCallbackCallback {
        public void lastActiveCardReaderCallback(RetailSDKException var1, PaymentDevice var2);
    }

    public static interface MerchantInitializedCallback {
        public void merchantInitialized(RetailSDKException var1, Merchant var2);
    }

    public static interface AppState {
        public Activity getCurrentActivity();

        public boolean getIsTabletMode();
    }
}

