/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.app.Activity;
import android.content.Context;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.PaymentDevice;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.AudioJackManager;
import com.paypal.paypalretailsdk.readers.common.CardReaderInterface;
import com.paypal.paypalretailsdk.readers.common.CardReaderObserver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;

public class RoamSwiperDevice
extends PayPalRetailObject
implements CardReaderObserver {
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final String LOG_TAG = RoamSwiperDevice.class.getSimpleName();
    public static final String MANUFACTURER = "ROAM";
    private ConnectionStatus mStatus = ConnectionStatus.None;
    private AudioJackManager mDevice = RetailSDK.getAudioJackManager();
    private V8Object mNativeReader;
    private boolean mIsRemoved = false;

    public RoamSwiperDevice() {
        Log.d((String)LOG_TAG, (String)("Found PayPal Reader Device: " + this.mDevice.getName()));
    }

    public void createJSReader() {
        Log.d((String)LOG_TAG, (String)(" createJSReader for : " + this.mDevice.getName()));
        this.mIsRemoved = false;
        this.mNativeReader = PayPalRetailObject.getEngine().createJsObject();
        this.mNativeReader.registerJavaMethod((Object)this, "isConnected", "isConnected", null);
        this.mNativeReader.registerJavaMethod((Object)this, "jsConnect", "connect", new Class[]{V8Function.class});
        this.mNativeReader.registerJavaMethod((Object)this, "jsDisconnect", "disconnect", new Class[]{V8Function.class});
        this.mNativeReader.registerJavaMethod((Object)this, "send", "send", new Class[]{Object.class, V8Object.class});
        this.mNativeReader.registerJavaMethod((Object)this, "jsRemoved", "removed", new Class[]{V8Function.class});
        final V8Object deviceBuilder = PayPalRetailObject.getEngine().createJsObject("DeviceBuilder", RetailSDK.jsArgs());
        final V8Array args = RoamSwiperDevice.getEngine().createJsArray().push(MANUFACTURER).push(this.mDevice.getName()).push(false).push((V8Value)this.mNativeReader).push((V8Value)null).push("RoamSwiper");
        this.impl = PayPalRetailObject.getEngine().createJsObject("RoamSwiperDevice", RetailSDK.jsArgs().push(this.mDevice.getName()).push((V8Value)this.mNativeReader));
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                RoamSwiperDevice.this.impl = deviceBuilder.executeObjectFunction("build", args);
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        RetailSDK.getJsSdk().discoveredPaymentDevice(new PaymentDevice(RoamSwiperDevice.this.impl));
                    }
                });
            }
        });
        this.register();
    }

    private void disconnect() {
        Log.d((String)LOG_TAG, (String)("Disconnect Roam Swiper Device : " + this.mDevice.getName()));
        try {
            this.mStatus = ConnectionStatus.None;
        }
        catch (Exception x) {
            Log.d((String)LOG_TAG, (String)("Roam Swiper Error happened during the disconnect " + x.toString()));
        }
    }

    public boolean isConnected() {
        return this.mStatus == ConnectionStatus.Connected;
    }

    public void register() {
        Log.d((String)LOG_TAG, (String)("registering Roam Swiper Device : " + this.mDevice.getName()));
        this.mDevice.registerObserverToRoamSwiper(this);
    }

    public void jsConnect(V8Function jsCallback) {
        Log.d((String)LOG_TAG, (String)("connect to Roam Swiper Reader Device: " + this.mDevice.getName()));
        final V8Function callback = jsCallback.twin();
        if (!this.isConnected()) {
            if (this.mDevice.isConnected()) {
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        RoamSwiperDevice.this.mStatus = ConnectionStatus.Connected;
                        Log.d((String)LOG_TAG, (String)("Found PayPal Reader Device connected to : " + RoamSwiperDevice.this.mDevice.getName()));
                        callback.call(RoamSwiperDevice.this.mNativeReader, RetailSDK.jsArgs().pushUndefined());
                    }
                });
            } else {
                Log.d((String)LOG_TAG, (String)"Roam swiper is not connected!");
            }
        }
    }

    public void jsDisconnect(V8Function jsCallback) {
        final V8Function callback = jsCallback.twin();
        if (this.isConnected()) {
            Log.d((String)LOG_TAG, (String)("disconnect to Roam Swiper Reader Device: " + this.mDevice.getName()));
            this.disconnect();
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)LOG_TAG, (String)"Found PayPal Reader Device disconnect callback executed ");
                    callback.call(RoamSwiperDevice.this.mNativeReader, RetailSDK.jsArgs().pushUndefined());
                }
            });
        }
    }

    public void jsRemoved(V8Function jsCallback) {
        if (this.isConnected()) {
            this.mDevice.disconnect();
            this.disconnect();
        }
        final V8Function callback = jsCallback.twin();
        Log.d((String)LOG_TAG, (String)("removed Roam Swiper Reader Device: " + this.mDevice.getName()));
        this.mIsRemoved = true;
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                Log.d((String)LOG_TAG, (String)"Found PayPal Reader Device removed callback executed ");
                callback.call(RoamSwiperDevice.this.mNativeReader, RetailSDK.jsArgs().pushUndefined());
            }
        });
    }

    public boolean isRemoved() {
        return this.mIsRemoved;
    }

    public boolean send(Object data, V8Object callback) {
        if (data instanceof String) {
            Log.d((String)LOG_TAG, (String)("RoamSwiperDevice - send data: " + data.toString()));
            if (data.equals("listenForCardEvents")) {
                this.mDevice.listenForCardEvents();
            } else if (data.equals("stopListeningForCardEvents")) {
                this.mDevice.stopListeningForCardEvents();
            }
        } else {
            Log.d((String)LOG_TAG, (String)("RoamSwiperDevice - unknown data: " + data.toString()));
        }
        V8Function jsCallback = null;
        if (callback != null && !callback.isUndefined()) {
            jsCallback = (V8Function)callback;
        }
        try {
            if (jsCallback != null && !jsCallback.isUndefined()) {
                jsCallback.call(this.mNativeReader, RetailSDK.jsArgs().pushUndefined());
            }
            return true;
        }
        catch (Exception x) {
            if (jsCallback != null && !jsCallback.isUndefined()) {
                jsCallback.call(this.mNativeReader, RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError(x)));
            }
            return false;
        }
    }

    @Override
    public void onDeviceDetected(boolean isValidReader, CardReaderInterface.DeviceTypes type, CardReaderInterface.DeviceFamily family) {
        Log.d((String)LOG_TAG, (String)("onDeviceDetected isValidReader: " + isValidReader + " type: " + (Object)((Object)type) + " Family: " + (Object)((Object)family)));
        if (type.equals((Object)CardReaderInterface.DeviceTypes.RoamPayReader) && isValidReader) {
            Log.d((String)LOG_TAG, (String)"onDeviceDetected RoamPayReader detected");
            if (this.mDevice != null) {
                this.mDevice.listenForCardEvents();
            }
        }
    }

    @Override
    public void onDeviceLostConnection(final CardReaderInterface.DeviceTypes type, final CardReaderInterface.DeviceFamily family) {
        RetailSDK.log(logLevel.info, LOG_TAG, "onDeviceLostConnection deviceType: " + (Object)((Object)type) + " deviceFamily: " + (Object)((Object)family));
        if (type.equals((Object)CardReaderInterface.DeviceTypes.RoamPayReader)) {
            this.disconnect();
            PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                @Override
                public void run() {
                    RetailSDK.log(logLevel.error, LOG_TAG, "onDeviceLostConnection -> Invoking onDisconnected() on deviceType: " + (Object)((Object)type) + " deviceFamily: " + (Object)((Object)family));
                    RoamSwiperDevice.this.impl.executeVoidFunction("onDisconnected", RetailSDK.jsArgs().push((V8Value)PayPalRetailObject.getEngine().asJsError(new Exception("Roam Swiper Lost Connection"))));
                    RoamSwiperDevice.this.impl.executeVoidFunction("removed", RetailSDK.jsArgs());
                }
            });
        }
    }

    @Override
    public void onDeviceError(String error) {
        Log.e((String)LOG_TAG, (String)("Decode error? error = " + error));
    }

    @Override
    public void onSwipeDetected(final HashMap<String, String> decodeData, final String track1) {
        Log.d((String)LOG_TAG, (String)"Hey look...we have a card swipe");
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                try {
                    V8Object returnValue = PayPalRetailObject.getEngine().createJsObject();
                    JSONObject decodedJsonData = new JSONObject((Map)decodeData);
                    String base64Data = Base64.encodeToString((byte[])decodedJsonData.toString().getBytes(), (int)2);
                    Log.d((String)LOG_TAG, (String)("onSwipeDetected: " + decodedJsonData.toString()));
                    returnValue.add("decodeData", base64Data);
                    returnValue.add("track1", track1);
                    RoamSwiperDevice.this.impl.executeVoidFunction("received", RetailSDK.jsArgs().push((V8Value)returnValue));
                }
                catch (Exception x) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    x.printStackTrace(pw);
                    Log.d((String)"ERROR", (String)"RoamSwiperDevice", (Throwable)x);
                }
            }
        });
    }

    private void showSwipeFailedToast() {
        Activity currentActivity = RetailSDK.getAppState().getCurrentActivity();
        Toast toast = new Toast((Context)currentActivity);
        LayoutInflater inflater = (LayoutInflater)currentActivity.getSystemService("layout_inflater");
        View toastView = inflater.inflate(R.layout.toast_swipe_failed, null);
        ImageView imageView = (ImageView)toastView.findViewById(R.id.swipe_failed_image);
        imageView.setImageResource(R.drawable.ic_swipe_failed);
        toast.setGravity(16, 0, 0);
        toast.setDuration(0);
        toast.setView(toastView);
        toast.show();
    }

    @Override
    public void onSwipeFailed() {
        Log.d((String)LOG_TAG, (String)"Hey look...Swipe has failed");
        this.showSwipeFailedToast();
    }

    @Override
    public void onKsnReceived(final String ksn) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "Native> Received KSN" + ksn);
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                RoamSwiperDevice.this.impl.executeVoidFunction("receivedKsn", RetailSDK.jsArgs().push(ksn));
            }
        });
    }

    public static enum ConnectionStatus {
        None,
        Connecting,
        Connected;

    }
}

