/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.util.Log;

public class SdkCredential {
    public static final String liveService = "live";
    public static final String sandboxService = "sandbox";
    public static final String stageService = "stage";
    private static final String LOG_TAG = SdkCredential.class.getSimpleName();
    String accessToken;
    String refreshUrl;
    String refreshToken;
    String clientId;
    String clientSecret;
    String environment;
    String repository;

    public SdkCredential(String environment, String accessToken, String softwareRepository) {
        this.environment = environment;
        this.accessToken = accessToken;
        this.repository = softwareRepository;
    }

    public SdkCredential(String environment, String accessToken) {
        this.environment = environment;
        this.accessToken = accessToken;
        if (environment.contains(liveService)) {
            this.repository = "production";
        } else if (environment.contains(sandboxService)) {
            this.repository = sandboxService;
        } else if (environment.contains(stageService)) {
            this.repository = "dev-stage-1";
        } else {
            Log.e((String)LOG_TAG, (String)("No repository defined for this environment: " + environment));
            throw new RuntimeException("Proper environment required!");
        }
    }

    public SdkCredential setTokenRefreshCredentials(String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public SdkCredential setTokenRefreshCredentials(String refreshToken, String clientId, String clientSecret) {
        this.refreshToken = refreshToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }
}

