/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import android.media.ToneGenerator;
import android.os.Build;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class SoundNotification {
    private static final String LOG_TAG = SoundNotification.class.getSimpleName();
    private SoundPool mSoundPool;
    private HashMap mSoundsMap = new HashMap();
    private Context mContext;

    public SoundNotification(Context activity) {
        this.mContext = activity;
        this.initializeSoundPool();
    }

    private SoundPool createSoundPool() {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.createNewSoundPool();
        }
        return this.createOldSoundPool();
    }

    @TargetApi(value=21)
    private SoundPool createNewSoundPool() {
        AudioAttributes attributes = new AudioAttributes.Builder().setUsage(5).setContentType(4).build();
        SoundPool sounds = new SoundPool.Builder().setAudioAttributes(attributes).build();
        return sounds;
    }

    private SoundPool createOldSoundPool() {
        return new SoundPool(5, 5, 0);
    }

    public void initializeSoundPool() {
        this.mSoundPool = this.createSoundPool();
        this.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "onLoadComplete");
            }
        });
        this.mSoundsMap.put(R.raw.success_card_read, this.mSoundPool.load(this.mContext, R.raw.success_card_read, 1));
    }

    public void playSound(int sampleId) {
        try {
            int iSoundId = (Integer)this.mSoundsMap.get(sampleId);
            this.mSoundPool.play(iSoundId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
        catch (Exception ex) {
            RetailSDK.log(logLevel.error, LOG_TAG, "Error in playSound" + ex.toString());
        }
    }

    public void playAudibleBeep(int playCount) {
        final Timer t = new Timer();
        final int[] count = new int[]{playCount};
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                try {
                    ToneGenerator tg = new ToneGenerator(4, 100);
                    tg.startTone(24, 200);
                    count[0] = count[0] - 1;
                    if (count[0] == 0) {
                        t.cancel();
                    }
                }
                catch (Exception ex) {
                    RetailSDK.log(logLevel.error, LOG_TAG, "Error in playAudibleBeep" + ex.toString());
                }
            }
        };
        t.schedule(tt, 0L, 400L);
    }

    public void release() {
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
        }
    }

    public void stop() {
        if (this.mSoundPool != null) {
            Set ids = this.mSoundsMap.keySet();
            for (Integer id2 : ids) {
                this.mSoundPool.stop(id2.intValue());
            }
        }
    }
}

