/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.IManticoreTypeConverter;
import com.paypal.paypalretailsdk.CaptureHandler;
import com.paypal.paypalretailsdk.Card;
import com.paypal.paypalretailsdk.CardInsertedHandler;
import com.paypal.paypalretailsdk.FormFactor;
import com.paypal.paypalretailsdk.Invoice;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.PaymentState;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.SignatureReceiver;
import com.paypal.paypalretailsdk.TippingState;
import com.paypal.paypalretailsdk.TokenExpirationHandler;
import com.paypal.paypalretailsdk.TransactionBeginOptions;
import com.paypal.paypalretailsdk.TransactionRecord;
import com.paypal.paypalretailsdk.TransactionType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class TransactionContext
extends PayPalRetailObject {
    private Map<ContactlessReaderDeactivatedObserver, V8Object> contactlessReaderDeactivatedHandlers;
    private Map<PinEntryObserver, V8Object> pinEntryHandlers;
    private Map<WillPresentSignatureObserver, V8Object> willPresentSignatureHandlers;
    private Map<ReaderTippingCompletedObserver, V8Object> readerTippingCompletedHandlers;
    private Map<DidCompleteSignatureObserver, V8Object> didCompleteSignatureHandlers;

    TransactionContext(V8Object jsValue) {
        super(jsValue);
    }

    static TransactionContext nativeInstanceForObject(V8Object jsValue) {
        if (jsValue == null || jsValue.isUndefined()) {
            return null;
        }
        return new TransactionContext(jsValue);
    }

    protected TransactionContext() {
    }

    public Invoice getInvoice() {
        return (Invoice)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<Invoice>(){

            @Override
            public Invoice call() {
                int _jsType = TransactionContext.this.impl.getType("invoice");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                V8Object _invoice = TransactionContext.this.impl.getObject("invoice");
                return (Invoice)PayPalRetailObject.getEngine().getConverter().asNative((Object)_invoice, Invoice.class);
            }
        });
    }

    public TransactionType getType() {
        return (TransactionType)((Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<TransactionType>(){

            @Override
            public TransactionType call() {
                int _jsType = TransactionContext.this.impl.getType("type");
                if (_jsType == 99 || _jsType == 0) {
                    return TransactionType.fromInt(0);
                }
                int _type = TransactionContext.this.impl.getInteger("type");
                return TransactionType.fromInt(_type);
            }
        }));
    }

    public void setType(final TransactionType value) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.add("type", value.getValue());
            }
        });
    }

    public Boolean getIsSignatureRequired() {
        return (Boolean)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int _jsType = TransactionContext.this.impl.getType("isSignatureRequired");
                if (_jsType == 99 || _jsType == 0) {
                    return false;
                }
                Boolean _isSignatureRequired = TransactionContext.this.impl.getBoolean("isSignatureRequired");
                return _isSignatureRequired;
            }
        });
    }

    public String getTotalDisplayFooter() {
        return (String)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                int _jsType = TransactionContext.this.impl.getType("totalDisplayFooter");
                if (_jsType == 99 || _jsType == 0) {
                    return null;
                }
                String _totalDisplayFooter = TransactionContext.this.impl.getString("totalDisplayFooter");
                return _totalDisplayFooter;
            }
        });
    }

    public void setTotalDisplayFooter(final String value) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.add("totalDisplayFooter", value);
            }
        });
    }

    public PaymentState getPaymentState() {
        return (PaymentState)((Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<PaymentState>(){

            @Override
            public PaymentState call() {
                int retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeIntegerFunction("getPaymentState", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return PaymentState.fromInt(retVal);
            }
        }));
    }

    public TippingState getTippingState() {
        return (TippingState)((Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<TippingState>(){

            @Override
            public TippingState call() {
                int retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeIntegerFunction("getTippingState", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return TippingState.fromInt(retVal);
            }
        }));
    }

    public void clearOnReaderTip() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("clearOnReaderTip", args);
            }
        });
    }

    public TransactionContext beginPayment(final TransactionBeginOptions options) {
        return (TransactionContext)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<TransactionContext>(){

            @Override
            public TransactionContext call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)options));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("beginPayment", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (TransactionContext)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, TransactionContext.class);
            }
        });
    }

    public TransactionContext beginRefund(final Boolean cardPresent, final BigDecimal amount) {
        return (TransactionContext)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<TransactionContext>(){

            @Override
            public TransactionContext call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(cardPresent.booleanValue()).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(amount));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("beginRefund", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (TransactionContext)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, TransactionContext.class);
            }
        });
    }

    public TransactionContext beginRefund(final Boolean cardPresent, final BigDecimal amount, final String refundTag) {
        return (TransactionContext)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<TransactionContext>(){

            @Override
            public TransactionContext call() {
                V8Object retVal;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(cardPresent.booleanValue()).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(amount)).push(refundTag);
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeObjectFunction("beginRefundWithTag", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return (TransactionContext)PayPalRetailObject.getEngine().getConverter().asNative((Object)retVal, TransactionContext.class);
            }
        });
    }

    public Boolean isRefund() {
        return (Boolean)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("isRefund", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public void deactivateFormFactors(final List<FormFactor> formFactors, final CompleteCallback callback) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(formFactors, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<FormFactor>(){

                    public void push(V8Array dest, FormFactor nativeValue) {
                        dest.push(nativeValue.getValue());
                    }
                })).push((V8Value)TransactionContext.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("deactivateFormFactors", args);
            }
        });
    }

    public void clear(final CompleteCallback callback) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("clear", args);
            }
        });
    }

    public Boolean isPaymentInRetryOrProgress() {
        return (Boolean)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("isPaymentInRetryOrProgress", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public Boolean requestPaymentCancellation() {
        return (Boolean)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean retVal;
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                try {
                    retVal = objectToExecuteOn.executeBooleanFunction("requestPaymentCancellation", args);
                }
                catch (V8ResultUndefined e) {
                    return null;
                }
                return retVal;
            }
        });
    }

    public void dropHandlers() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("dropHandlers", args);
            }
        });
    }

    public void discardPresentedCard(final Card card) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)card));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("discardPresentedCard", args);
            }
        });
    }

    public void continueWithCard(final Card card) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)card));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("continueWithCard", args);
            }
        });
    }

    public void startInvoiceSync() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("startInvoiceSync", args);
            }
        });
    }

    public void syncInvoiceOnce() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("syncInvoiceOnce", args);
            }
        });
    }

    public void continueWithCash() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("continueWithCash", args);
            }
        });
    }

    public void continueWithCheck() {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().getEmptyArray();
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("continueWithCheck", args);
            }
        });
    }

    public void setSignatureCollector(final SignatureCollectorCallback collector) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(collector));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setSignatureCollector", args);
            }
        });
    }

    public void setTokenExpiredHandler(final TokenExpirationHandlerCallback expirationHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(expirationHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setTokenExpiredHandler", args);
            }
        });
    }

    public void setCardInsertedHandler(final CardInsertedHandlerCallback cardInsertedHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(cardInsertedHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setCardInsertedHandler", args);
            }
        });
    }

    public void setCaptureHandler(final OnAuthCompleteCallback captureHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(captureHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setCaptureHandler", args);
            }
        });
    }

    public void setCardPresentedHandler(final CardPresentedCallback cardPresentedHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(cardPresentedHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setCardPresentedHandler", args);
            }
        });
    }

    public void setCompletedHandler(final TransactionCompletedCallback completedHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)TransactionContext.wrapJavaFn(completedHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setCompletedHandler", args);
            }
        });
    }

    public void setAdditionalReceiptOptions(final List<String> additionalReceiptOptions, final ReceiptOptionHandlerCallback receiptHandler) {
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(additionalReceiptOptions, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<String>(){

                    public void push(V8Array dest, String nativeValue) {
                        dest.push(nativeValue);
                    }
                })).push((V8Value)TransactionContext.wrapJavaFn(receiptHandler));
                V8Object objectToExecuteOn = TransactionContext.this.impl;
                objectToExecuteOn.executeVoidFunction("setAdditionalReceiptOptions", args);
            }
        });
    }

    public String toString() {
        return (String)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                V8Object objectToExecuteOn = PayPalRetailObject.getEngine().getJsObject("JSON");
                V8Object objectStringify = TransactionContext.this.impl;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)objectStringify);
                String retVal = objectToExecuteOn.executeStringFunction("stringify", args);
                return retVal;
            }
        });
    }

    public void addContactlessReaderDeactivatedObserver(ContactlessReaderDeactivatedObserver observer) {
        if (this.contactlessReaderDeactivatedHandlers == null) {
            this.contactlessReaderDeactivatedHandlers = new HashMap<ContactlessReaderDeactivatedObserver, V8Object>();
        } else if (this.contactlessReaderDeactivatedHandlers.containsKey(observer)) {
            this.removeContactlessReaderDeactivatedObserver(observer);
        }
        final V8Object wrapped = TransactionContext.wrapJavaFn(observer);
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.executeVoidFunction("on", PayPalRetailObject.getEngine().createJsArray().push("contactlessReaderDeactivated").push((V8Value)wrapped));
            }
        });
        this.contactlessReaderDeactivatedHandlers.put(observer, wrapped);
    }

    public void removeContactlessReaderDeactivatedObserver(ContactlessReaderDeactivatedObserver observer) {
        if (this.contactlessReaderDeactivatedHandlers != null && this.contactlessReaderDeactivatedHandlers.containsKey(observer)) {
            final V8Object ex = this.contactlessReaderDeactivatedHandlers.get(observer);
            TransactionContext.getEngine().getExecutor().run(new Runnable(){

                @Override
                public void run() {
                    TransactionContext.this.impl.executeVoidFunction("removeListener", PayPalRetailObject.getEngine().createJsArray().push("contactlessReaderDeactivated").push((V8Value)ex));
                    ex.release();
                }
            });
            this.contactlessReaderDeactivatedHandlers.remove(observer);
        }
    }

    public void addPinEntryObserver(PinEntryObserver observer) {
        if (this.pinEntryHandlers == null) {
            this.pinEntryHandlers = new HashMap<PinEntryObserver, V8Object>();
        } else if (this.pinEntryHandlers.containsKey(observer)) {
            this.removePinEntryObserver(observer);
        }
        final V8Object wrapped = TransactionContext.wrapJavaFn(observer);
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.executeVoidFunction("on", PayPalRetailObject.getEngine().createJsArray().push("pinEntry").push((V8Value)wrapped));
            }
        });
        this.pinEntryHandlers.put(observer, wrapped);
    }

    public void removePinEntryObserver(PinEntryObserver observer) {
        if (this.pinEntryHandlers != null && this.pinEntryHandlers.containsKey(observer)) {
            final V8Object ex = this.pinEntryHandlers.get(observer);
            TransactionContext.getEngine().getExecutor().run(new Runnable(){

                @Override
                public void run() {
                    TransactionContext.this.impl.executeVoidFunction("removeListener", PayPalRetailObject.getEngine().createJsArray().push("pinEntry").push((V8Value)ex));
                    ex.release();
                }
            });
            this.pinEntryHandlers.remove(observer);
        }
    }

    public void addWillPresentSignatureObserver(WillPresentSignatureObserver observer) {
        if (this.willPresentSignatureHandlers == null) {
            this.willPresentSignatureHandlers = new HashMap<WillPresentSignatureObserver, V8Object>();
        } else if (this.willPresentSignatureHandlers.containsKey(observer)) {
            this.removeWillPresentSignatureObserver(observer);
        }
        final V8Object wrapped = TransactionContext.wrapJavaFn(observer);
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.executeVoidFunction("on", PayPalRetailObject.getEngine().createJsArray().push("willPresentSignature").push((V8Value)wrapped));
            }
        });
        this.willPresentSignatureHandlers.put(observer, wrapped);
    }

    public void removeWillPresentSignatureObserver(WillPresentSignatureObserver observer) {
        if (this.willPresentSignatureHandlers != null && this.willPresentSignatureHandlers.containsKey(observer)) {
            final V8Object ex = this.willPresentSignatureHandlers.get(observer);
            TransactionContext.getEngine().getExecutor().run(new Runnable(){

                @Override
                public void run() {
                    TransactionContext.this.impl.executeVoidFunction("removeListener", PayPalRetailObject.getEngine().createJsArray().push("willPresentSignature").push((V8Value)ex));
                    ex.release();
                }
            });
            this.willPresentSignatureHandlers.remove(observer);
        }
    }

    public void addReaderTippingCompletedObserver(ReaderTippingCompletedObserver observer) {
        if (this.readerTippingCompletedHandlers == null) {
            this.readerTippingCompletedHandlers = new HashMap<ReaderTippingCompletedObserver, V8Object>();
        } else if (this.readerTippingCompletedHandlers.containsKey(observer)) {
            this.removeReaderTippingCompletedObserver(observer);
        }
        final V8Object wrapped = TransactionContext.wrapJavaFn(observer);
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.executeVoidFunction("on", PayPalRetailObject.getEngine().createJsArray().push("readerTippingCompleted").push((V8Value)wrapped));
            }
        });
        this.readerTippingCompletedHandlers.put(observer, wrapped);
    }

    public void removeReaderTippingCompletedObserver(ReaderTippingCompletedObserver observer) {
        if (this.readerTippingCompletedHandlers != null && this.readerTippingCompletedHandlers.containsKey(observer)) {
            final V8Object ex = this.readerTippingCompletedHandlers.get(observer);
            TransactionContext.getEngine().getExecutor().run(new Runnable(){

                @Override
                public void run() {
                    TransactionContext.this.impl.executeVoidFunction("removeListener", PayPalRetailObject.getEngine().createJsArray().push("readerTippingCompleted").push((V8Value)ex));
                    ex.release();
                }
            });
            this.readerTippingCompletedHandlers.remove(observer);
        }
    }

    public void addDidCompleteSignatureObserver(DidCompleteSignatureObserver observer) {
        if (this.didCompleteSignatureHandlers == null) {
            this.didCompleteSignatureHandlers = new HashMap<DidCompleteSignatureObserver, V8Object>();
        } else if (this.didCompleteSignatureHandlers.containsKey(observer)) {
            this.removeDidCompleteSignatureObserver(observer);
        }
        final V8Object wrapped = TransactionContext.wrapJavaFn(observer);
        TransactionContext.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionContext.this.impl.executeVoidFunction("on", PayPalRetailObject.getEngine().createJsArray().push("didCompleteSignature").push((V8Value)wrapped));
            }
        });
        this.didCompleteSignatureHandlers.put(observer, wrapped);
    }

    public void removeDidCompleteSignatureObserver(DidCompleteSignatureObserver observer) {
        if (this.didCompleteSignatureHandlers != null && this.didCompleteSignatureHandlers.containsKey(observer)) {
            final V8Object ex = this.didCompleteSignatureHandlers.get(observer);
            TransactionContext.getEngine().getExecutor().run(new Runnable(){

                @Override
                public void run() {
                    TransactionContext.this.impl.executeVoidFunction("removeListener", PayPalRetailObject.getEngine().createJsArray().push("didCompleteSignature").push((V8Value)ex));
                    ex.release();
                }
            });
            this.didCompleteSignatureHandlers.remove(observer);
        }
    }

    private static V8Object wrapJavaFn(final TransactionCompletedCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        V8Object jsrecord = null;
                        TransactionRecord _record = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            jsrecord = args.getObject(1);
                            _record = (TransactionRecord)PayPalRetailObject.getEngine().getConverter().asNative((Object)jsrecord, TransactionRecord.class);
                        }
                        javaInterface.transactionCompleted(_error, _record);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final CardPresentedCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jscard = null;
                        Card _card = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jscard = args.getObject(0);
                            _card = (Card)PayPalRetailObject.getEngine().getConverter().asNative((Object)jscard, Card.class);
                        }
                        javaInterface.cardPresented(_card);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final SignatureCollectorCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jssignatureReceiver = null;
                        SignatureReceiver _signatureReceiver = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jssignatureReceiver = args.getObject(0);
                            _signatureReceiver = (SignatureReceiver)PayPalRetailObject.getEngine().getConverter().asNative((Object)jssignatureReceiver, SignatureReceiver.class);
                        }
                        javaInterface.signatureCollector(_signatureReceiver);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final TokenExpirationHandlerCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jstokenExpirationHandler = null;
                        TokenExpirationHandler _tokenExpirationHandler = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jstokenExpirationHandler = args.getObject(0);
                            _tokenExpirationHandler = (TokenExpirationHandler)PayPalRetailObject.getEngine().getConverter().asNative((Object)jstokenExpirationHandler, TokenExpirationHandler.class);
                        }
                        javaInterface.tokenExpirationHandler(_tokenExpirationHandler);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final CardInsertedHandlerCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jscardInsertedHandler = null;
                        CardInsertedHandler _cardInsertedHandler = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jscardInsertedHandler = args.getObject(0);
                            _cardInsertedHandler = (CardInsertedHandler)PayPalRetailObject.getEngine().getConverter().asNative((Object)jscardInsertedHandler, CardInsertedHandler.class);
                        }
                        javaInterface.cardInsertedHandler(_cardInsertedHandler);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final OnAuthCompleteCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jsError = null;
                        RetailSDKException _Error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jsError = args.getObject(0);
                            _Error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jsError, RetailSDKException.class);
                        }
                        V8Object jscaptureHandler = null;
                        CaptureHandler _captureHandler = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            jscaptureHandler = args.getObject(1);
                            _captureHandler = (CaptureHandler)PayPalRetailObject.getEngine().getConverter().asNative((Object)jscaptureHandler, CaptureHandler.class);
                        }
                        V8Object jsrecord = null;
                        TransactionRecord _record = null;
                        if (args.length() > 2 && args.getType(2) != 99) {
                            jsrecord = args.getObject(2);
                            _record = (TransactionRecord)PayPalRetailObject.getEngine().getConverter().asNative((Object)jsrecord, TransactionRecord.class);
                        }
                        javaInterface.onAuthComplete(_Error, _captureHandler, _record);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final ReceiptOptionHandlerCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        Integer jsindex = 0;
                        Integer _index = 0;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            _index = jsindex = Integer.valueOf(args.getInteger(0));
                        }
                        String jsname = null;
                        String _name = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            _name = jsname = args.getString(1);
                        }
                        V8Object jsrecord = null;
                        TransactionRecord _record = null;
                        if (args.length() > 2 && args.getType(2) != 99) {
                            jsrecord = args.getObject(2);
                            _record = (TransactionRecord)PayPalRetailObject.getEngine().getConverter().asNative((Object)jsrecord, TransactionRecord.class);
                        }
                        javaInterface.receiptOptionHandler(_index, _name, _record);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final CompleteCallback javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        javaInterface.complete(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final ContactlessReaderDeactivatedObserver javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        javaInterface.contactlessReaderDeactivated();
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final PinEntryObserver javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        Boolean jscomplete = false;
                        Boolean _complete = false;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            _complete = jscomplete = Boolean.valueOf(args.getBoolean(0));
                        }
                        Boolean jscorrect = false;
                        Boolean _correct = false;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            _correct = jscorrect = Boolean.valueOf(args.getBoolean(1));
                        }
                        Integer jspinDigits = 0;
                        Integer _pinDigits = 0;
                        if (args.length() > 2 && args.getType(2) != 99) {
                            _pinDigits = jspinDigits = Integer.valueOf(args.getInteger(2));
                        }
                        Boolean jslastAttempt = false;
                        Boolean _lastAttempt = false;
                        if (args.length() > 3 && args.getType(3) != 99) {
                            _lastAttempt = jslastAttempt = Boolean.valueOf(args.getBoolean(3));
                        }
                        javaInterface.pinEntry(_complete, _correct, _pinDigits, _lastAttempt);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final WillPresentSignatureObserver javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        javaInterface.willPresentSignature();
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final ReaderTippingCompletedObserver javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jstipAmount = null;
                        BigDecimal _tipAmount = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jstipAmount = args.getObject(0);
                            _tipAmount = PayPalRetailObject.getEngine().getConverter().asNativeDecimal(jstipAmount);
                        }
                        javaInterface.readerTippingCompleted(_tipAmount);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final DidCompleteSignatureObserver javaInterface) {
        return (V8Object)TransactionContext.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        javaInterface.didCompleteSignature(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    public static interface DidCompleteSignatureObserver {
        public void didCompleteSignature(RetailSDKException var1);
    }

    public static interface ReaderTippingCompletedObserver {
        public void readerTippingCompleted(BigDecimal var1);
    }

    public static interface WillPresentSignatureObserver {
        public void willPresentSignature();
    }

    public static interface PinEntryObserver {
        public void pinEntry(Boolean var1, Boolean var2, Integer var3, Boolean var4);
    }

    public static interface ContactlessReaderDeactivatedObserver {
        public void contactlessReaderDeactivated();
    }

    public static interface CompleteCallback {
        public void complete(RetailSDKException var1);
    }

    public static interface ReceiptOptionHandlerCallback {
        public void receiptOptionHandler(Integer var1, String var2, TransactionRecord var3);
    }

    public static interface OnAuthCompleteCallback {
        public void onAuthComplete(RetailSDKException var1, CaptureHandler var2, TransactionRecord var3);
    }

    public static interface CardInsertedHandlerCallback {
        public void cardInsertedHandler(CardInsertedHandler var1);
    }

    public static interface TokenExpirationHandlerCallback {
        public void tokenExpirationHandler(TokenExpirationHandler var1);
    }

    public static interface SignatureCollectorCallback {
        public void signatureCollector(SignatureReceiver var1);
    }

    public static interface CardPresentedCallback {
        public void cardPresented(Card var1);
    }

    public static interface TransactionCompletedCallback {
        public void transactionCompleted(RetailSDKException var1, TransactionRecord var2);
    }
}

