/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk;

import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.IManticoreTypeConverter;
import com.paypal.paypalretailsdk.AuthStatus;
import com.paypal.paypalretailsdk.AuthorizedTransaction;
import com.paypal.paypalretailsdk.Invoice;
import com.paypal.paypalretailsdk.InvoicePaymentMethod;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.TransactionContext;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class TransactionManager
extends PayPalRetailObject {
    TransactionManager(V8Object jsValue) {
        super(jsValue);
    }

    static TransactionManager nativeInstanceForObject(V8Object jsValue) {
        if (jsValue == null || jsValue.isUndefined()) {
            return null;
        }
        return new TransactionManager(jsValue);
    }

    public TransactionManager() {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                TransactionManager.this.impl = PayPalRetailObject.getEngine().createJsObject("TransactionManager", null);
            }
        });
    }

    public void createTransaction(final Invoice invoice, final TransactionCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJs((Object)invoice)).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("createTransaction", args);
            }
        });
    }

    public void createRefundTransaction(final String invoiceId, final String transactionNumber, final InvoicePaymentMethod paymentMethod, final TransactionCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(invoiceId).push(transactionNumber).push(paymentMethod.getValue()).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("createRefundTransaction", args);
            }
        });
    }

    public void retrieveAuthorization(final Date startDateTime, final Date endDateTime, final Integer pageSize, final List<AuthStatus> status, final RetrieveAuthorizedTransactionsCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)PayPalRetailObject.getEngine().getConverter().asJsDate(startDateTime)).push((V8Value)PayPalRetailObject.getEngine().getConverter().asJsDate(endDateTime)).push(pageSize.intValue()).push((V8Value)PayPalRetailObject.getEngine().getConverter().toJsArray(status, (IManticoreTypeConverter.JsElementConverter)new IManticoreTypeConverter.JsElementConverter<AuthStatus>(){

                    public void push(V8Array dest, AuthStatus nativeValue) {
                        dest.push(nativeValue.getValue());
                    }
                })).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("retrieveAuthorization", args);
            }
        });
    }

    public void retrieveAuthorizationUsingToken(final String nextPageToken, final RetrieveAuthorizedTransactionsCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(nextPageToken).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("retrieveAuthorizationUsingToken", args);
            }
        });
    }

    public void voidAuthorization(final String authorizationId, final VoidAuthorizationCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(authorizationId).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("voidAuthorization", args);
            }
        });
    }

    public void captureAuthorization(final String authorizationId, final String invoiceId, final BigDecimal totalAmount, final BigDecimal gratuityAmount, final String currency, final CaptureAuthorizedTransactionCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(authorizationId).push(invoiceId).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(totalAmount)).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(gratuityAmount)).push(currency).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("captureAuthorization", args);
            }
        });
    }

    public void captureAuthorization(final String authorizationId, final String invoiceId, final BigDecimal totalAmount, final BigDecimal gratuityAmount, final String currency, final String base64SignatureJpeg, final CaptureAuthorizedTransactionCallback callback) {
        TransactionManager.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push(authorizationId).push(invoiceId).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(totalAmount)).push(PayPalRetailObject.getEngine().getConverter().asJsDecimal(gratuityAmount)).push(currency).push(base64SignatureJpeg).push((V8Value)TransactionManager.wrapJavaFn(callback));
                V8Object objectToExecuteOn = TransactionManager.this.impl;
                objectToExecuteOn.executeVoidFunction("captureAuthorizationWithSig", args);
            }
        });
    }

    public String toString() {
        return (String)TransactionManager.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                V8Object objectToExecuteOn = PayPalRetailObject.getEngine().getJsObject("JSON");
                V8Object objectStringify = TransactionManager.this.impl;
                V8Array args = PayPalRetailObject.getEngine().createJsArray().push((V8Value)objectStringify);
                String retVal = objectToExecuteOn.executeStringFunction("stringify", args);
                return retVal;
            }
        });
    }

    private static V8Object wrapJavaFn(final TransactionCallback javaInterface) {
        return (V8Object)TransactionManager.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        V8Object jscontext = null;
                        TransactionContext _context = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            jscontext = args.getObject(1);
                            _context = (TransactionContext)PayPalRetailObject.getEngine().getConverter().asNative((Object)jscontext, TransactionContext.class);
                        }
                        javaInterface.transaction(_error, _context);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final RetrieveAuthorizedTransactionsCallback javaInterface) {
        return (V8Object)TransactionManager.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        V8Array jslistOfAuths = null;
                        List _listOfAuths = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            jslistOfAuths = args.getArray(1);
                            _listOfAuths = PayPalRetailObject.getEngine().getConverter().toNativeArray(jslistOfAuths, (IManticoreTypeConverter.NativeElementConverter)new IManticoreTypeConverter.NativeElementConverter<AuthorizedTransaction>(){

                                public AuthorizedTransaction convert(Object jsValue) {
                                    return (AuthorizedTransaction)PayPalRetailObject.getEngine().getConverter().asNative(jsValue, AuthorizedTransaction.class);
                                }
                            });
                        }
                        String jsnextPageToken = null;
                        String _nextPageToken = null;
                        if (args.length() > 2 && args.getType(2) != 99) {
                            _nextPageToken = jsnextPageToken = args.getString(2);
                        }
                        javaInterface.retrieveAuthorizedTransactions(_error, _listOfAuths, _nextPageToken);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final VoidAuthorizationCallback javaInterface) {
        return (V8Object)TransactionManager.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        javaInterface.voidAuthorization(_error);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    private static V8Object wrapJavaFn(final CaptureAuthorizedTransactionCallback javaInterface) {
        return (V8Object)TransactionManager.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() throws Exception {
                V8Object _object = PayPalRetailObject.getEngine().createJsObject();
                _object.registerJavaMethod(new JavaVoidCallback(){

                    public void invoke(V8Object jsThis, V8Array args) {
                        V8Object jserror = null;
                        RetailSDKException _error = null;
                        if (args.length() > 0 && args.getType(0) != 99) {
                            jserror = args.getObject(0);
                            _error = (RetailSDKException)PayPalRetailObject.getEngine().getConverter().asNative((Object)jserror, RetailSDKException.class);
                        }
                        String jscaptureId = null;
                        String _captureId = null;
                        if (args.length() > 1 && args.getType(1) != 99) {
                            _captureId = jscaptureId = args.getString(1);
                        }
                        javaInterface.captureAuthorizedTransaction(_error, _captureId);
                    }
                }, "_");
                V8Object fn = _object.getObject("_");
                _object.release();
                return fn;
            }
        });
    }

    public static interface CaptureAuthorizedTransactionCallback {
        public void captureAuthorizedTransaction(RetailSDKException var1, String var2);
    }

    public static interface VoidAuthorizationCallback {
        public void voidAuthorization(RetailSDKException var1);
    }

    public static interface RetrieveAuthorizedTransactionsCallback {
        public void retrieveAuthorizedTransactions(RetailSDKException var1, List<AuthorizedTransaction> var2, String var3);
    }

    public static interface TransactionCallback {
        public void transaction(RetailSDKException var1, TransactionContext var2);
    }
}

