/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationServices;
import com.paypal.paypalretailsdk.location.LocationService;

public class LocationServiceImpl
implements LocationService,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static GoogleApiClient sLocationClient;
    private static Location sCurrentLocation;
    private static Context sContext;
    private LocationManager mLocationManager;
    private static final String LOG_TAG;

    public LocationServiceImpl(Context context) {
        sContext = context;
        sLocationClient = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.mLocationManager = (LocationManager)sContext.getSystemService("location");
    }

    @Override
    public void start() {
        if (this.isLocationProviderEnabled() && !sLocationClient.isConnected() && !sLocationClient.isConnecting()) {
            sLocationClient.connect();
        }
    }

    @Override
    public void end() {
        if (sLocationClient.isConnected()) {
            sLocationClient.disconnect();
        }
    }

    @Override
    public boolean isLocationProviderEnabled() {
        try {
            boolean isLocationEnabled = this.mLocationManager.isProviderEnabled("gps") || this.mLocationManager.isProviderEnabled("network");
            Log.d((String)(LOG_TAG + "isLocationEnabled: "), (String)String.valueOf(isLocationEnabled));
            return isLocationEnabled;
        }
        catch (SecurityException e) {
            Log.d((String)LOG_TAG, (String)"Below 5.0; Insufficient permissions to access Location");
            return false;
        }
    }

    @Override
    public Location getCurrentLocation() {
        return sLocationClient.isConnected() ? LocationServices.FusedLocationApi.getLastLocation(sLocationClient) : null;
    }

    @Override
    public boolean isLocationFound() {
        return sLocationClient.isConnected() && sCurrentLocation != null;
    }

    public void onConnected(Bundle bundle) {
        sCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(sLocationClient);
        if (sCurrentLocation != null) {
            Log.d((String)"Location", (String)("sCurrentLocation : " + sCurrentLocation.getLatitude() + " : " + sCurrentLocation.getLongitude()));
        }
    }

    public void onConnectionSuspended(int i) {
        sCurrentLocation = null;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        sCurrentLocation = null;
    }

    public void onLocationChanged(Location location) {
        sCurrentLocation = location;
    }

    static {
        LOG_TAG = LocationServiceImpl.class.getSimpleName();
    }
}

