/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.readers.common;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.RoamSwiperDevice;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.CardReaderInterface;
import com.paypal.paypalretailsdk.readers.common.CardReaderObserver;
import com.paypal.paypalretailsdk.readers.swipers.RoamSwiper;
import com.paypal.paypalretailsdk.ui.permissions.AudioAccessPermissionListener;
import com.paypal.paypalretailsdk.ui.permissions.RunTimePermissionUtil;

public class AudioJackManager
extends BroadcastReceiver {
    public static final String AUDIO_READER_NAME = "PayPal Audio Reader";
    private static final String LOG_TAG = "native.swiper";
    public static final String AUDIO_HARDWARE_ADDRESS = "RoamSwiper";
    protected CardReaderInterface.DeviceTypes mCurrentDeviceType;
    private RoamSwiper mCurrentActiveModule = null;
    RoamSwiperDevice mDevice;
    private Context mContext = null;
    private static AudioJackManager sInstance;
    private boolean mDoesRoamPluggedIn = false;
    private boolean mUserEducatedForAudioAccess = false;
    private AudioAccessPermissionListener mAudioAccessPermissionListener;

    public static synchronized AudioJackManager getInstance() {
        if (sInstance == null) {
            sInstance = new AudioJackManager();
        }
        return sInstance;
    }

    private AudioJackManager() {
    }

    public void register(Context context) {
        this.mContext = context;
        if (null != this.mContext) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "Exception received while clearing the context. Ignore this. " + e.toString());
            }
            this.mContext.registerReceiver((BroadcastReceiver)sInstance, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.mContext.registerReceiver((BroadcastReceiver)sInstance, new IntentFilter("android.media.AUDIO_BECOMING_NOISY"));
        }
    }

    public boolean isConnected() {
        if (null != this.mCurrentActiveModule) {
            return this.mCurrentActiveModule.isConnected();
        }
        return false;
    }

    public void disconnect() {
        if (null != this.mContext) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)sInstance);
            }
            catch (Exception e) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "Exception received while un-registering receiver. Ignore this. " + e.toString());
            }
        }
        this.unInitializeSwiper();
    }

    public void listenForCardEvents() {
        if (null != this.mCurrentActiveModule) {
            RetailSDK.log(logLevel.info, LOG_TAG, "Starting to listen for card events");
            this.mCurrentActiveModule.listenForCardEvents();
        }
    }

    public void stopListeningForCardEvents() {
        if (null != this.mCurrentActiveModule) {
            RetailSDK.log(logLevel.info, LOG_TAG, "Stopping to listen for card events");
            this.mCurrentActiveModule.stopTransaction();
        }
    }

    public void registerObserverToRoamSwiper(CardReaderObserver observer) {
        if (null != this.mCurrentActiveModule) {
            this.mCurrentActiveModule.setObserver(observer);
        }
    }

    public String getName() {
        if (null != this.mCurrentActiveModule) {
            return AUDIO_READER_NAME;
        }
        return null;
    }

    public void registerAudioPermissionsListener(AudioAccessPermissionListener audioAccessPermissionListener) {
        if (this.mAudioAccessPermissionListener == null) {
            this.mAudioAccessPermissionListener = audioAccessPermissionListener;
        }
    }

    public void unregisterAudioPermissionsListener() {
        this.mAudioAccessPermissionListener = null;
    }

    public void setUserEducatedForAudioAccess(boolean isUserEducated) {
        this.mUserEducatedForAudioAccess = isUserEducated;
    }

    public void onReceive(Context context, Intent intent) {
        try {
            RetailSDK.log(logLevel.debug, LOG_TAG, "onReceive " + intent.getAction());
            if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                int callState = telephonyManager.getCallState();
                int headSetState = intent.getIntExtra("state", 1);
                int hasMicrophone = intent.getIntExtra("microphone", 0);
                if (1 == headSetState && 1 == hasMicrophone && 2 != callState) {
                    if (!RunTimePermissionUtil.shouldAskPermission(this.mContext, "android.permission.RECORD_AUDIO")) {
                        this.handleSwiperSetupPostPermissionGrant();
                    } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)RetailSDK.getAppState().getCurrentActivity(), (String)"android.permission.RECORD_AUDIO") && !this.mUserEducatedForAudioAccess) {
                        this.mAudioAccessPermissionListener.onPermissionPreviouslyDenied(false);
                    } else if (this.isAskingPermissionForFirstTime(this.mContext, "android.permission.RECORD_AUDIO")) {
                        this.firstTimeAskingPermission(this.mContext, "android.permission.RECORD_AUDIO");
                        this.mAudioAccessPermissionListener.onNeedPermission();
                    } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)RetailSDK.getAppState().getCurrentActivity(), (String)"android.permission.RECORD_AUDIO")) {
                        this.mAudioAccessPermissionListener.onPermissionDisabled();
                    } else {
                        this.mAudioAccessPermissionListener.onPermissionPreviouslyDenied(true);
                    }
                } else if (0 == headSetState) {
                    RetailSDK.log(logLevel.debug, LOG_TAG, "onReceive Headset unplugged");
                    this.unInitializeSwiper();
                }
            } else if (intent.getAction().equals("android.media.AUDIO_BECOMING_NOISY")) {
                this.unInitializeSwiper();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isAskingPermissionForFirstTime(Context context, String permission2) {
        return context.getSharedPreferences("PayPalBase", 0).getBoolean(permission2, true);
    }

    private void firstTimeAskingPermission(Context context, String permission2) {
        context.getSharedPreferences("PayPalBase", 0).edit().putBoolean(permission2, false).apply();
    }

    public void handleSwiperSetupPostPermissionGrant() {
        Handler delaySwiperDetection = new Handler((Handler.Callback)new DelaySwiperDetectionCallBack());
        delaySwiperDetection.sendEmptyMessageDelayed(0, 1000L);
    }

    public void initializeRoamSwiper() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "initializeRoamSwiper");
        this.mCurrentDeviceType = CardReaderInterface.DeviceTypes.RoamPayReader;
        this.mCurrentActiveModule = RoamSwiper.getInstance(this.mContext);
        if (null != this.mCurrentActiveModule) {
            this.mCurrentActiveModule.markAudioJackDeviceAsPlugged(true);
            this.mDoesRoamPluggedIn = true;
            if (this.mDevice == null) {
                this.mDevice = new RoamSwiperDevice();
                PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        AudioJackManager.this.mDevice.createJSReader();
                    }
                });
            }
        }
    }

    public void unInitializeSwiper() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "unInitializeSwiper currentReaderType: " + (Object)((Object)this.mCurrentDeviceType));
        if (null == this.mCurrentActiveModule) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "currentActiveModule is null. Hence there is nothing initialized to unInitialize");
            return;
        }
        if (!this.mCurrentActiveModule.isAudioJackDevicePlugged()) {
            return;
        }
        this.mCurrentActiveModule.stopTransaction();
        this.mCurrentActiveModule.markAudioJackDeviceAsPlugged(false);
        this.mDoesRoamPluggedIn = false;
        this.mDevice = null;
    }

    public RoamSwiperDevice getDevice() {
        return this.mDevice;
    }

    public boolean doesRoamPluggedIn() {
        return this.mDoesRoamPluggedIn;
    }

    private class DelaySwiperDetectionCallBack
    implements Handler.Callback {
        private DelaySwiperDetectionCallBack() {
        }

        public boolean handleMessage(Message msg) {
            AudioJackManager.this.initializeRoamSwiper();
            return true;
        }
    }
}

