/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.readers.common;

import android.util.Log;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.regex.Pattern;

public enum CardIssuer {
    VISA("VISA"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            return cardNumber.length() > 0 && cardNumber.charAt(0) == this.VISA_CONTROL_NUMBER.charValue();
        }
    }
    ,
    MASTERCARD("MASTERCARD"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            if (StringUtil.isEmpty(cardNumber) || cardNumber.length() < 2) {
                return false;
            }
            int firstTwo = Integer.parseInt(cardNumber.substring(0, 2));
            return firstTwo > 50 && firstTwo < 56;
        }
    }
    ,
    MAESTRO("MAESTRO"){
        final Pattern MAESTRO_CONTROL_NUMBER = Pattern.compile("(^50[0-9]{0,17}$)|(^5[6-9][0-9]{0,17}$)|(^6[0-9]{0,18}$)");
        final Pattern MAESTRO_VALIDATION = Pattern.compile("(^50[0-9]{10,17}$)|(^5[6-9][0-9]10{0,17}$)|(^6[0-9]{11,18}$)");

        @Override
        public boolean isTypeOf(String cardNumber) {
            return this.MAESTRO_CONTROL_NUMBER.matcher(cardNumber).matches();
        }
    }
    ,
    AMEX("AMEX"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            if (cardNumber.length() < 2) {
                return false;
            }
            String cardControlNumber = cardNumber.substring(0, 2);
            return cardNumber.length() > 1 && (cardControlNumber.equals(this.AMEX_CONTROL_NUMBER_1) || cardControlNumber.equals(this.AMEX_CONTROL_NUMBER_2));
        }
    }
    ,
    JCB("JCB"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            if (cardNumber.length() < 4) {
                return false;
            }
            try {
                int cardControlNumber = Integer.parseInt(cardNumber.substring(0, 2));
                return cardNumber.length() > 1 && cardControlNumber == this.JCB_CONTROL_NUMBER;
            }
            catch (NumberFormatException nfe) {
                Log.d((String)"Card Issuer", (String)("Number format exception parsing: " + cardNumber));
                return false;
            }
        }
    }
    ,
    DISCOVER("DISC"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            int lenght = cardNumber.length();
            if (lenght >= 4 && cardNumber.substring(0, 4).equals(this.DISCOVER_CONTROL_NUMBER_1)) {
                return true;
            }
            return lenght > 1 && cardNumber.substring(0, 2).equals(this.DISCOVER_CONTROL_NUMBER_2);
        }
    }
    ,
    PAYPAL("PAYPAL"){

        @Override
        public boolean isTypeOf(String cardNumber) {
            if (cardNumber.length() < 2) {
                return false;
            }
            String cardControlNumber = cardNumber.substring(0, 2);
            return cardNumber.length() > 1 && cardControlNumber.equals(this.PAYPAL_CONTROL_NUMBER);
        }
    }
    ,
    UNKNOWN(""){

        @Override
        public boolean isTypeOf(String cardNumber) {
            return true;
        }
    };

    private static HashMap<String, CardIssuer> nameAndEnumMap;
    Character VISA_CONTROL_NUMBER = Character.valueOf('4');
    Character MASTERCARD_CONTROL_NUMBER = Character.valueOf('5');
    String AMEX_CONTROL_NUMBER_1 = "34";
    String AMEX_CONTROL_NUMBER_2 = "37";
    String DISCOVER_CONTROL_NUMBER_1 = "6011";
    String DISCOVER_CONTROL_NUMBER_2 = "65";
    String PAYPAL_CONTROL_NUMBER = "62";
    int JCB_CONTROL_NUMBER = 35;
    private String mCodeName;

    private CardIssuer(String codeName) {
        this.mCodeName = codeName;
    }

    public static CardIssuer getEnum(String codeName) {
        if (StringUtil.isEmpty(codeName)) {
            return null;
        }
        codeName = codeName.toUpperCase();
        for (String key : nameAndEnumMap.keySet()) {
            if (!codeName.contains(key)) continue;
            return nameAndEnumMap.get(key);
        }
        return null;
    }

    public static CardIssuer getType(String cardNumber) {
        for (CardIssuer issuer : CardIssuer.values()) {
            if (!issuer.isTypeOf(cardNumber)) continue;
            return issuer;
        }
        return null;
    }

    public String getCodeName() {
        return this.mCodeName;
    }

    public abstract boolean isTypeOf(String var1);

    static {
        nameAndEnumMap = new HashMap();
        for (CardIssuer t : EnumSet.allOf(CardIssuer.class)) {
            nameAndEnumMap.put(t.getCodeName(), t);
        }
    }
}

