/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.readers.common;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String LOG_TAG = "PPHSDK+StringUtil";
    private static SimpleDateFormat df_e = new SimpleDateFormat("HH:mm:ss MMM d, yyyy zzz", Locale.ENGLISH);
    private static SimpleDateFormat df_us = new SimpleDateFormat("HH:mm:ss MMM d, yyyy zzz", Locale.US);
    private static Pattern mEmailValid = Pattern.compile("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,} *$");

    public static boolean validateEmail(String email) {
        return mEmailValid.matcher(email).matches();
    }

    public static boolean isAlphaNumeric(String string2) {
        char c = '\u0000';
        for (int i = 0; i < string2.length(); ++i) {
            c = string2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String string2) {
        return string2 == null || string2.trim().length() == 0;
    }

    public static boolean isNotEmpty(String string2) {
        return string2 != null && string2.trim().length() > 0;
    }

    public static String emptyIfNull(String inString) {
        return inString == null ? "" : inString;
    }

    public static Date parseDate(String inDate) {
        Date out = null;
        df_e.setLenient(true);
        try {
            out = df_e.parse(inDate);
        }
        catch (ParseException e) {
            df_us.setLenient(true);
            try {
                out = df_us.parse(inDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return out;
    }

    public static String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
            temp.append(decimal);
        }
        return sb.toString();
    }

    public static String convertStreamToString(InputStream in) {
        Scanner s = new Scanner(in).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String encodeXml(String s) {
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        String resultString = s;
        resultString = resultString.replace("&", "&amp;");
        resultString = resultString.replace("\"", "&quot;");
        resultString = resultString.replace("'", "&apos;");
        resultString = resultString.replace("`", "&apos;");
        resultString = resultString.replace("<", "&lt;");
        resultString = resultString.replace(">", "&gt;");
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStream(InputStream is) {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)("File read failed: " + e.toString()));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return ((Object)writer).toString();
    }

    public static void writeToFile(OutputStream os, String data) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os);
            outputStreamWriter.write(data);
            outputStreamWriter.close();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)("File write failed: " + e.toString()));
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String coalesce(String ... items) {
        for (String val : items) {
            if (!StringUtil.isNotEmpty(val)) continue;
            return val;
        }
        return null;
    }

    public static String defaultIfEmpty(String input, String defaultValue) {
        return StringUtil.isEmpty(input) ? defaultValue : input;
    }

    public static String defaultIfNotValid(boolean expresion, String input, String defaultValue) {
        return expresion ? input : defaultValue;
    }

    public static String join(List<?> array, char separator) {
        if (array.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object item : array) {
            builder.append(item).append(separator);
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }
}

