/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.readers.swipers;

import android.content.Context;
import android.util.Log;
import com.bbpos.swiper.SwiperController;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.AudioJackCardReaderInterface;
import com.paypal.paypalretailsdk.readers.common.CardReaderInterface;
import com.paypal.paypalretailsdk.readers.common.CardReaderManager;
import com.paypal.paypalretailsdk.readers.common.CardReaderObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RoamSwiper
implements AudioJackCardReaderInterface {
    private static final String LOG_TAG = "native.roamSwiper";
    private static RoamSwiper mInstance;
    private Context mContext;
    private StateChangedListener mRoamStateListener;
    private SwiperController mRoamSwiperController;
    private CardReaderObserver mObserver;
    private List<SwiperController.SwiperStateChangedListener> mSwiperStateChangeListeners;
    private String mKsn = null;
    private int mSwipeFailureReason;
    private ArrayBlockingQueue<SwiperCommand> mCommandsQueue;
    private boolean mIsCommandRunning;
    private final int mSwiperCommandQueueSize = 3;
    private Runnable checker;
    private ScheduledFuture next;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private boolean mCheckerInProgress = false;
    private final Object lock = new Object();

    private RoamSwiper(Context context) {
        this.mContext = context;
        this.mSwiperStateChangeListeners = new CopyOnWriteArrayList<SwiperController.SwiperStateChangedListener>();
        this.mCommandsQueue = new ArrayBlockingQueue(3);
        this.initialize();
    }

    public static RoamSwiper getInstance(Context context) {
        if (null == mInstance) {
            mInstance = new RoamSwiper(context);
        }
        return mInstance;
    }

    private void initialize() {
        if (null != this.mRoamStateListener) {
            this.mRoamStateListener = null;
        }
        if (null != this.mRoamSwiperController) {
            this.mRoamSwiperController.deleteSwiper();
            this.mRoamSwiperController = null;
        }
        this.mRoamStateListener = new StateChangedListener();
        this.mRoamSwiperController = SwiperController.createInstance((Context)this.mContext, (SwiperController.SwiperStateChangedListener)this.mRoamStateListener);
        this.mRoamSwiperController.setDetectDeviceChange(true);
        this.mRoamSwiperController.setSwipeTimeout(-1.0);
        this.mIsCommandRunning = false;
        this.notifyDevicePresentStatus();
    }

    @Override
    public AudioJackCardReaderInterface getAudioJackReaderInterface() {
        return this;
    }

    @Override
    public void listenForCardEvents() {
        this.queueSwiperCommand(SwiperCommand.START_SWIPE);
    }

    @Override
    public void stopTransaction() {
        this.queueSwiperCommand(SwiperCommand.STOP_SWIPE);
    }

    @Override
    public void markAudioJackDeviceAsPlugged(boolean pluggedIn) {
        Log.d((String)LOG_TAG, (String)("markAudioJackDeviceAsPlugged " + pluggedIn));
        if (pluggedIn) {
            if (null == this.mRoamSwiperController) {
                this.initialize();
            }
        } else {
            if (null != this.mRoamSwiperController) {
                Log.d((String)LOG_TAG, (String)"About to deleteSwiper");
                this.mRoamSwiperController.deleteSwiper();
                this.mRoamSwiperController = null;
            }
            mInstance = null;
            if (null != this.mObserver) {
                Log.d((String)LOG_TAG, (String)("markAudioJackDeviceAsPluggged OnDeviceLostConnection " + pluggedIn));
                this.mObserver.onDeviceLostConnection(CardReaderInterface.DeviceTypes.RoamPayReader, CardReaderInterface.DeviceFamily.MagneticCardReader);
            }
        }
    }

    @Override
    public boolean isAudioJackDevicePlugged() {
        return this.mRoamSwiperController != null;
    }

    @Override
    public boolean isConnected() {
        boolean devicePresent = false;
        if (null != this.mRoamSwiperController) {
            SwiperController.SwiperControllerState state = this.mRoamSwiperController.getSwiperControllerState();
            switch (state) {
                case STATE_WAITING_FOR_DEVICE: {
                    devicePresent = false;
                    break;
                }
                case STATE_IDLE: {
                    this.mRoamSwiperController.isSwiperHere();
                    devicePresent = true;
                    break;
                }
                default: {
                    devicePresent = true;
                }
            }
        }
        return devicePresent;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public CardReaderManager.ReaderTypes getReaderType() {
        return CardReaderManager.ReaderTypes.MagneticCardReader;
    }

    @Override
    public CardReaderInterface.DeviceTypes getDeviceType() {
        return CardReaderInterface.DeviceTypes.RoamPayReader;
    }

    @Override
    public CardReaderInterface.DeviceFamily getDeviceFamily() {
        return CardReaderInterface.DeviceFamily.MagneticCardReader;
    }

    private void notifyDevicePresentStatus() {
        if (null != this.mRoamSwiperController && this.mRoamSwiperController.isDevicePresent()) {
            this.mRoamSwiperController.isSwiperHere();
        }
    }

    public void setObserver(CardReaderObserver observer) {
        this.mObserver = observer;
    }

    public void removeObserver() {
        this.mObserver = null;
    }

    private void executeStopSwipe() {
        this.mRoamSwiperController.stopSwiper();
    }

    private void executeStartSwipe() {
        this.mRoamSwiperController.startSwiper();
    }

    private void logSwipeFailureToCal(int reason) {
        Log.d((String)LOG_TAG, (String)("logSwipeFailureToCal: msg: " + reason));
        if (null == this.mKsn) {
            Log.d((String)LOG_TAG, (String)"logswipeFailureToCal swiper ksn is null. Hence calling getSwiperKsn()");
            this.mSwipeFailureReason = reason;
        }
    }

    private void logSwipeSuccessToCal() {
        Log.d((String)LOG_TAG, (String)"In RoamSwiper, calling successfulPaymentEntry ");
    }

    synchronized void runAllCommands() {
        if (this.mIsCommandRunning || this.mCommandsQueue.isEmpty() || this.mRoamSwiperController == null) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Exiting Swiper.runAllCommands() mIsCommandRunning: " + this.mIsCommandRunning + ", Queue size: " + this.mCommandsQueue.size() + ", Contents: " + this.mCommandsQueue.toString());
            return;
        }
        try {
            SwiperController.SwiperControllerState state = this.mRoamSwiperController.getSwiperControllerState();
            RetailSDK.log(logLevel.debug, LOG_TAG, "Swiper state: " + state + ", Queue size: " + this.mCommandsQueue.size() + " contents: " + this.mCommandsQueue.toString());
            SwiperCommand command = this.mCommandsQueue.take();
            if (command == SwiperCommand.STOP_SWIPE && SwiperController.SwiperControllerState.STATE_IDLE != state) {
                Log.d((String)LOG_TAG, (String)" Executing swiper command stopSwiper ");
                this.executeStopSwipe();
                this.mIsCommandRunning = true;
            } else if (command == SwiperCommand.START_SWIPE && SwiperController.SwiperControllerState.STATE_IDLE == state) {
                Log.d((String)LOG_TAG, (String)" Executing swiper command startSwiper ");
                this.executeStartSwipe();
                this.mIsCommandRunning = true;
            } else if (command == SwiperCommand.GET_KSN && state.equals((Object)SwiperController.SwiperControllerState.STATE_IDLE)) {
                Log.w((String)LOG_TAG, (String)" Executing get KSN command");
                this.mRoamSwiperController.getSwiperKsn();
                this.mIsCommandRunning = true;
            } else {
                Log.d((String)LOG_TAG, (String)(" COULD NOT Execute " + (Object)((Object)command) + ", state: " + state));
            }
        }
        catch (InterruptedException e) {
            Log.d((String)LOG_TAG, (String)(" InterruptedException while executing swiper commands. Message:  " + e.getMessage()));
            this.mIsCommandRunning = false;
        }
        Log.d((String)LOG_TAG, (String)("B Swiper command queue size: " + this.mCommandsQueue.size() + " contents: " + this.mCommandsQueue.toString()));
    }

    synchronized void callbackFromSwiperCommand(String callback) {
        Log.d((String)LOG_TAG, (String)(" callbackFromSwiperCommand " + callback));
        this.mIsCommandRunning = false;
        this.runAllCommands();
    }

    private boolean isCommandAlreadyTheTail(SwiperCommand swiperCommand) {
        SwiperCommand lastCommand = null;
        Iterator<SwiperCommand> iterator = this.mCommandsQueue.iterator();
        while (iterator.hasNext()) {
            SwiperCommand command;
            lastCommand = command = iterator.next();
        }
        return swiperCommand.equals((Object)lastCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void queueSwiperCommand(SwiperCommand command) {
        Object object;
        RetailSDK.log(logLevel.debug, LOG_TAG, "Request to queue command " + command.toString());
        if (this.mCheckerInProgress && this.mCommandsQueue.size() < 3) {
            Log.d((String)LOG_TAG, (String)("checker is IN PROGRESS and queue size is coming down: " + this.mCommandsQueue.size() + " so swiper is in GOOD state"));
            object = this.lock;
            synchronized (object) {
                this.mCheckerInProgress = false;
            }
            if (this.next != null) {
                this.next.cancel(false);
            }
            if (this.executor != null || !this.executor.isShutdown()) {
                this.executor.shutdown();
            }
        }
        if (this.mCommandsQueue.size() > 0 && this.isCommandAlreadyTheTail(command)) {
            Log.d((String)LOG_TAG, (String)("NOT queueing swiper command " + (Object)((Object)command)));
            Log.d((String)LOG_TAG, (String)("-- Swiper command queue size: " + this.mCommandsQueue.size() + " contents: " + this.mCommandsQueue.toString()));
        } else if (this.mCommandsQueue.size() >= 3) {
            Log.d((String)LOG_TAG, (String)("NOT queueing swiper command " + (Object)((Object)command) + " due to FULL queue"));
            Log.d((String)LOG_TAG, (String)("-- Swiper command queue FULL size: " + this.mCommandsQueue.size() + " contents: " + this.mCommandsQueue.toString()));
            if (!this.mCheckerInProgress) {
                Log.d((String)LOG_TAG, (String)"checker is not InProgress");
                object = this.lock;
                synchronized (object) {
                    this.mCheckerInProgress = true;
                }
                this.checker = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Log.d((String)RoamSwiper.LOG_TAG, (String)("Swiper command queue size: " + RoamSwiper.this.mCommandsQueue.size() + " contents: " + RoamSwiper.this.mCommandsQueue.toString()));
                        if (RoamSwiper.this.mCommandsQueue.size() >= 3) {
                            Log.d((String)RoamSwiper.LOG_TAG, (String)("checker is IN PROGRESS and queue size is NOT coming down: " + RoamSwiper.this.mCommandsQueue.size() + " so swiper is in BAD state. Restarting the swiper!"));
                            RetailSDK.endRoamSwiper();
                            RetailSDK.beginRoamSwiper();
                            Object object = RoamSwiper.this.lock;
                            synchronized (object) {
                                RoamSwiper.this.mCheckerInProgress = false;
                            }
                        }
                    }
                };
                this.next = this.executor.schedule(this.checker, 2L, TimeUnit.SECONDS);
            } else {
                Log.d((String)LOG_TAG, (String)("NOT queueing swiper command " + (Object)((Object)command) + " due to checker in PROGRESS"));
            }
        } else {
            this.mCommandsQueue.add(command);
            Log.d((String)LOG_TAG, (String)(" queueing swiper command " + (Object)((Object)command)));
        }
        this.runAllCommands();
    }

    private class StateChangedListener
    implements SwiperController.SwiperStateChangedListener {
        private StateChangedListener() {
        }

        public void onDecodeCompleted(HashMap<String, String> decodeData) {
            Log.v((String)"native.roamSwiperRoamReader", (String)"Looks like the decoding went through well too!");
            String formatID = decodeData.get("formatID");
            String ksn = decodeData.get("ksn");
            String encTrack = decodeData.get("encTrack");
            String maskedPAN = decodeData.get("maskedPAN");
            String partialTrack = decodeData.get("partialTrack");
            String cardHolderName = decodeData.get("cardholderName");
            String expDate = decodeData.get("expiryDate");
            RoamSwiper.this.mKsn = ksn;
            String track1 = SwiperController.packEncTrackData((String)formatID, (String)encTrack, (String)partialTrack);
            if (track1 != null) {
                if (null != RoamSwiper.this.mObserver) {
                    RoamSwiper.this.mObserver.onSwipeDetected(decodeData, track1);
                }
                RoamSwiper.this.logSwipeSuccessToCal();
            } else {
                if (null != RoamSwiper.this.mObserver) {
                    RoamSwiper.this.mObserver.onSwipeFailed();
                }
                RoamSwiper.this.listenForCardEvents();
            }
            RoamSwiper.this.callbackFromSwiperCommand("onDecodeCompleted");
        }

        public void onDecodeError(SwiperController.DecodeResult decodeResult) {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"onDecodeError");
            switch (decodeResult) {
                case DECODE_SWIPE_FAIL: {
                    if (null == RoamSwiper.this.mObserver) break;
                    RoamSwiper.this.mObserver.onSwipeFailed();
                    break;
                }
                case DECODE_COMM_ERROR: {
                    if (null == RoamSwiper.this.mObserver) break;
                    RoamSwiper.this.mObserver.onDeviceError("Roam Swiper reports a DECODE_COMM_ERROR");
                    break;
                }
                case DECODE_CRC_ERROR: {
                    if (null == RoamSwiper.this.mObserver) break;
                    RoamSwiper.this.mObserver.onDeviceError("Roam Swiper reports a DECODE_CRC_ERROR");
                    break;
                }
                default: {
                    if (null == RoamSwiper.this.mObserver) break;
                    RoamSwiper.this.mObserver.onDeviceError("Roam Swiper swipe failed with undefined Decode Result: " + decodeResult);
                }
            }
            RoamSwiper.this.listenForCardEvents();
            RoamSwiper.this.callbackFromSwiperCommand("onDecodeError");
        }

        public void onGetKsnCompleted(String ksn) {
            RetailSDK.log(logLevel.debug, RoamSwiper.LOG_TAG, "onGetKsnCompleted: ksn: " + ksn + " Log the swipe failure event to cal..");
            RoamSwiper.this.mKsn = ksn;
            for (SwiperController.SwiperStateChangedListener listener : RoamSwiper.this.mSwiperStateChangeListeners) {
                listener.onGetKsnCompleted(ksn);
            }
            if (RoamSwiper.this.mObserver != null) {
                RoamSwiper.this.mObserver.onKsnReceived(ksn);
            }
            RoamSwiper.this.callbackFromSwiperCommand("onGetKsnCompleted");
        }

        public void onError(String message) {
            RetailSDK.log(logLevel.warn, RoamSwiper.LOG_TAG, "reportErrorBackToApplication called back. Message = " + message);
            if (message.equalsIgnoreCase("Volume warning not accepted")) {
                if (RoamSwiper.this.mObserver != null) {
                    RoamSwiper.this.mObserver.onDeviceDetected(false, CardReaderInterface.DeviceTypes.RoamPayReader, CardReaderInterface.DeviceFamily.MagneticCardReader);
                } else {
                    Log.i((String)RoamSwiper.LOG_TAG, (String)"********************** mObserver is null!! ***************. If you see this, please DIAGNOSE FURTHER!!");
                }
                return;
            }
            for (SwiperController.SwiperStateChangedListener listener : RoamSwiper.this.mSwiperStateChangeListeners) {
                listener.onError(message);
            }
            RoamSwiper.this.callbackFromSwiperCommand("onError");
            if (message.contains("Failed to create audio recorder")) {
                RoamSwiper.this.queueSwiperCommand(SwiperCommand.STOP_SWIPE);
                RoamSwiper.this.queueSwiperCommand(SwiperCommand.START_SWIPE);
            }
            if (message.contains("Failed to get KSN")) {
                RoamSwiper.this.queueSwiperCommand(SwiperCommand.GET_KSN);
            }
        }

        public void onInterrupted() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"onInterrupted() called back");
            RoamSwiper.this.callbackFromSwiperCommand("onInterrupted");
        }

        public void onNoDeviceDetected() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"onNoDeviceDetected() called back");
            RoamSwiper.this.callbackFromSwiperCommand("onNoDeviceDetected");
        }

        public void onTimeout() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"A very helpful timeout message has been received");
        }

        public void onCardSwipeDetected() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"We now have a card swipe!");
        }

        public void onWaitingForCardSwipe() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"onWaitingForCardSwipe() is received");
            RoamSwiper.this.callbackFromSwiperCommand("onWaitingForCardSwipe");
        }

        public void onWaitingForDevice() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)("onWaitingForDevice is received. State = " + RoamSwiper.this.mRoamSwiperController.getSwiperControllerState()));
        }

        public void onDevicePlugged() {
            SwiperController.SwiperControllerState swiperControllerState = RoamSwiper.this.mRoamSwiperController.getSwiperControllerState();
            if (SwiperController.SwiperControllerState.STATE_IDLE == swiperControllerState) {
                Log.d((String)RoamSwiper.LOG_TAG, (String)"Device is plugged and we are in idle state so invoking getSwiperKsn");
                RoamSwiper.this.mRoamSwiperController.isSwiperHere();
            } else {
                Log.w((String)RoamSwiper.LOG_TAG, (String)("Device plugged but we are not idle! state = " + swiperControllerState));
            }
        }

        public void onDeviceUnplugged() {
            Log.d((String)RoamSwiper.LOG_TAG, (String)"onDeviceUnplugged is invoked!");
            if (null != RoamSwiper.this.mObserver) {
                RoamSwiper.this.mObserver.onDeviceLostConnection(CardReaderInterface.DeviceTypes.RoamPayReader, CardReaderInterface.DeviceFamily.MagneticCardReader);
            }
        }

        public void onSwiperHere(boolean isRoam) {
            if (RoamSwiper.this.mRoamSwiperController == null) {
                return;
            }
            RetailSDK.log(logLevel.debug, RoamSwiper.LOG_TAG, "onSwiperHere is invoked with isRoam = " + isRoam + ", state - " + RoamSwiper.this.mRoamSwiperController.getSwiperControllerState());
            if (null != RoamSwiper.this.mObserver) {
                RoamSwiper.this.mObserver.onDeviceDetected(isRoam, CardReaderInterface.DeviceTypes.RoamPayReader, CardReaderInterface.DeviceFamily.MagneticCardReader);
            }
            if (isRoam && RoamSwiper.this.mKsn == null && RoamSwiper.this.mRoamSwiperController.getSwiperControllerState().equals((Object)SwiperController.SwiperControllerState.STATE_IDLE)) {
                RoamSwiper.this.queueSwiperCommand(SwiperCommand.GET_KSN);
            }
            if (isRoam && RoamSwiper.this.mRoamSwiperController.getSwiperControllerState().equals((Object)SwiperController.SwiperControllerState.STATE_IDLE)) {
                RoamSwiper.this.queueSwiperCommand(SwiperCommand.START_SWIPE);
            }
        }
    }

    private static enum SwiperCommand {
        STOP_SWIPE,
        START_SWIPE,
        GET_KSN;

    }
}

