/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui;

import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.res.ResourcesCompat;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.DeviceConnectorOptions;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.BaseController;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderPresenter;
import com.paypal.paypalretailsdk.ui.connection.retryAfterScan.ConnectRetryReaderPresenter;
import com.paypal.paypalretailsdk.ui.errors.connect.ConnectErrorPresenter;
import com.paypal.paypalretailsdk.ui.errors.connectafterscan.ScanConnectErrorPresenter;
import com.paypal.paypalretailsdk.ui.errors.scan.ScanErrorPresenter;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;

public class DeviceConnectionActivity
extends FragmentActivity
implements BaseController {
    private static final String LOG_TAG = "DeviceConnectionActivity";
    private static DeviceConnectorOptions mCardReaderAttributesObj;
    private static ConnectReaderPresenter.OnActivityResult mConnectCallBack;
    private static CardReaderScanAndDiscoverOptions mScanReaderAttributesObj;
    private static ScanReadersPresenter.OnScanResult mScanCallBack;
    private static CardReaderScanAndDiscoverOptions mScanErrorAttributesObj;
    private static ScanReadersPresenter.OnScanResult mScanErrorCallBack;

    public static void setConnectJsInterfaces(DeviceConnectorOptions options, ConnectReaderPresenter.OnActivityResult callback) {
        mCardReaderAttributesObj = options;
        mConnectCallBack = callback;
    }

    public static void setScanJsInterfaces(CardReaderScanAndDiscoverOptions scanOptions, ScanReadersPresenter.OnScanResult callback) {
        mScanReaderAttributesObj = scanOptions;
        mScanCallBack = callback;
    }

    public static void setScanErrorJsInterfaces(CardReaderScanAndDiscoverOptions scanOptions, ScanReadersPresenter.OnScanResult callback) {
        mScanErrorAttributesObj = scanOptions;
        mScanErrorCallBack = callback;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.retail_sdk_activity_transparent);
        this.attachPresenter(this.getIntent());
    }

    protected void onStart() {
        super.onStart();
    }

    public void finish() {
        super.finish();
    }

    protected void onResume() {
        super.onResume();
    }

    public void attachPresenter(Intent presenterToOpen) {
        String action = presenterToOpen.getStringExtra("PRESENTER_TO_OPEN");
        if (this.isFinishing()) {
            return;
        }
        switch (action) {
            case "CONNECT_READER": {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_CONNECTION_ASK, null);
                ConnectReaderPresenter connectReaderPresenter = ConnectReaderPresenter.newInstance(mCardReaderAttributesObj, mConnectCallBack, null);
                ActivityUtils.addFragmentToActivity(this.getSupportFragmentManager(), connectReaderPresenter);
                break;
            }
            case "SCAN": {
                ScanReadersPresenter scanReadersPresenter = ScanReadersPresenter.newInstance(mScanReaderAttributesObj, mScanCallBack);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), scanReadersPresenter);
            }
        }
    }

    @Override
    public void replacePresenter(String action, Bundle params) {
        if (this.isFinishing()) {
            return;
        }
        switch (action) {
            case "CONNECT_READER": {
                if (params == null) break;
                ConnectReaderPresenter connectReaderPresenter = ConnectReaderPresenter.newInstance(mCardReaderAttributesObj, mConnectCallBack, params);
                ActivityUtils.addFragmentToActivity(this.getSupportFragmentManager(), connectReaderPresenter);
                break;
            }
            case "SCAN": {
                ScanReadersPresenter scanReadersPresenter = ScanReadersPresenter.newInstance(mScanReaderAttributesObj, mScanCallBack);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), scanReadersPresenter);
                break;
            }
            case "SCAN_CONNECT_ERROR": {
                ScanConnectErrorPresenter errorPresenter = ScanConnectErrorPresenter.newInstance(mScanErrorAttributesObj, mScanErrorCallBack, params);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), errorPresenter);
                break;
            }
            case "SCAN_RETRY_CONNECTION_AFTER_ERROR": {
                ConnectRetryReaderPresenter errorRetryPresenter = ConnectRetryReaderPresenter.newInstance(mScanErrorAttributesObj, mScanErrorCallBack, params);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), errorRetryPresenter);
                break;
            }
            case "SCAN_NO_DEVICE_FOUND": {
                ScanErrorPresenter scanErrorPresenter = ScanErrorPresenter.newInstance(mScanErrorAttributesObj, mScanErrorCallBack);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), scanErrorPresenter);
                break;
            }
            case "CONNECTION_ERROR": {
                ConnectErrorPresenter connectErrorPresenter = ConnectErrorPresenter.newInstance(mCardReaderAttributesObj, mConnectCallBack, params);
                ActivityUtils.replaceFragment(this.getSupportFragmentManager(), connectErrorPresenter);
            }
        }
    }

    @Override
    public Drawable getDrawableFromText(String imageName) {
        Resources res = this.getResources();
        int resourceId = res.getIdentifier(imageName, "drawable", this.getPackageName());
        return ResourcesCompat.getDrawable((Resources)res, (int)resourceId, null);
    }

    @Override
    public void cleanUp() {
        mCardReaderAttributesObj = null;
        mScanReaderAttributesObj = null;
        mConnectCallBack = null;
        mScanCallBack = null;
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cleanUp();
    }

    public void onBackPressed() {
    }

    static class ActivityUtils {
        ActivityUtils() {
        }

        public static void addFragmentToActivity(FragmentManager fragmentManager, Fragment fragment) {
            if (fragment != null) {
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.add(R.id.fragment_container, fragment);
                transaction.commitAllowingStateLoss();
            }
        }

        public static void replaceFragment(FragmentManager fragmentManager, Fragment fragment) {
            if (fragment != null) {
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.replace(R.id.fragment_container, fragment);
                transaction.commitAllowingStateLoss();
            }
        }
    }
}

