/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import java.util.HashMap;
import java.util.concurrent.Callable;

public abstract class RetailSDKBasePresenter {
    private static final String logComponent = "RetailSDKBasePresenter";
    protected V8Object mJsOptions;
    protected V8Function mJsCallback;
    protected V8Object mImpl;
    protected Intent mIntent;

    public final V8Object showActivity(HashMap<String, String> extraData, final V8Object options, final V8Function cb) {
        Log.d((String)logComponent, (String)"createActivityIntent");
        V8Object handle = (V8Object)PayPalRetailObject.getEngine().getExecutor().run((Callable)new Callable<V8Object>(){

            @Override
            public V8Object call() {
                RetailSDKBasePresenter.this.mJsOptions = options.twin();
                RetailSDKBasePresenter.this.mJsCallback = cb.twin();
                RetailSDKBasePresenter.this.mImpl = PayPalRetailObject.getEngine().createJsObject();
                RetailSDKBasePresenter.this.mImpl.registerJavaMethod((Object)RetailSDKBasePresenter.this, "dismiss", "dismiss", null);
                return RetailSDKBasePresenter.this.mImpl.twin();
            }
        });
        this.mIntent = this.createActivityIntent(options, extraData);
        this.getCurrentActivity().startActivity(this.mIntent);
        Log.d((String)logComponent, (String)("startActivity " + this.toString()));
        return handle;
    }

    public final void finishActivity() {
        Log.d((String)logComponent, (String)("finishActivity " + this.toString()));
        this.finishActivityImplementation();
    }

    public final void dismiss() {
        Log.d((String)logComponent, (String)("dismiss " + this.toString()));
        this.finishActivity();
        this.release();
    }

    protected final void release() {
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                if (RetailSDKBasePresenter.this.mJsCallback != null) {
                    RetailSDKBasePresenter.this.mJsCallback.release();
                    RetailSDKBasePresenter.this.mJsCallback = null;
                }
                if (RetailSDKBasePresenter.this.mImpl != null) {
                    RetailSDKBasePresenter.this.mImpl.release();
                    RetailSDKBasePresenter.this.mImpl = null;
                }
                if (RetailSDKBasePresenter.this.mJsOptions != null) {
                    RetailSDKBasePresenter.this.mJsOptions.release();
                    RetailSDKBasePresenter.this.mJsOptions = null;
                }
            }
        });
    }

    protected String getV8OptionsStringValue(final String propName) {
        return (String)PayPalRetailObject.getEngine().getExecutor().run((Callable)new Callable<String>(){

            @Override
            public String call() {
                String _value = null;
                if (RetailSDKBasePresenter.this.mJsOptions.getType(propName) == 4) {
                    _value = RetailSDKBasePresenter.this.mJsOptions.getString(propName);
                }
                return _value;
            }
        });
    }

    protected Activity getCurrentActivity() {
        return RetailSDK.getAppState().getCurrentActivity();
    }

    public void finishActivityImplementation() {
    }

    public abstract void handleBackPressed();

    protected abstract Intent createActivityIntent(V8Object var1, HashMap<String, String> var2);

    public abstract void onLayoutInitialized(RetailSDKBaseActivity var1);

    public void initComponents(Activity activity) {
    }

    public void onDestroy() {
    }

    public void onNewIntent() {
    }
}

