/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.connection;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.res.ResourcesCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.paypal.paypalretailsdk.DeviceConnectorOptions;
import com.paypal.paypalretailsdk.PaymentDevice;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderContract;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderView;

public class ConnectReaderPresenter
extends Fragment
implements ConnectReaderContract.Presenter {
    private Context mContext;
    private DeviceConnectionActivity mParentActivity;
    private ConnectReaderView mView;
    public static DeviceConnectorOptions mOptions;
    public static OnActivityResult mCallback;
    private DeviceConnectorOptions.OnConnectionResultObserver onConnectionResultObserver = new DeviceConnectorOptions.OnConnectionResultObserver(){

        @Override
        public void onConnectionResult(final RetailSDKException error, PaymentDevice device) {
            ConnectReaderPresenter.this.mParentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (null == error) {
                        ConnectReaderPresenter.this.mView.setupViewForSuccessfulConnection();
                    } else {
                        Bundle bundle = new Bundle();
                        bundle.putString("DEVICE_NAME", mOptions.getReaderId());
                        bundle.putString("DEVICE_DESCRIPTION", mOptions.getReaderDescription());
                        bundle.putString("DEV_IMAGE_ID", mOptions.getReaderImgId());
                        ConnectReaderPresenter.this.mParentActivity.replacePresenter("CONNECTION_ERROR", bundle);
                    }
                }
            });
        }
    };

    public static ConnectReaderPresenter newInstance(DeviceConnectorOptions options, OnActivityResult callback, Bundle params) {
        ConnectReaderPresenter connectReaderPresenter = new ConnectReaderPresenter();
        connectReaderPresenter.setArguments(params);
        mCallback = callback;
        mOptions = options;
        return connectReaderPresenter;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
        this.mContext = activity;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        this.mView = new ConnectReaderView((Context)this.mParentActivity, this);
        return this.mView;
    }

    private void decorateViewForAutoConnect() {
        this.decorateView();
        this.attemptConnectionToLastKnownDevice();
        this.mView.showProgress();
    }

    private void decorateViewAfterSuccessfulConnection() {
        this.mView.setCardReaderName(this.getArguments().getString("DEVICE_DESCRIPTION"));
        this.mView.setCardReaderId(this.getArguments().getString("DEVICE_NAME"));
        this.mView.setCardReaderImage(this.getDrawableFromName(this.getArguments().getString("DEV_IMAGE_ID")));
        this.mView.setupViewForSuccessfulConnection();
    }

    public void onResume() {
        super.onResume();
        if (mOptions == null) {
            this.dismissActivity(ConnectReaderContract.Presenter.DismissMode.cancel);
            return;
        }
        if (this.getArguments() != null) {
            if (this.getArguments().getBoolean("CONNECTED")) {
                this.decorateViewAfterSuccessfulConnection();
            } else if ("ACTION_CONNECT".equals(this.getArguments().getString("CONNECTION_ACTION"))) {
                this.decorateViewForAutoConnect();
            }
        } else {
            this.decorateView();
        }
    }

    public void onStart() {
        super.onStart();
    }

    private Drawable getDrawableFromName(String name) {
        Resources res = this.getResources();
        int resourceId = res.getIdentifier(name, "drawable", this.mContext.getPackageName());
        return ResourcesCompat.getDrawable((Resources)res, (int)resourceId, null);
    }

    private void decorateView() {
        this.mView.setCardReaderImage(this.getDrawableFromName(mOptions.getReaderImgId()));
        this.mView.setCardReaderId(mOptions.getReaderId());
        this.mView.setCardReaderName(mOptions.getReaderDescription());
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        if (mOptions != null) {
            mOptions.removeOnConnectionResultObserver(this.onConnectionResultObserver);
        }
        super.onDestroy();
    }

    @Override
    public void attemptConnectionToLastKnownDevice() {
        mOptions.addOnConnectionResultObserver(this.onConnectionResultObserver);
        mOptions.connectToLastReader();
    }

    @Override
    public void dismissActivity(ConnectReaderContract.Presenter.DismissMode action) {
        if (mCallback != null) {
            mCallback.doAction(action.toString());
        }
        this.mParentActivity.finish();
    }

    @Override
    public void goToScannerView() {
        this.mParentActivity.replacePresenter("SCAN", null);
    }

    public static interface OnActivityResult {
        public void doAction(String var1);
    }
}

