/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.connection;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderContract;

public class ConnectReaderView
extends FrameLayout
implements ConnectReaderContract.View {
    private Context mContext;
    private ConnectReaderContract.Presenter mPresenter;
    private FrameLayout mContainerFrameLayout;
    private TextView mtitleView;
    private TextView mCardReaderId;
    private TextView mCardReaderName;
    private ImageView mCancelDialogImage;
    private ImageView mCardReaderImage;
    private Button mPrimaryButton;
    private Button mSecondaryButton;
    private LinearLayout mInteractionContainerLayout;
    private LinearLayout mButtonsContainer;
    private LinearLayout mProgressWithDialog;

    public ConnectReaderView(Context context, ConnectReaderContract.Presenter presenter) {
        super(context);
        this.mContext = context;
        this.setPresenter(presenter);
        this.initLayout();
    }

    @Override
    public void setPresenter(ConnectReaderContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerFrameLayout = (FrameLayout)layoutInflater.inflate(R.layout.layout_dialog_connect_reader, null);
        this.mtitleView = (TextView)this.mContainerFrameLayout.findViewById(R.id.dialog_title);
        this.mCardReaderId = (TextView)this.mContainerFrameLayout.findViewById(R.id.device_id);
        this.mCardReaderName = (TextView)this.mContainerFrameLayout.findViewById(R.id.device_name);
        this.mCardReaderImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.image_reader);
        this.mCancelDialogImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.image_x);
        this.mInteractionContainerLayout = (LinearLayout)this.mContainerFrameLayout.findViewById(R.id.container_interaction);
        this.initButtons(layoutInflater);
        this.initProgressView(layoutInflater);
        this.addView((View)this.mContainerFrameLayout);
        this.setupViewForConnectionAttempt();
    }

    private void initButtons(LayoutInflater layoutInflater) {
        this.mButtonsContainer = (LinearLayout)layoutInflater.inflate(R.layout.layout_buttons_primary_n_tertiary, null);
        this.mPrimaryButton = (Button)this.mButtonsContainer.findViewById(R.id.button_primary);
        this.mSecondaryButton = (Button)this.mButtonsContainer.findViewById(R.id.button_secondary);
        this.mInteractionContainerLayout.addView((View)this.mButtonsContainer);
        this.mCancelDialogImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_ASK_CLOSED, null);
                ConnectReaderView.this.mPresenter.dismissActivity(ConnectReaderContract.Presenter.DismissMode.cancel);
            }
        });
    }

    private void initProgressView(LayoutInflater layoutInflater) {
        this.mProgressWithDialog = (LinearLayout)layoutInflater.inflate(R.layout.layout_progress_with_label, null);
        this.mProgressWithDialog.setVisibility(8);
        this.mInteractionContainerLayout.addView((View)this.mProgressWithDialog);
    }

    @Override
    public void setupViewForConnectionAttempt() {
        this.mPrimaryButton.setText(R.string.sdk_label_button_connect_to_reader);
        this.mPrimaryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_ASK_CONNECT_CLICKED, null);
                ConnectReaderView.this.mPresenter.attemptConnectionToLastKnownDevice();
                ConnectReaderView.this.showProgress();
            }
        });
        this.mSecondaryButton.setText(R.string.sdk_label_button_find_another_reader);
        this.mSecondaryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_ASK_FIND_ANOTHER_CLICKED, null);
                ConnectReaderView.this.mPresenter.dismissActivity(ConnectReaderContract.Presenter.DismissMode.scan);
            }
        });
        this.showButtons();
    }

    @Override
    public void setupViewForSuccessfulConnection() {
        this.mPresenter.dismissActivity(ConnectReaderContract.Presenter.DismissMode.done);
    }

    @Override
    public void setupViewForFailedConnection() {
        this.mPrimaryButton.setText(R.string.sdk_try_again);
        this.mPrimaryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectReaderView.this.mPresenter.attemptConnectionToLastKnownDevice();
                ConnectReaderView.this.showProgress();
            }
        });
        this.mSecondaryButton.setText(R.string.sdk_cancel);
        this.mSecondaryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectReaderView.this.mPresenter.dismissActivity(ConnectReaderContract.Presenter.DismissMode.cancel);
            }
        });
        this.showButtons();
    }

    @Override
    public void setCardReaderImage(Drawable image) {
        this.mCardReaderImage.setImageDrawable(image);
    }

    @Override
    public void setCardReaderName(String cardReaderName) {
        this.mCardReaderName.setText((CharSequence)cardReaderName);
    }

    @Override
    public void setCardReaderId(String cardReaderId) {
        this.mCardReaderId.setText((CharSequence)cardReaderId);
    }

    @Override
    public void showProgress() {
        this.mButtonsContainer.setVisibility(8);
        this.mProgressWithDialog.setVisibility(0);
    }

    @Override
    public void showButtons() {
        this.mProgressWithDialog.setVisibility(8);
        this.mButtonsContainer.setVisibility(0);
    }
}

