/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.connection.retryAfterScan;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.DiscoveredCardReader;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.connection.retryAfterScan.ConnectRetryReaderContract;
import com.paypal.paypalretailsdk.ui.connection.retryAfterScan.ConnectRetryReaderView;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;

public class ConnectRetryReaderPresenter
extends Fragment
implements ConnectRetryReaderContract.Presenter {
    private DeviceConnectionActivity mParentActivity;
    private ConnectRetryReaderView mView;
    public static CardReaderScanAndDiscoverOptions mOptions;
    public static ScanReadersPresenter.OnScanResult mCallback;
    private CardReaderScanAndDiscoverOptions.OnConnectionStatusObserver onConnectionStatusObserver = new CardReaderScanAndDiscoverOptions.OnConnectionStatusObserver(){

        @Override
        public void onConnectionStatus(final RetailSDKException error, DiscoveredCardReader device) {
            ConnectRetryReaderPresenter.this.mParentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (error == null) {
                        ConnectRetryReaderPresenter.this.dismissActivity(ConnectRetryReaderContract.Presenter.DismissMode.done);
                    } else {
                        Bundle bundle = new Bundle();
                        bundle.putString("DEVICE_NAME", ConnectRetryReaderPresenter.this.getArguments().getString("DEVICE_NAME"));
                        bundle.putString("DEVICE_DESCRIPTION", ConnectRetryReaderPresenter.this.getArguments().getString("DEVICE_DESCRIPTION"));
                        bundle.putString("DEV_IMAGE_ID", ConnectRetryReaderPresenter.this.getArguments().getString("DEV_IMAGE_ID"));
                        DeviceConnectionActivity.setScanErrorJsInterfaces(mOptions, mCallback);
                        ConnectRetryReaderPresenter.this.mParentActivity.replacePresenter("SCAN_CONNECT_ERROR", bundle);
                    }
                }
            });
        }
    };

    public static ConnectRetryReaderPresenter newInstance(CardReaderScanAndDiscoverOptions options, ScanReadersPresenter.OnScanResult callback, Bundle params) {
        ConnectRetryReaderPresenter connectReaderPresenter = new ConnectRetryReaderPresenter();
        connectReaderPresenter.setArguments(params);
        mCallback = callback;
        mOptions = options;
        return connectReaderPresenter;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        this.mView = new ConnectRetryReaderView((Context)this.mParentActivity, this);
        this.decorateView();
        String readerId = this.getArguments().getString("DEVICE_NAME");
        mOptions.connectToCardReader(readerId);
        return this.mView;
    }

    private void decorateView() {
        this.mView.setCardReaderId(this.getArguments().getString("DEVICE_NAME"));
        this.mView.setCardReaderImage(this.mParentActivity.getDrawableFromText(this.getArguments().getString("DEV_IMAGE_ID")));
        this.mView.setCardReaderName(this.getArguments().getString("DEVICE_DESCRIPTION"));
    }

    public void onResume() {
        super.onResume();
    }

    public void onStart() {
        super.onStart();
        mOptions.addOnConnectionStatusObserver(this.onConnectionStatusObserver);
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        mOptions.removeOnConnectionStatusObserver(this.onConnectionStatusObserver);
    }

    @Override
    public void dismissActivity(ConnectRetryReaderContract.Presenter.DismissMode action) {
        if (mCallback != null) {
            mCallback.doAction(action.toString());
        }
        this.mParentActivity.finish();
    }
}

