/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.connection.retryAfterScan;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.connection.retryAfterScan.ConnectRetryReaderContract;

public class ConnectRetryReaderView
extends FrameLayout
implements ConnectRetryReaderContract.View {
    private Context mContext;
    private ConnectRetryReaderContract.Presenter mPresenter;
    private FrameLayout mContainerFrameLayout;
    private TextView mTitleView;
    private TextView mCardReaderId;
    private TextView mCardReaderName;
    private ImageView mCardReaderImage;
    private ImageView mCancelDialogImage;
    private LinearLayout mInteractionContainerLayout;
    private LinearLayout mProgressWithDialog;

    public ConnectRetryReaderView(Context context, ConnectRetryReaderContract.Presenter presenter) {
        super(context);
        this.mContext = context;
        this.setPresenter(presenter);
        this.initLayout();
    }

    @Override
    public void setPresenter(ConnectRetryReaderContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerFrameLayout = (FrameLayout)layoutInflater.inflate(R.layout.layout_dialog_connect_reader, null);
        this.mTitleView = (TextView)this.mContainerFrameLayout.findViewById(R.id.dialog_title);
        this.mCardReaderId = (TextView)this.mContainerFrameLayout.findViewById(R.id.device_id);
        this.mCardReaderName = (TextView)this.mContainerFrameLayout.findViewById(R.id.device_name);
        this.mCardReaderImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.image_reader);
        this.mCancelDialogImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.image_x);
        this.mInteractionContainerLayout = (LinearLayout)this.mContainerFrameLayout.findViewById(R.id.container_interaction);
        this.mTitleView.setVisibility(8);
        this.initProgressView(layoutInflater);
        this.initButtons();
        this.addView((View)this.mContainerFrameLayout);
    }

    private void initButtons() {
        this.mCancelDialogImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectRetryReaderView.this.mPresenter.dismissActivity(ConnectRetryReaderContract.Presenter.DismissMode.cancel);
            }
        });
    }

    private void initProgressView(LayoutInflater layoutInflater) {
        this.mProgressWithDialog = (LinearLayout)layoutInflater.inflate(R.layout.layout_progress_with_label, null);
        this.mInteractionContainerLayout.addView((View)this.mProgressWithDialog);
    }

    @Override
    public void setCardReaderImage(Drawable image) {
        this.mCardReaderImage.setImageDrawable(image);
    }

    @Override
    public void setCardReaderName(String cardReaderName) {
        this.mCardReaderName.setText((CharSequence)cardReaderName);
    }

    @Override
    public void setCardReaderId(String cardReaderId) {
        this.mCardReaderId.setText((CharSequence)cardReaderId);
    }
}

