/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.content.res.ResourcesCompat;
import android.view.ContextThemeWrapper;
import android.view.View;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.dialogs.RetailAlertBuilder;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogBuilderDynamicallyWithImgs;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogBuilderWithMultipleOptions;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogBuilderWithNoButtonsAndProgressBar;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogBuilderWithTwoButtons;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogCommand;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogPresenter;

public class SDKDialogActivity
extends RetailSDKBaseActivity {
    private static final String LOG_TAG = "SDKDialog.Activity";
    private SDKDialogPresenter _presenter;
    private AlertDialog _dialog;

    @Override
    protected RetailSDKBasePresenter getPresenter() {
        return this._presenter;
    }

    @Override
    public void initComponents(Bundle savedInstanceState) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "INIT_COMPONENTS - " + ((Object)((Object)this)).hashCode());
        this._presenter = SDKDialogPresenter.getInstance();
        this._presenter.initComponents(this);
    }

    public void onNewIntent(Intent intent) {
        this._presenter.initComponents(this);
    }

    protected void onStop() {
        super.onStop();
        RetailSDK.log(logLevel.debug, LOG_TAG, "ON_STOP - " + ((Object)((Object)this)).hashCode());
    }

    protected void onStart() {
        super.onStart();
        RetailSDK.log(logLevel.debug, LOG_TAG, "ON_START - " + ((Object)((Object)this)).hashCode());
    }

    protected void onDestroy() {
        if (this.isShowing()) {
            this._dialog.cancel();
        }
        super.onDestroy();
        RetailSDK.log(logLevel.debug, LOG_TAG, "ON_DESTROY - " + ((Object)((Object)this)).hashCode());
        this._presenter.onDestroy();
    }

    public void onBackPressed() {
        this.getPresenter().handleBackPressed();
    }

    public void updateView(final SDKDialogCommand command) {
        RetailAlertBuilder builder;
        if (!command.getCommandType().equals((Object)SDKDialogCommand.CommandType.SHOW)) {
            return;
        }
        ContextThemeWrapper wrapper = new ContextThemeWrapper((Context)this, R.style.SDKTheme_AlertDialog);
        if (command.showProgressSpinner()) {
            Drawable img;
            SDKDialogBuilderWithNoButtonsAndProgressBar progressBarBuilder = new SDKDialogBuilderWithNoButtonsAndProgressBar((Context)wrapper);
            progressBarBuilder.setView((Context)this);
            if (StringUtil.isNotEmpty(command.getTitle())) {
                progressBarBuilder.setTitle(command.getTitle());
            }
            if (StringUtil.isNotEmpty(command.getMessage())) {
                progressBarBuilder.setMessage(command.getMessage());
            }
            if ((img = this.getDrawableFromId(command.getImg())) == null) {
                progressBarBuilder.hideImage();
            } else {
                progressBarBuilder.setmImageView(img);
            }
            progressBarBuilder.setProgressBarVisibility(true);
            progressBarBuilder.setCancelable(command.isCancellable());
            builder = progressBarBuilder;
        } else if (command.getButtons().size() > 1) {
            SDKDialogBuilderWithMultipleOptions multiButtonBuilder = new SDKDialogBuilderWithMultipleOptions((Context)wrapper);
            multiButtonBuilder.setView((Context)this);
            if (StringUtil.isNotEmpty(command.getTitle())) {
                multiButtonBuilder.setTitle(command.getTitle());
            } else {
                multiButtonBuilder.hideTitle();
            }
            if (StringUtil.isNotEmpty(command.getMessage())) {
                multiButtonBuilder.setMessage(command.getMessage());
            } else {
                multiButtonBuilder.hideMessage();
            }
            Drawable img = this.getDrawableFromId(command.getImg());
            if (img == null) {
                multiButtonBuilder.hideImage();
            } else {
                multiButtonBuilder.setmImageView(img);
            }
            multiButtonBuilder.setCancelable(command.isCancellable());
            multiButtonBuilder.setOptions((Context)wrapper, command.getButtons(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    command.onClick(i);
                }
            });
            builder = multiButtonBuilder;
        } else if (command.getButtonImgs().size() > 0) {
            SDKDialogBuilderDynamicallyWithImgs dynamicImageButtonBuilder = new SDKDialogBuilderDynamicallyWithImgs((Context)wrapper);
            dynamicImageButtonBuilder.setView((Context)this);
            if (StringUtil.isNotEmpty(command.getMessage())) {
                dynamicImageButtonBuilder.setMessage(command.getMessage());
            }
            int i = 0;
            while (i < command.getButtonImgs().size()) {
                SDKDialogCommand.ImageButton imgButton = command.getButtonImgs().get(i);
                String id2 = imgButton.getId();
                Drawable img = this.getDrawableFromId(imgButton.getImageIcon());
                if (img == null) {
                    throw new RuntimeException("Unable to locate Drawable for " + imgButton.getImageIcon());
                }
                final int index = i++;
                dynamicImageButtonBuilder.addImgButton((Context)wrapper, img, id2, new View.OnClickListener(){

                    public void onClick(View v) {
                        command.onClick(index);
                    }
                });
            }
            dynamicImageButtonBuilder.setCancelable(command.isCancellable());
            builder = dynamicImageButtonBuilder;
        } else {
            String cancelButton;
            SDKDialogBuilderWithTwoButtons oneButtonBuilder = new SDKDialogBuilderWithTwoButtons((Context)wrapper);
            oneButtonBuilder.setView((Context)this);
            if (StringUtil.isNotEmpty(command.getTitle())) {
                oneButtonBuilder.setTitle(command.getTitle());
            } else {
                oneButtonBuilder.hideTitle();
            }
            if (StringUtil.isNotEmpty(command.getMessage())) {
                oneButtonBuilder.setMessage(command.getMessage());
            } else {
                oneButtonBuilder.hideMessage();
            }
            oneButtonBuilder.hidePositiveButton();
            String string2 = cancelButton = command.getButtons().size() > 0 ? command.getButtons().get(0) : null;
            if (StringUtil.isNotEmpty(cancelButton)) {
                oneButtonBuilder.setNegativeButtonClickListener(cancelButton, new View.OnClickListener(){

                    public void onClick(View v) {
                        command.onClick(0);
                    }
                });
            } else {
                oneButtonBuilder.hideNegativeButton();
            }
            Drawable img = this.getDrawableFromId(command.getImg());
            if (img == null) {
                oneButtonBuilder.hideImage();
            } else {
                oneButtonBuilder.setmImageView(img);
            }
            oneButtonBuilder.setCancelable(command.isCancellable());
            builder = oneButtonBuilder;
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (SDKDialogActivity.this.isShowing()) {
                    RetailSDK.log(logLevel.debug, SDKDialogActivity.LOG_TAG, "Update existing content view to (" + command.getTitle() + ":" + command.getMessage() + ")");
                    SDKDialogActivity.this._dialog.setContentView(builder.getView());
                } else {
                    RetailSDK.log(logLevel.debug, SDKDialogActivity.LOG_TAG, "CREATE NEW dialog for (" + command.getTitle() + ":" + command.getMessage() + ")");
                    SDKDialogActivity.this._dialog = builder.create();
                    SDKDialogActivity.this._dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialogInterface) {
                            RetailSDK.log(logLevel.debug, SDKDialogActivity.LOG_TAG, "CLOSED for (" + command.getTitle() + ":" + command.getMessage() + ")... Finishing activity");
                            SDKDialogActivity.this.finish();
                        }
                    });
                    if (SDKDialogActivity.this._dialog.getWindow() != null) {
                        ((SDKDialogActivity)SDKDialogActivity.this)._dialog.getWindow().getAttributes().windowAnimations = R.style.SdkDialogAnimation;
                        SDKDialogActivity.this._dialog.show();
                    }
                }
                SDKDialogActivity.this.playAudio(command.getAudio());
            }
        });
    }

    private void playAudio(SDKDialogCommand.Audio audio) {
        if (audio == null || StringUtil.isEmpty(audio.getFile())) {
            return;
        }
        if (audio.getFile().equalsIgnoreCase("beep")) {
            RetailSDK.getAudio().playAudibleBeep(audio.getPlayCount());
        } else if (audio.getFile().equalsIgnoreCase("success_card_read.mp3")) {
            RetailSDK.getAudio().playSound(R.raw.success_card_read);
        }
    }

    private Drawable getDrawableFromId(String imageId) {
        if (imageId == null) {
            return null;
        }
        int imgId = this.getResources().getIdentifier(imageId, "drawable", this.getPackageName());
        if (imgId > 0) {
            return ResourcesCompat.getDrawable((Resources)this.getResources(), (int)imgId, null);
        }
        return null;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        RetailSDK.log(logLevel.debug, LOG_TAG, "ON_CREATE");
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.retail_sdk_activity_transparent);
    }

    protected void onResume() {
        super.onResume();
    }

    public synchronized void dismissDialog() {
        RetailSDK.log(logLevel.debug, LOG_TAG, "Try process DISMISS command");
        if (this.isShowing()) {
            this._dialog.dismiss();
            RetailSDK.log(logLevel.debug, LOG_TAG, "Dismissed dialog");
        } else {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Ignored dismiss command as dialog not showing");
        }
        try {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Completing activity... - " + ((Object)((Object)this)).hashCode());
            this.finish();
        }
        catch (Exception ex) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Exception on finish() " + ex.toString());
        }
    }

    public boolean isShowing() {
        return this._dialog != null && this._dialog.isShowing();
    }
}

