/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.dialogs.RetailAlertBuilder;
import java.util.List;

public class SDKDialogBuilderWithMultipleOptions
extends RetailAlertBuilder {
    TextView mTitleView;
    TextView mMessageView;
    LinearLayout mOptionView;
    ImageView mImageView;

    public SDKDialogBuilderWithMultipleOptions(Context context) {
        super((Context)new ContextThemeWrapper(context, R.style.DialogStyle));
        this.setCancelable(false);
    }

    public void setView(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.retail_sdk_alert_dialog_with_options, null);
        this.mTitleView = (TextView)this.view.findViewById(R.id.title);
        this.mMessageView = (TextView)this.view.findViewById(R.id.message);
        this.mOptionView = (LinearLayout)this.view.findViewById(R.id.optionList);
        this.mOptionView.removeAllViews();
        this.mImageView = (ImageView)this.view.findViewById(R.id.image);
        this.setView(this.view);
    }

    private int getPixelsForDp(Context context, int dp) {
        Resources r = context.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public SDKDialogBuilderWithMultipleOptions setOptions(Context context, List<String> list, final DialogInterface.OnClickListener listener) {
        this.mOptionView.removeAllViews();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, 0, this.getPixelsForDp(context, 6));
        params.gravity = 17;
        int i = 0;
        while (i < list.size()) {
            String optionTxt = list.get(i);
            Button optionBtn = new Button((Context)new ContextThemeWrapper(context, R.style.SDKButton_ActionItem_Primary_Blue), null, R.style.SDKButton_ActionItem_Primary_Blue);
            optionBtn.setLayoutParams((ViewGroup.LayoutParams)params);
            optionBtn.setText((CharSequence)optionTxt);
            optionBtn.setTextSize(2, 24.0f);
            optionBtn.setPadding(this.getPixelsForDp(context, 16), this.getPixelsForDp(context, 10), this.getPixelsForDp(context, 16), this.getPixelsForDp(context, 10));
            final int optionIndex = i++;
            optionBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onClick(null, optionIndex);
                }
            });
            this.mOptionView.addView((View)optionBtn);
        }
        return this;
    }

    public AlertDialog.Builder setTitle(CharSequence title) {
        this.mTitleView.setText(title);
        return this;
    }

    public AlertDialog.Builder setMessage(CharSequence message) {
        this.mMessageView.setText(message);
        return this;
    }

    public void hideTitle() {
        this.mTitleView.setVisibility(8);
    }

    public void hideMessage() {
        this.mMessageView.setVisibility(8);
    }

    public void hideImage() {
        this.mImageView.setVisibility(8);
    }

    public void setmImageView(Drawable image) {
        this.mImageView.setBackgroundDrawable(image);
    }
}

