/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.dialogs.RetailAlertBuilder;

public class SDKDialogBuilderWithNoButtonsAndProgressBar
extends RetailAlertBuilder {
    TextView mTitleView;
    TextView mMessageView;
    ProgressBar mProgressBar;
    int mTitleFontSizeId = -1;
    int mMessageFontSizeId = -1;
    ImageView mImageView;

    public SDKDialogBuilderWithNoButtonsAndProgressBar(Context context) {
        super(context);
    }

    public SDKDialogBuilderWithNoButtonsAndProgressBar(Context context, int titleFontSizeResId, int messageFontSizeResId) {
        super(context);
        this.mTitleFontSizeId = titleFontSizeResId;
        this.mMessageFontSizeId = messageFontSizeResId;
    }

    public void setView(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.retail_sdk_alert_dialog_with_no_buttons, null);
        this.mTitleView = (TextView)this.view.findViewById(R.id.title);
        this.mMessageView = (TextView)this.view.findViewById(R.id.message);
        this.mProgressBar = (ProgressBar)this.view.findViewById(R.id.progress_bar);
        this.mImageView = (ImageView)this.view.findViewById(R.id.image);
        this.updateFontSize(context);
        this.setView(this.view);
    }

    public AlertDialog.Builder setTitle(CharSequence title) {
        if (null != title) {
            this.mTitleView.setText(title);
            this.mTitleView.setVisibility(0);
        } else {
            this.mTitleView.setVisibility(8);
        }
        return this;
    }

    public AlertDialog.Builder setMessage(CharSequence message) {
        if (null != message) {
            this.mMessageView.setText(message);
            this.mMessageView.setVisibility(0);
        } else {
            this.mMessageView.setVisibility(8);
        }
        return this;
    }

    public void setProgressBarVisibility(boolean visible) {
        if (visible) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
    }

    private void updateFontSize(Context context) {
        Resources resources = context.getResources();
        if (this.mTitleFontSizeId > 0) {
            this.mTitleView.setTextSize(0, (float)resources.getDimensionPixelSize(this.mTitleFontSizeId));
        }
        if (this.mMessageFontSizeId > 0) {
            this.mMessageView.setTextSize(0, (float)resources.getDimensionPixelSize(this.mMessageFontSizeId));
        }
    }

    public void hideImage() {
        this.mImageView.setVisibility(8);
    }

    public void setmImageView(Drawable image) {
        this.mImageView.setBackgroundDrawable(image);
    }
}

