/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.dialogs.RetailAlertBuilder;

public class SDKDialogBuilderWithTwoButtons
extends RetailAlertBuilder {
    TextView mTitleView;
    TextView mMessageView;
    Button mPositiveButton;
    Button mNegativeButton;
    ImageView mImageView;

    public SDKDialogBuilderWithTwoButtons(Context context) {
        super((Context)new ContextThemeWrapper(context, R.style.DialogStyle));
        this.setCancelable(false);
    }

    public void setView(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.retail_sdk_alert_dialog_with_2_buttons, null);
        this.mTitleView = (TextView)this.view.findViewById(R.id.title);
        this.mMessageView = (TextView)this.view.findViewById(R.id.message);
        this.mPositiveButton = (Button)this.view.findViewById(R.id.positiveBtn);
        this.mNegativeButton = (Button)this.view.findViewById(R.id.negativeBtn);
        this.mImageView = (ImageView)this.view.findViewById(R.id.image);
        this.setView(this.view);
    }

    public AlertDialog.Builder setTitle(CharSequence title) {
        this.mTitleView.setText(title);
        return this;
    }

    public AlertDialog.Builder setMessage(CharSequence message) {
        this.mMessageView.setText(message);
        return this;
    }

    public void setPositiveButtonClickListener(String text, View.OnClickListener listener) {
        if (null != text) {
            this.mPositiveButton.setText((CharSequence)text);
        }
        this.mPositiveButton.setOnClickListener(listener);
    }

    public void setNegativeButtonClickListener(String text, View.OnClickListener listener) {
        if (null != text) {
            this.mNegativeButton.setText((CharSequence)text);
        }
        this.mNegativeButton.setOnClickListener(listener);
    }

    public void hidePositiveButton() {
        this.mPositiveButton.setVisibility(8);
    }

    public void hideNegativeButton() {
        this.mNegativeButton.setVisibility(8);
    }

    public void hideTitle() {
        this.mTitleView.setVisibility(8);
    }

    public void hideMessage() {
        this.mMessageView.setVisibility(8);
    }

    public void hideImage() {
        this.mImageView.setVisibility(8);
    }

    public void setmImageView(Drawable image) {
        this.mImageView.setBackgroundDrawable(image);
    }
}

