/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogProxy;
import java.util.ArrayList;
import java.util.List;

public class SDKDialogCommand {
    private int _id;
    private String _title;
    private String _message;
    private String _img;
    private CommandType _commandType;
    private SDKDialogProxy _dialogProxy;
    private List<ImageButton> _imageButtons = new ArrayList<ImageButton>();
    private List<String> _buttons = new ArrayList<String>();
    private int _optionsButtonCount;
    private boolean _showActivity = false;
    private boolean _isCancellable = false;
    private V8Function _jsCallback;
    private static final int MAX_INT_ID = 1000000;
    private Audio _audio;

    private SDKDialogCommand(CommandType type, SDKDialogProxy dialogProxy) {
        this._commandType = type;
        this._dialogProxy = dialogProxy;
        this._id = this.getNewId();
    }

    public SDKDialogCommand(SDKDialogProxy dialogProxy, CommandType type, V8Object options, V8Function callback) {
        this(type, dialogProxy);
        String cancel;
        this._title = options.getType("title") == 4 ? options.getString("title") : null;
        String string2 = this._message = options.getType("message") == 4 ? options.getString("message") : null;
        if (StringUtil.isEmpty(this._title) && StringUtil.isEmpty(this._message)) {
            throw new RuntimeException("Title or message are required");
        }
        this._jsCallback = callback.twin();
        String string3 = this._img = options.getType("imageIcon") == 4 ? options.getString("imageIcon") : null;
        if (!options.getObject("audio").equals((Object)V8.getUndefined())) {
            V8Object audio = options.getObject("audio");
            String audioFile = audio.getType("file") == 4 ? audio.getString("file") : null;
            int audioLoopCount = audio.getType("playCount") == 1 ? audio.getInteger("playCount") : 1;
            this._audio = new Audio(audioFile, audioLoopCount);
        }
        V8Array buttons = PayPalRetailObject.getEngine().getEmptyArray();
        if (options.getType("buttons") == 5) {
            buttons = options.getArray("buttons");
        }
        this._optionsButtonCount = buttons.length();
        if (this._optionsButtonCount > 0) {
            for (int i = 0; i < buttons.length(); ++i) {
                String curBtn = buttons.getString(i);
                this._buttons.add(curBtn);
            }
        }
        V8Array imageButtonIcons = PayPalRetailObject.getEngine().getEmptyArray();
        if (options.getType("buttonsImages") == 5) {
            imageButtonIcons = options.getArray("buttonsImages");
        }
        V8Array imageButtonIds = PayPalRetailObject.getEngine().getEmptyArray();
        if (options.getType("buttonsIds") == 5) {
            imageButtonIds = options.getArray("buttonsIds");
        }
        if (imageButtonIcons.length() != imageButtonIds.length()) {
            throw new RuntimeException("Button Imgs length " + imageButtonIcons.length() + " does not match with buttons Ids lenght: " + imageButtonIds.length());
        }
        for (int i = 0; i < imageButtonIcons.length(); ++i) {
            String imageIcon = imageButtonIcons.getString(i);
            String imageId = imageButtonIds.getString(i);
            this._imageButtons.add(new ImageButton(imageId, imageIcon));
        }
        if (options.getType("cancel") == 4 && !StringUtil.isEmpty(cancel = options.getString("cancel"))) {
            this._buttons.add(cancel);
        }
        this._showActivity = options.getType("showActivity") == 3 && options.getBoolean("showActivity");
        this._isCancellable = options.getType("setCancellable") == 3 && options.getBoolean("setCancellable");
    }

    static SDKDialogCommand getDismissCommand(SDKDialogProxy dialogProxy) {
        return new SDKDialogCommand(CommandType.DISMISS, dialogProxy);
    }

    public String toString() {
        return "Id: " + this._id + "\nCommandType: " + (Object)((Object)this._commandType) + "\nTitle: '" + this._title + "'\nImage: " + this._img + "\nMessage: " + this._message + "\nButton Ids: " + StringUtil.join(this._buttons, ',') + "\nImage Buttons: " + StringUtil.join(this._imageButtons, ',') + "\nOptions Button Count: " + this._optionsButtonCount + "\nShowActivity: " + this._showActivity + "\nIsCancellable: " + this._isCancellable + "\nAudio: " + this._audio;
    }

    private int getNewId() {
        if (this._id > 1000000) {
            this._id = 0;
        }
        return ++this._id;
    }

    public CommandType getCommandType() {
        return this._commandType;
    }

    public String getTitle() {
        return this._title;
    }

    public String getMessage() {
        return this._message;
    }

    public String getImg() {
        return this._img;
    }

    public List<ImageButton> getButtonImgs() {
        return this._imageButtons;
    }

    public List<String> getButtons() {
        return this._buttons;
    }

    public boolean showProgressSpinner() {
        return this._showActivity;
    }

    public boolean isCancellable() {
        return this._isCancellable;
    }

    public Audio getAudio() {
        return this._audio;
    }

    public void onClick(final int index) {
        if (this._jsCallback == null || this._dialogProxy == null) {
            return;
        }
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                SDKDialogCommand.this._jsCallback.call(SDKDialogCommand.this._dialogProxy.getJsObject(), RetailSDK.jsArgs().push((V8Value)SDKDialogCommand.this._dialogProxy.getJsObject()).push(index));
                SDKDialogCommand.this.release();
            }
        });
    }

    public void release() {
        if (this._jsCallback != null) {
            this._jsCallback.release();
            this._jsCallback = null;
        }
    }

    public class ImageButton {
        private String _id;
        private String _imageIcon;

        public ImageButton(String id2, String icon) {
            this._id = id2;
            this._imageIcon = icon;
        }

        public String getId() {
            return this._id;
        }

        public String getImageIcon() {
            return this._imageIcon;
        }

        public String toString() {
            return "<" + this._imageIcon + ":" + this._id + ">";
        }
    }

    public class Audio {
        private String _file;
        private int _playCount;

        public Audio(String file, int playCount) {
            this._file = file;
            this._playCount = playCount;
        }

        public String getFile() {
            return this._file;
        }

        public int getPlayCount() {
            return this._playCount;
        }

        public String toString() {
            return "<" + this._file + ":" + this._playCount + ">";
        }
    }

    static enum CommandType {
        SHOW,
        DISMISS,
        SET_TITLE,
        SET_MESSAGE;

    }
}

