/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.dialogs;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.eclipsesource.v8.V8Object;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogActivity;
import com.paypal.paypalretailsdk.ui.dialogs.SDKDialogCommand;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;

public class SDKDialogPresenter
extends RetailSDKBasePresenter {
    private static final String LOG_TAG = "SDKDialog.Presenter";
    private static SDKDialogPresenter _sdkDialogPresenter;
    private SDKDialogActivity _activity;
    private Activity _appActivity = null;
    private boolean _isStarting = false;
    private static Deque<SDKDialogCommand> _commandStack;

    private SDKDialogPresenter() {
    }

    public static synchronized SDKDialogPresenter getInstance() {
        if (_sdkDialogPresenter == null) {
            _sdkDialogPresenter = new SDKDialogPresenter();
        }
        return _sdkDialogPresenter;
    }

    private synchronized SDKDialogCommand getLatestCommand() {
        try {
            if (_commandStack.size() > 0) {
                SDKDialogCommand command = _commandStack.pop();
                _commandStack.clear();
                return command;
            }
        }
        catch (Exception ex) {
            Log.w((String)LOG_TAG, (String)("Unable to dequeue commands " + ex.toString()));
        }
        return null;
    }

    @Override
    public synchronized void initComponents(Activity activity) {
        this._activity = (SDKDialogActivity)activity;
        this._isStarting = false;
        SDKDialogCommand command = this.getLatestCommand();
        if (command != null) {
            if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.DISMISS)) {
                this._activity.dismissDialog();
            } else if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.SHOW)) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "initComponents> Updating view on an active dialog on app activity - " + this._appActivity.toString());
                this._activity.updateView(command);
            }
        }
    }

    @Override
    public synchronized void onDestroy() {
        this._activity = null;
        this._isStarting = false;
        SDKDialogCommand command = this.getLatestCommand();
        if (command != null && command.getCommandType().equals((Object)SDKDialogCommand.CommandType.SHOW)) {
            this.startActivity(command);
        }
    }

    synchronized void onNewCommand(SDKDialogCommand command) {
        Log.d((String)LOG_TAG, (String)("NEW COMMAND received [CurrentQueued: " + _commandStack.size() + "]: " + command.toString()));
        if (this._activity == null && !this._isStarting) {
            if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.DISMISS)) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "Ignoring dismiss() as there is no active dialog activity");
            }
            if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.SHOW)) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "Starting a new activity");
                this.startActivity(command);
            }
        } else if (this._isStarting || this._activity.isFinishing()) {
            RetailSDK.log(logLevel.debug, LOG_TAG, "Enqueuing command for later use as activity is starting or finishing. isStarting: " + this._isStarting + ". isFinishing: " + (this._activity != null && this._activity.isFinishing()));
            _commandStack.push(command);
        } else if (this._activity != null) {
            if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.DISMISS)) {
                RetailSDK.log(logLevel.debug, LOG_TAG, "Dismissing an active dialog - " + ((Object)((Object)this._activity)).hashCode());
                this._isStarting = false;
                this._activity.dismissDialog();
            } else if (command.getCommandType().equals((Object)SDKDialogCommand.CommandType.SHOW)) {
                if (this._appActivity != this.getCurrentActivity()) {
                    RetailSDK.log(logLevel.debug, LOG_TAG, "onNewCommand> updateView> App activity *CHANGED*...Prev app activity - '" + this._appActivity.getClass() + "'. Current app activity - '" + this.getCurrentActivity().getClass() + "'");
                    this._activity.dismissDialog();
                    _commandStack.push(command);
                } else {
                    RetailSDK.log(logLevel.debug, LOG_TAG, "onNewCommand> updateView> Updating view on an active dialog on app activity - " + this._appActivity.toString() + ". Current app activity - " + this.getCurrentActivity().toString());
                    this._activity.updateView(command);
                }
            }
        } else {
            RetailSDK.log(logLevel.error, LOG_TAG, "Unhandled SDK Dialog command " + command.toString());
        }
    }

    private synchronized void startActivity(SDKDialogCommand command) {
        _commandStack.push(command);
        this._isStarting = true;
        Intent intent = new Intent((Context)this.getCurrentActivity(), SDKDialogActivity.class);
        intent.addFlags(0x20000000);
        RetailSDK.log(logLevel.debug, LOG_TAG, "Showing dialog on " + this.getCurrentActivity().toString());
        this._appActivity = this.getCurrentActivity();
        this.getCurrentActivity().startActivity(intent);
    }

    @Override
    public void handleBackPressed() {
        if (this._activity != null) {
            this._activity.finish();
        }
    }

    public boolean isShowing() {
        return this._activity != null && this._activity.isShowing();
    }

    @Override
    protected Intent createActivityIntent(V8Object options, HashMap<String, String> extraData) {
        return null;
    }

    @Override
    public void onLayoutInitialized(RetailSDKBaseActivity activity) {
    }

    public void setIsStarting(boolean value) {
        this._isStarting = value;
    }

    static {
        _commandStack = new ArrayDeque<SDKDialogCommand>();
    }
}

