/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.errors.connect;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.paypal.paypalretailsdk.DeviceConnectorOptions;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderContract;
import com.paypal.paypalretailsdk.ui.connection.ConnectReaderPresenter;
import com.paypal.paypalretailsdk.ui.errors.connect.ConnectErrorContract;
import com.paypal.paypalretailsdk.ui.errors.connect.ConnectErrorView;

public class ConnectErrorPresenter
extends Fragment
implements ConnectErrorContract.Presenter {
    private DeviceConnectionActivity mParentActivity;
    private ConnectErrorView mView;
    public static DeviceConnectorOptions mOptions;
    public static ConnectReaderPresenter.OnActivityResult mCallback;

    public static ConnectErrorPresenter newInstance(DeviceConnectorOptions options, ConnectReaderPresenter.OnActivityResult callback, Bundle params) {
        ConnectErrorPresenter connectErrorPresenter = new ConnectErrorPresenter();
        mCallback = callback;
        mOptions = options;
        connectErrorPresenter.setArguments(params);
        return connectErrorPresenter;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mView = new ConnectErrorView((Context)this.mParentActivity, this);
        this.decorateCardReaderInfo();
        return this.mView;
    }

    private void decorateCardReaderInfo() {
        this.mView.setCardReaderId(this.getArguments().getString("DEVICE_NAME"));
        this.mView.setCardReaderImage(this.mParentActivity.getDrawableFromText(this.getArguments().getString("DEV_IMAGE_ID")));
        this.mView.setCardReaderName(this.getArguments().getString("DEVICE_DESCRIPTION"));
    }

    public void onStart() {
        super.onStart();
    }

    public void onResume() {
        super.onResume();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void cancelClicked() {
        if (mCallback != null) {
            mCallback.doAction(ConnectReaderContract.Presenter.DismissMode.cancel.toString());
        }
        this.mParentActivity.finish();
    }

    @Override
    public void tryConnectingAgain() {
        if (mOptions == null) {
            Toast.makeText((Context)this.mParentActivity, (CharSequence)this.mParentActivity.getString(R.string.sdk_label_cannot_connect), (int)0).show();
            this.dismissActivity();
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("CONNECTION_ACTION", "ACTION_CONNECT");
        bundle.putString("DEVICE_NAME", mOptions.getReaderId());
        bundle.putString("DEVICE_DESCRIPTION", mOptions.getReaderDescription());
        bundle.putString("DEV_IMAGE_ID", mOptions.getReaderImgId());
        this.mParentActivity.replacePresenter("CONNECT_READER", bundle);
    }

    @Override
    public void dismissActivity() {
        this.mParentActivity.finish();
    }
}

