/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.errors.connectafterscan;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.errors.connectafterscan.ScanConnectErrorContract;
import com.paypal.paypalretailsdk.ui.errors.connectafterscan.ScanConnectErrorView;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersContract;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;

public class ScanConnectErrorPresenter
extends Fragment
implements ScanConnectErrorContract.Presenter {
    private Context mContext;
    private DeviceConnectionActivity mParentActivity;
    private ScanConnectErrorView mView;
    public static CardReaderScanAndDiscoverOptions mScanOptions;
    public static ScanReadersPresenter.OnScanResult mScanCallBack;

    public static ScanConnectErrorPresenter newInstance(CardReaderScanAndDiscoverOptions options, ScanReadersPresenter.OnScanResult callback, Bundle args) {
        ScanConnectErrorPresenter scanConnectErrorPresenter = new ScanConnectErrorPresenter();
        mScanOptions = options;
        mScanCallBack = callback;
        scanConnectErrorPresenter.setArguments(args);
        return scanConnectErrorPresenter;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
        this.mContext = activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mView = new ScanConnectErrorView((Context)this.mParentActivity, this);
        this.decorateCardReaderInfo();
        return this.mView;
    }

    public void onStart() {
        super.onStart();
    }

    private void decorateCardReaderInfo() {
        this.mView.setCardReaderId(this.getArguments().getString("DEVICE_NAME"));
        this.mView.setCardReaderImage(this.mParentActivity.getDrawableFromText(this.getArguments().getString("DEV_IMAGE_ID")));
        this.mView.setCardReaderName(this.getArguments().getString("DEVICE_DESCRIPTION"));
    }

    public void onResume() {
        super.onResume();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void dismissActivity() {
        this.mParentActivity.finish();
    }

    @Override
    public void cancelClicked() {
        if (mScanCallBack != null) {
            mScanCallBack.doAction(ScanReadersContract.Presenter.ScanMode.cancel.toString());
        }
        this.mParentActivity.finish();
    }

    @Override
    public void retryConnection() {
        Bundle bundle = new Bundle();
        bundle.putString("DEVICE_NAME", this.getArguments().getString("DEVICE_NAME"));
        bundle.putString("DEVICE_DESCRIPTION", this.getArguments().getString("DEVICE_DESCRIPTION"));
        bundle.putString("DEV_IMAGE_ID", this.getArguments().getString("DEV_IMAGE_ID"));
        this.mParentActivity.replacePresenter("SCAN_RETRY_CONNECTION_AFTER_ERROR", bundle);
    }
}

