/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.errors.connectafterscan;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.errors.connectafterscan.ScanConnectErrorContract;
import com.paypal.paypalretailsdk.ui.errors.connectafterscan.ScanConnectErrorPresenter;

public class ScanConnectErrorView
extends FrameLayout
implements ScanConnectErrorContract.View {
    private Context mContext;
    private ScanConnectErrorContract.Presenter mPresenter;
    private FrameLayout mContainerFrameLayout;
    private LinearLayout mCardReaderDetailsLayout;
    private LinearLayout mButtonsContainer;
    private LinearLayout mInteractionContainerLayout;
    private ImageView mCardReaderImage;
    private TextView mCardReaderId;
    private TextView mCardReaderName;
    private Button mConnectAgain;
    private Button mCancel;

    public ScanConnectErrorView(Context context, ScanConnectErrorPresenter presenter) {
        super(context);
        this.mContext = context;
        this.setPresenter(presenter);
        this.initLayout();
    }

    @Override
    public void setPresenter(ScanConnectErrorContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerFrameLayout = (FrameLayout)layoutInflater.inflate(R.layout.layout_scan_connect_error, null);
        this.mCardReaderDetailsLayout = (LinearLayout)this.mContainerFrameLayout.findViewById(R.id.card_reader_details);
        this.mCardReaderImage = (ImageView)this.mCardReaderDetailsLayout.findViewById(R.id.image_card_reader);
        this.mCardReaderId = (TextView)this.mCardReaderDetailsLayout.findViewById(R.id.card_reader_id);
        this.mCardReaderName = (TextView)this.mCardReaderDetailsLayout.findViewById(R.id.card_reader_name);
        this.mInteractionContainerLayout = (LinearLayout)this.mContainerFrameLayout.findViewById(R.id.container_interaction);
        this.initButtons(layoutInflater);
        this.addView((View)this.mContainerFrameLayout);
        this.addClickListeners();
    }

    private void initButtons(LayoutInflater inflater) {
        this.mButtonsContainer = (LinearLayout)inflater.inflate(R.layout.layout_buttons_primary_n_tertiary, null);
        this.mCancel = (Button)this.mButtonsContainer.findViewById(R.id.button_secondary);
        this.mConnectAgain = (Button)this.mButtonsContainer.findViewById(R.id.button_primary);
        this.mInteractionContainerLayout.addView((View)this.mButtonsContainer);
        this.mCancel.setText(R.string.sdk_cancel);
        this.mConnectAgain.setText(R.string.sdk_try_again);
    }

    private void addClickListeners() {
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ScanConnectErrorView.this.mPresenter.cancelClicked();
            }
        });
        this.mConnectAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ScanConnectErrorView.this.mPresenter.retryConnection();
            }
        });
    }

    @Override
    public void setCardReaderId(String cardReaderId) {
        this.mCardReaderId.setText((CharSequence)cardReaderId);
    }

    @Override
    public void setCardReaderName(String cardReaderName) {
        this.mCardReaderName.setText((CharSequence)cardReaderName);
    }

    @Override
    public void setCardReaderImage(Drawable cardReaderImage) {
        this.mCardReaderImage.setImageDrawable(cardReaderImage);
    }
}

