/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.errors.scan;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.errors.scan.ScanErrorContract;
import com.paypal.paypalretailsdk.ui.errors.scan.ScanErrorView;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersContract;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;

public class ScanErrorPresenter
extends Fragment
implements ScanErrorContract.Presenter {
    public static CardReaderScanAndDiscoverOptions mScanOptions;
    public static ScanReadersPresenter.OnScanResult mScanCallBack;
    private Context mContext;
    private DeviceConnectionActivity mParentActivity;
    private ScanErrorView mView;

    public static ScanErrorPresenter newInstance(CardReaderScanAndDiscoverOptions options, ScanReadersPresenter.OnScanResult callback) {
        mScanCallBack = callback;
        mScanOptions = options;
        return new ScanErrorPresenter();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
        this.mContext = activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mView = new ScanErrorView((Context)this.mParentActivity, this);
        return this.mView;
    }

    public void onStart() {
        super.onStart();
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public void cancelClicked() {
        if (mScanCallBack != null) {
            mScanCallBack.doAction(ScanReadersContract.Presenter.ScanMode.cancel.toString());
        }
        this.mParentActivity.finish();
    }

    @Override
    public void scanForMoreReaders() {
        DeviceConnectionActivity.setScanJsInterfaces(mScanOptions, mScanCallBack);
        this.mParentActivity.replacePresenter("SCAN", null);
    }

    @Override
    public void dismissActivity() {
        this.mParentActivity.finish();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        mScanOptions = null;
        mScanCallBack = null;
    }
}

