/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.errors.scan;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.ui.errors.scan.ScanErrorContract;
import com.paypal.paypalretailsdk.ui.errors.scan.ScanErrorPresenter;

public class ScanErrorView
extends FrameLayout
implements ScanErrorContract.View {
    private Context mContext;
    private ScanErrorContract.Presenter mPresenter;
    private FrameLayout mContainerFrameLayout;
    private LinearLayout mButtonsContainer;
    private LinearLayout mInteractionContainerLayout;
    private Button mTryAgain;
    private Button mCancel;

    public ScanErrorView(Context context, ScanErrorPresenter presenter) {
        super(context);
        this.mContext = context;
        this.setPresenter(presenter);
        this.initLayout();
    }

    @Override
    public void setPresenter(ScanErrorContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerFrameLayout = (FrameLayout)layoutInflater.inflate(R.layout.layout_scan_error, null);
        this.mInteractionContainerLayout = (LinearLayout)this.mContainerFrameLayout.findViewById(R.id.container_interaction);
        this.initButtons(layoutInflater);
        this.addView((View)this.mContainerFrameLayout);
        this.addClickListeners();
    }

    private void initButtons(LayoutInflater inflater) {
        this.mButtonsContainer = (LinearLayout)inflater.inflate(R.layout.layout_buttons_primary_n_tertiary, null);
        this.mCancel = (Button)this.mButtonsContainer.findViewById(R.id.button_secondary);
        this.mTryAgain = (Button)this.mButtonsContainer.findViewById(R.id.button_primary);
        this.mInteractionContainerLayout.addView((View)this.mButtonsContainer);
        this.mCancel.setText(R.string.sdk_cancel);
        this.mTryAgain.setText(R.string.sdk_try_again);
    }

    private void addClickListeners() {
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ScanErrorView.this.mPresenter.cancelClicked();
            }
        });
        this.mTryAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ScanErrorView.this.mPresenter.scanForMoreReaders();
            }
        });
    }
}

