/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.receipt;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.paypal.instrumentation.domain.AdditionalReportingInfo;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptOptionsPresenter;
import com.paypal.paypalretailsdk.ui.receipt.SendReceiptTo;
import java.lang.ref.WeakReference;
import java.util.List;

public class ReceiptOptionsActivity
extends RetailSDKBaseActivity {
    private TextView mActionBarTitle;
    private TextView mMessage;
    private TextView mEmailButton;
    private TextView mTextButton;
    private ImageView mIcon;
    private ImageView mEditEmailButton;
    private ImageView mEditTextButton;
    private String mMaskedEmail;
    private String mMaskedPhoneNumber;
    private Button mSendButton;

    @Override
    public void initComponents(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        boolean isTabletMode = RetailSDK.getAppState().getIsTabletMode();
        if (!isTabletMode) {
            this.setRequestedOrientation(7);
        }
        this.setContentView(R.layout.retail_sdk_receipt_options_screen_template);
        ScrollView content = (ScrollView)this.findViewById(R.id.content);
        View layout2 = this.getLayoutInflater().inflate(R.layout.retail_sdk_activity_receipt_options_retail, null);
        content.addView(layout2);
        this.mActionBarTitle = (TextView)this.findViewById(R.id.ab_title);
        this.mIcon = (ImageView)this.findViewById(R.id.ab_status);
        this.mMessage = (TextView)this.findViewById(R.id.payment_complete_msg_retail);
        this.mEmailButton = (TextView)this.findViewById(R.id.id_email_button_retail);
        this.mEmailButton.setText((CharSequence)this.getResources().getString(R.string.sdk_actvy_receipt_option_email));
        this.mEmailButton.setOnClickListener((View.OnClickListener)new SendToButtonClickListener(SendReceiptTo.Email, this));
        this.mTextButton = (TextView)this.findViewById(R.id.id_text_button_retail);
        this.mTextButton.setText((CharSequence)this.getResources().getString(R.string.sdk_actvy_receipt_option_text));
        this.mTextButton.setOnClickListener((View.OnClickListener)new SendToButtonClickListener(SendReceiptTo.Sms, this));
        this.mEditEmailButton = (ImageView)this.findViewById(R.id.id_change_receipt_email_retail);
        this.mEditEmailButton.setVisibility(8);
        this.mEditEmailButton.setOnClickListener((View.OnClickListener)new EditReceiptDestination(SendReceiptTo.Email, this));
        this.mEditTextButton = (ImageView)this.findViewById(R.id.id_change_receipt_text_retail);
        this.mEditTextButton.setOnClickListener((View.OnClickListener)new EditReceiptDestination(SendReceiptTo.Sms, this));
        this.mEditTextButton.setVisibility(8);
        this.mSendButton = (Button)this.findViewById(R.id.receipt_ab_right_button);
        this.mSendButton.setVisibility(4);
    }

    @Override
    protected RetailSDKBasePresenter getPresenter() {
        return ReceiptOptionsPresenter.getInstance();
    }

    void setTitleText(final String title) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mActionBarTitle.setText((CharSequence)title);
            }
        });
    }

    void setMessage(final String message) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mMessage.setText((CharSequence)message);
            }
        });
    }

    void addMaskedEmail(String maskedEmail) {
        this.mMaskedEmail = maskedEmail;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mEmailButton.setText((CharSequence)ReceiptOptionsActivity.this.mMaskedEmail);
                ReceiptOptionsActivity.this.mEditEmailButton.setVisibility(0);
            }
        });
    }

    void addMaskedPhone(String maskedPhone) {
        this.mMaskedPhoneNumber = maskedPhone;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mTextButton.setText((CharSequence)ReceiptOptionsActivity.this.mMaskedPhoneNumber);
                ReceiptOptionsActivity.this.mEditTextButton.setVisibility(0);
            }
        });
    }

    void setEmailButtonTitle(final String emailTitle) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mTextButton.setText((CharSequence)emailTitle);
            }
        });
    }

    void setPhoneButtonTitle(final String phoneTitle) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsActivity.this.mTextButton.setText((CharSequence)phoneTitle);
            }
        });
    }

    void setTitleIcon(final String titleIcon) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Resources resources = ReceiptOptionsActivity.this.getResources();
                int resourceId = resources.getIdentifier(titleIcon, "drawable", ReceiptOptionsActivity.this.getPackageName());
                ReceiptOptionsActivity.this.mIcon.setBackgroundResource(resourceId);
            }
        });
    }

    void addButton(String btnText, final ReceiptOptionCallback callback) {
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.id_options_layout_retail);
        if (null == linearLayout) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View view = inflater.inflate(R.layout.retail_sdk_layout_receipt_options_item, null);
        TextView textView = (TextView)view.findViewById(R.id.id_receipt_options_button);
        textView.setText((CharSequence)btnText);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != callback) {
                    callback.onOptionSelected(ReceiptOptionsActivity.this);
                }
            }
        });
        linearLayout.addView(view);
    }

    void createAdditionalOptionsButtons(final List<String> additionalReceiptOptions) {
        if (additionalReceiptOptions != null) {
            for (final String item : additionalReceiptOptions) {
                this.addButton(item, new ReceiptOptionCallback(){

                    @Override
                    public void onOptionSelected(Activity activity) {
                        ReceiptOptionsPresenter.getInstance().additionalReceiptOptionCallback(additionalReceiptOptions.indexOf(item), item);
                    }
                });
            }
        }
    }

    void addNoReceiptButton(String btnText) {
        this.addButton(btnText != null && !btnText.isEmpty() ? btnText : this.getString(R.string.sdk_actvy_receipt_option_no_receipt), new ReceiptOptionCallback(){

            @Override
            public void onOptionSelected(Activity activity) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_RECEIPT_OPTION_SELECTED, AdditionalReportingInfo.builder().addCustominfo(MParticleConstants.EventAttributes.RECEIPT_OPTION_SELECTED.getString(), SendReceiptTo.None.getMethod()).build());
                ReceiptOptionsPresenter.getInstance().sendReceipt(null);
            }
        });
    }

    protected void onDestroy() {
        this.mEditEmailButton.setOnClickListener(null);
        this.mEditTextButton.setOnClickListener(null);
        this.mEmailButton.setOnClickListener(null);
        this.mTextButton.setOnClickListener(null);
        super.onDestroy();
    }

    public void onBackPressed() {
    }

    public static interface ReceiptOptionCallback {
        public void onOptionSelected(Activity var1);
    }

    private static class EditReceiptDestination
    implements View.OnClickListener {
        private final WeakReference<ReceiptOptionsActivity> _activityWeakReference;
        private SendReceiptTo mSendTo;

        EditReceiptDestination(SendReceiptTo sendTo, ReceiptOptionsActivity receiptOptionsActivity) {
            this._activityWeakReference = new WeakReference<ReceiptOptionsActivity>(receiptOptionsActivity);
            this.mSendTo = sendTo;
        }

        public void onClick(View v) {
            ReceiptOptionsPresenter.getInstance().openReceiptSendToActivity(this.mSendTo);
        }
    }

    private static class SendToButtonClickListener
    implements View.OnClickListener {
        private final WeakReference<ReceiptOptionsActivity> _activityWeakReference;
        private SendReceiptTo mSendTo;

        SendToButtonClickListener(SendReceiptTo sendTo, ReceiptOptionsActivity receiptOptionsActivity) {
            this.mSendTo = sendTo;
            this._activityWeakReference = new WeakReference<ReceiptOptionsActivity>(receiptOptionsActivity);
        }

        public void onClick(View v) {
            if (this.mSendTo == SendReceiptTo.Email) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_RECEIPT_OPTION_SELECTED, AdditionalReportingInfo.builder().addCustominfo(MParticleConstants.EventAttributes.RECEIPT_OPTION_SELECTED.getString(), this.mSendTo.getMethod()).build());
                if (((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedEmail == null || ((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedEmail.isEmpty()) {
                    ReceiptOptionsPresenter.getInstance().openReceiptSendToActivity(this.mSendTo);
                } else {
                    ReceiptOptionsPresenter.getInstance().sendReceipt(((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedEmail);
                }
            } else if (((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedPhoneNumber == null || ((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedPhoneNumber.isEmpty()) {
                ReceiptOptionsPresenter.getInstance().openReceiptSendToActivity(this.mSendTo);
            } else {
                ReceiptOptionsPresenter.getInstance().sendReceipt(((ReceiptOptionsActivity)((Object)this._activityWeakReference.get())).mMaskedPhoneNumber);
            }
        }
    }
}

