/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.receipt;

import android.content.Context;
import android.content.Intent;
import com.eclipsesource.v8.V8Object;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.NativeInterface;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.ReceiptViewContent;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptOptionsActivity;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptSendToPresenter;
import com.paypal.paypalretailsdk.ui.receipt.SendReceiptTo;
import java.util.HashMap;

public class ReceiptOptionsPresenter
extends RetailSDKBasePresenter {
    private static ReceiptOptionsPresenter _instance;
    private ReceiptOptionsActivity mActivity;
    private ReceiptViewContent viewContent;

    public static ReceiptOptionsPresenter getInstance() {
        if (_instance == null) {
            _instance = new ReceiptOptionsPresenter();
        }
        return _instance;
    }

    private ReceiptOptionsPresenter() {
    }

    @Override
    public Intent createActivityIntent(final V8Object jsOptions, HashMap<String, String> extraData) {
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                ReceiptOptionsPresenter.this.viewContent = NativeInterface.GetReceiptViewContent(jsOptions.getObject("viewContent"));
            }
        });
        Intent intent = new Intent((Context)this.getCurrentActivity(), ReceiptOptionsActivity.class);
        return intent;
    }

    @Override
    public void onLayoutInitialized(RetailSDKBaseActivity activity) {
        this.mActivity = (ReceiptOptionsActivity)activity;
        if (this.viewContent != null) {
            this.mActivity.setTitleText(this.viewContent.getReceiptOptionsViewContent().getTitle());
            this.mActivity.setMessage(this.viewContent.getReceiptOptionsViewContent().getMessage());
            this.mActivity.setTitleIcon(this.viewContent.getReceiptOptionsViewContent().getTitleIconFilename());
            this.mActivity.createAdditionalOptionsButtons(this.viewContent.getReceiptOptionsViewContent().getAdditionalReceiptOptions());
            this.mActivity.addNoReceiptButton(this.viewContent.getReceiptOptionsViewContent().getNoThanksButtonTitle());
            String maskedEmail = this.viewContent.getReceiptOptionsViewContent().getMaskedEmail();
            if (maskedEmail != null && !maskedEmail.isEmpty()) {
                this.mActivity.addMaskedEmail(maskedEmail);
            } else {
                this.mActivity.setEmailButtonTitle(this.viewContent.getReceiptOptionsViewContent().getEmailButtonTitle());
            }
            String maskedPhone = this.viewContent.getReceiptOptionsViewContent().getMaskedPhone();
            if (maskedPhone != null && !maskedPhone.isEmpty()) {
                this.mActivity.addMaskedPhone(maskedPhone);
            } else {
                this.mActivity.setPhoneButtonTitle(this.viewContent.getReceiptOptionsViewContent().getSmsButtonTitle());
            }
            TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_RECEIPT, null);
        } else {
            this.sendReceipt(null);
        }
    }

    @Override
    public void finishActivityImplementation() {
        super.finishActivityImplementation();
        this.mActivity.finish();
    }

    void sendReceipt(final String destination) {
        this.finishActivity();
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (ReceiptOptionsPresenter.this.mJsCallback != null) {
                    ReceiptOptionsPresenter.this.mJsCallback.call(ReceiptOptionsPresenter.this.mImpl, SendReceiptTo.buildV8Args(destination));
                }
                ReceiptOptionsPresenter.this.release();
            }
        });
    }

    void additionalReceiptOptionCallback(final int optionIndex, final String optionName) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (ReceiptOptionsPresenter.this.mJsCallback != null) {
                    ReceiptOptionsPresenter.this.mJsCallback.call(ReceiptOptionsPresenter.this.mImpl, SendReceiptTo.buildV8Args(optionIndex, optionName));
                }
            }
        });
    }

    void openReceiptSendToActivity(SendReceiptTo sendTo) {
        this.finishActivity();
        HashMap<String, String> extraData = new HashMap<String, String>();
        extraData.put("SendTo", sendTo.getMethod());
        ReceiptSendToPresenter.getInstance().showActivity(extraData, this.mJsOptions, this.mJsCallback);
        this.release();
    }

    @Override
    public void handleBackPressed() {
    }
}

