/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.receipt;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.logLevel;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptSendToPresenter;
import com.paypal.paypalretailsdk.ui.receipt.SendReceiptTo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReceiptSendToActivity
extends RetailSDKBaseActivity
implements View.OnClickListener {
    private ImageView mReceiptTypeIcon;
    private ImageView mBackButton;
    private TextView mTitle;
    private EditText mDestination;
    private TextView mDisclaimer;
    private Button mSendButton;
    private TextView mInternationalCodeMsg;
    private Spinner mCountryCodeSpinner;
    private EditText mCountryCodeInput;
    private String[] mRawCountryArray;
    private final Map<String, String> mInternationalDialCodeMap = new HashMap<String, String>();
    private final List<String> mDisplayedCountryNames = new ArrayList<String>();
    private static final String LOG_TAG = ReceiptSendToActivity.class.getSimpleName();
    private String destinationType = "";
    boolean isValid = false;

    @Override
    protected RetailSDKBasePresenter getPresenter() {
        return ReceiptSendToPresenter.getInstance();
    }

    @Override
    public void initComponents(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        boolean isTabletMode = RetailSDK.getAppState().getIsTabletMode();
        if (!isTabletMode) {
            this.setRequestedOrientation(7);
        }
        this.setContentView(R.layout.retail_sdk_receipt_send_to_template);
        ScrollView content = (ScrollView)this.findViewById(R.id.content);
        View layout2 = this.getLayoutInflater().inflate(R.layout.retail_sdk_activity_receipt_sent_to, null);
        content.addView(layout2);
        this.findViewById(R.id.ab_status).setVisibility(4);
        this.mBackButton = (ImageView)this.findViewById(R.id.receipt_ab_back);
        this.mBackButton.setVisibility(0);
        this.mTitle = (TextView)this.findViewById(R.id.ab_title);
        this.mDestination = (EditText)this.findViewById(R.id.send_location);
        this.mReceiptTypeIcon = (ImageView)this.findViewById(R.id.receipt_type_icon);
        this.mDisclaimer = (TextView)this.findViewById(R.id.receipts_disclaimer);
        this.mSendButton = (Button)this.findViewById(R.id.receipt_ab_right_button);
        this.mSendButton.setVisibility(0);
        this.mInternationalCodeMsg = (TextView)this.findViewById(R.id.intl_code_msg);
        this.mCountryCodeInput = (EditText)this.findViewById(R.id.sms_country_code);
        this.mCountryCodeSpinner = (Spinner)this.findViewById(R.id.country_selector);
        this.mSendButton.setOnClickListener((View.OnClickListener)this);
        this.mBackButton.setOnClickListener((View.OnClickListener)this);
        this.mDestination.addTextChangedListener((TextWatcher)new DeliveryValidation());
        this.mDestination.requestFocus();
    }

    void initializeTextReceiptContent() {
        this.showSMSLayout();
        this.mCountryCodeInput.setInputType(3);
        this.mCountryCodeInput.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"+0123456789"));
        this.initializeCountryCodeSpinner();
        this.setSMSHints();
        this.mDestination.setInputType(3);
        this.mDestination.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"+0123456789"));
        this.mCountryCodeInput.setOnFocusChangeListener((View.OnFocusChangeListener)new CountryCodeFocusChangedListener());
        this.mCountryCodeInput.addTextChangedListener((TextWatcher)new CountryCodeWatcher());
        InputFilter.LengthFilter maxLengthFilter = new InputFilter.LengthFilter(20);
        this.mDestination.setFilters(new InputFilter[]{maxLengthFilter});
        this.determineDefaultCountryCode();
    }

    private void determineDefaultCountryCode() {
        String merchantCountry = RetailSDK.getMerchant().getAddress().getCountry();
        if (StringUtil.isNotEmpty(merchantCountry)) {
            switch (merchantCountry) {
                case "AU": {
                    this.mCountryCodeSpinner.setSelection(5);
                    break;
                }
                case "GB": {
                    this.mCountryCodeSpinner.setSelection(91);
                    break;
                }
                case "US": {
                    this.mCountryCodeSpinner.setSelection(92);
                }
            }
        }
    }

    void initializeCountryCodeSpinner() {
        this.mRawCountryArray = this.getApplicationContext().getResources().getStringArray(R.array.sms_country_list);
        this.populateDialCodeMap();
        this.mCountryCodeSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new CountrySelectedListener());
        ArrayAdapter countryCodesSpinnerAdapter = new ArrayAdapter(this.getApplicationContext(), R.layout.retail_sdk_country_code_spinner, this.mDisplayedCountryNames);
        countryCodesSpinnerAdapter.setDropDownViewResource(R.layout.retail_sdk_element_spinner_selected_item_left);
        this.mCountryCodeSpinner.setAdapter((SpinnerAdapter)countryCodesSpinnerAdapter);
        this.mCountryCodeSpinner.setVisibility(0);
    }

    private void populateDialCodeMap() {
        for (String rawVal : this.mRawCountryArray) {
            String[] parts = rawVal.split(",");
            this.mInternationalDialCodeMap.put(parts[1], parts[0]);
            this.mDisplayedCountryNames.add(parts[1]);
        }
    }

    private String getCountryNameFromInternationalCode(String code) {
        for (Map.Entry<String, String> e : this.mInternationalDialCodeMap.entrySet()) {
            if (!e.getValue().equalsIgnoreCase(code)) continue;
            return e.getKey();
        }
        return "";
    }

    public void onClick(View view) {
        if (view.getId() == R.id.receipt_ab_right_button) {
            if (this.validateInputs()) {
                this.hideSoftKeyboard();
                ReceiptSendToPresenter.getInstance().sendReceipt(this.mCountryCodeInput.getText().toString() + "-" + this.mDestination.getText().toString());
            } else {
                this.animateErrors();
            }
        }
        if (view.getId() == R.id.receipt_ab_back) {
            ReceiptSendToPresenter.getInstance().viewReceiptOptions();
        }
    }

    private void hideSoftKeyboard() {
        try {
            View currentView = this.getCurrentFocus();
            if (currentView != null) {
                InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
                imm.hideSoftInputFromWindow(currentView.getWindowToken(), 0);
            }
        }
        catch (Exception ex) {
            RetailSDK.log(logLevel.warn, LOG_TAG, "Error on hiding soft-keyboard");
        }
    }

    void showSMSLayout() {
        this.mCountryCodeInput.setVisibility(0);
        this.mInternationalCodeMsg.setVisibility(0);
    }

    void hideSMSLayout() {
        this.mCountryCodeInput.setVisibility(8);
        this.mInternationalCodeMsg.setVisibility(8);
        this.mCountryCodeSpinner.setVisibility(8);
    }

    void setEmailHints() {
        this.mDestination.setHint(R.string.sdk_actvy_receipt_email_hint);
    }

    void setSMSHints() {
        this.mDestination.setHint(R.string.sdk_actvy_receipt_text_hint);
    }

    void setReceiptTypeIcon(final String iconName) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Resources resources = ReceiptSendToActivity.this.getResources();
                int resourceId = resources.getIdentifier(iconName, "drawable", ReceiptSendToActivity.this.getPackageName());
                ReceiptSendToActivity.this.mReceiptTypeIcon.setImageResource(resourceId);
            }
        });
    }

    void setEmailInputType() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mDestination.setInputType(33);
            }
        });
    }

    void setPhoneInputType() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mDestination.setInputType(3);
            }
        });
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    private void animateErrors() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mDestination.startAnimation(AnimationUtils.loadAnimation((Context)ReceiptSendToActivity.this, (int)R.anim.shake));
                ReceiptSendToActivity.this.mCountryCodeInput.startAnimation(AnimationUtils.loadAnimation((Context)ReceiptSendToActivity.this, (int)R.anim.shake));
                ReceiptSendToActivity.this.isValid = false;
            }
        });
    }

    public boolean validateInputs() {
        if (this.getDestinationType().equalsIgnoreCase(SendReceiptTo.Email.toString())) {
            return ReceiptSendToPresenter.getInstance().validateEmail(this.mDestination.getText().toString());
        }
        if (this.getDestinationType().equalsIgnoreCase(SendReceiptTo.Sms.toString())) {
            return ReceiptSendToPresenter.getInstance().validatePhone(this.mCountryCodeInput.getText().toString(), this.mDestination.getText().toString());
        }
        return false;
    }

    private int getItemPosition(String item) {
        int i = 0;
        for (String name : this.mDisplayedCountryNames) {
            if (item.equals(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    void setTitle(final String title) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mTitle.setText((CharSequence)title);
            }
        });
    }

    void setSendButtonTitle(final String title) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mSendButton.setText((CharSequence)title);
            }
        });
    }

    void setDisclaimer(final String disclaimer) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToActivity.this.mDisclaimer.setText((CharSequence)disclaimer);
            }
        });
    }

    public void onBackPressed() {
        ReceiptSendToPresenter.getInstance().viewReceiptOptions();
    }

    private class DeliveryValidation
    implements TextWatcher {
        private DeliveryValidation() {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ReceiptSendToActivity.this.validateInputs();
        }

        public void afterTextChanged(Editable editable) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }
    }

    private class CountryCodeWatcher
    implements TextWatcher {
        private CountryCodeWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            String enteredCountryCode = charSequence.toString();
            if (!enteredCountryCode.startsWith("+")) {
                enteredCountryCode = "+" + enteredCountryCode;
            }
            String countryCode = ReceiptSendToActivity.this.getCountryNameFromInternationalCode(enteredCountryCode);
            ReceiptSendToActivity.this.mCountryCodeSpinner.setSelection(ReceiptSendToActivity.this.getItemPosition(countryCode));
            ReceiptSendToActivity.this.validateInputs();
        }

        public void afterTextChanged(Editable editable) {
        }
    }

    private class CountryCodeFocusChangedListener
    implements View.OnFocusChangeListener {
        private CountryCodeFocusChangedListener() {
        }

        public void onFocusChange(View view, boolean b) {
            String enteredCountryCode = ReceiptSendToActivity.this.mCountryCodeInput.getText().toString();
            if (!enteredCountryCode.startsWith("+")) {
                enteredCountryCode = "+" + enteredCountryCode;
                ReceiptSendToActivity.this.mCountryCodeInput.setText((CharSequence)enteredCountryCode);
            }
            String countryCode = ReceiptSendToActivity.this.getCountryNameFromInternationalCode(enteredCountryCode);
            ReceiptSendToActivity.this.mCountryCodeSpinner.setSelection(ReceiptSendToActivity.this.getItemPosition(countryCode));
            ReceiptSendToActivity.this.validateInputs();
        }
    }

    private class CountrySelectedListener
    implements AdapterView.OnItemSelectedListener {
        private CountrySelectedListener() {
        }

        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            String countryName = (String)ReceiptSendToActivity.this.mCountryCodeSpinner.getSelectedItem();
            if (!countryName.equals(ReceiptSendToActivity.this.getCountryNameFromInternationalCode("+"))) {
                ReceiptSendToActivity.this.mCountryCodeInput.setText((CharSequence)"");
                ReceiptSendToActivity.this.mCountryCodeInput.append((CharSequence)ReceiptSendToActivity.this.mInternationalDialCodeMap.get(countryName));
            }
        }

        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }
}

