/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.receipt;

import android.content.Context;
import android.content.Intent;
import android.util.Patterns;
import com.eclipsesource.v8.V8Object;
import com.paypal.paypalretailsdk.NativeInterface;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.ReceiptEmailEntryViewContent;
import com.paypal.paypalretailsdk.ReceiptSMSEntryViewContent;
import com.paypal.paypalretailsdk.ReceiptViewContent;
import com.paypal.paypalretailsdk.readers.common.StringUtil;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptOptionsPresenter;
import com.paypal.paypalretailsdk.ui.receipt.ReceiptSendToActivity;
import com.paypal.paypalretailsdk.ui.receipt.SendReceiptTo;
import java.util.HashMap;

public class ReceiptSendToPresenter
extends RetailSDKBasePresenter {
    private static ReceiptSendToPresenter mInstance;
    private ReceiptSendToActivity mActivity;
    private ReceiptViewContent viewContent;
    private SendReceiptTo sendTo;

    public static ReceiptSendToPresenter getInstance() {
        if (mInstance == null) {
            mInstance = new ReceiptSendToPresenter();
        }
        return mInstance;
    }

    private ReceiptSendToPresenter() {
    }

    @Override
    protected Intent createActivityIntent(final V8Object jsOptions, HashMap<String, String> extraData) {
        PayPalRetailObject.getEngine().getExecutor().run(new Runnable(){

            @Override
            public void run() {
                ReceiptSendToPresenter.this.viewContent = NativeInterface.GetReceiptViewContent(jsOptions.getObject("viewContent"));
            }
        });
        this.sendTo = SendReceiptTo.valueOf(extraData.get("SendTo"));
        Intent myIntent = new Intent((Context)this.getCurrentActivity(), ReceiptSendToActivity.class);
        myIntent.addFlags(0x40000000);
        return myIntent;
    }

    @Override
    public void onLayoutInitialized(RetailSDKBaseActivity activity) {
        this.mActivity = (ReceiptSendToActivity)activity;
        if (this.sendTo == SendReceiptTo.Email) {
            ReceiptEmailEntryViewContent emailViewContent = this.viewContent.getReceiptEmailEntryViewContent();
            this.mActivity.setReceiptTypeIcon("ic_email");
            this.mActivity.setTitle(emailViewContent.getTitle());
            this.mActivity.setSendButtonTitle(emailViewContent.getSendButtonTitle());
            this.mActivity.setDisclaimer(emailViewContent.getDisclaimer());
            this.mActivity.setEmailInputType();
            this.mActivity.setDestinationType(SendReceiptTo.Email.toString());
            this.mActivity.hideSMSLayout();
            this.mActivity.setEmailHints();
        } else {
            this.mActivity.setReceiptTypeIcon("ic_text");
            ReceiptSMSEntryViewContent smsViewContent = this.viewContent.getReceiptSMSEntryViewContent();
            this.mActivity.setTitle(smsViewContent.getTitle());
            this.mActivity.setSendButtonTitle(smsViewContent.getSendButtonTitle());
            this.mActivity.initializeTextReceiptContent();
            this.mActivity.setDisclaimer(smsViewContent.getDisclaimer());
            this.mActivity.setPhoneInputType();
            this.mActivity.setDestinationType(SendReceiptTo.Sms.toString());
        }
    }

    @Override
    public void finishActivityImplementation() {
        super.finishActivityImplementation();
        this.mActivity.finish();
    }

    @Override
    public void handleBackPressed() {
        this.finishActivityImplementation();
    }

    public boolean validateEmail(String email) {
        return StringUtil.isNotEmpty(email) && Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public boolean validatePhone(String countryCode, String phone) {
        return StringUtil.isNotEmpty(countryCode) && StringUtil.isNotEmpty(phone) && Patterns.PHONE.matcher(phone).matches();
    }

    public void sendReceipt(final String destination) {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (ReceiptSendToPresenter.this.mJsCallback != null) {
                    ReceiptSendToPresenter.this.finishActivity();
                    ReceiptSendToPresenter.this.mJsCallback.call(ReceiptSendToPresenter.this.mImpl, SendReceiptTo.buildV8Args(destination));
                    ReceiptSendToPresenter.this.release();
                }
            }
        });
    }

    public void viewReceiptOptions() {
        this.finishActivity();
        ReceiptOptionsPresenter.getInstance().showActivity(null, this.mJsOptions, this.mJsCallback);
        this.release();
    }
}

