/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.scan;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;

public class CardReaderListViewItem
extends LinearLayout {
    private Context mContext;
    private View mContainerView;
    private ImageView mImageView;
    private TextView mCardReaderID;
    private TextView mCardReaderName;
    private ProgressBar mProgressSpinner;
    private TextView mCardReaderInUse;
    private TextView mCardReaderConnectingStatus;

    public CardReaderListViewItem(Context context) {
        super(context);
        this.mContext = context;
        this.initLayout();
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerView = layoutInflater.inflate(R.layout.layout_listitem_card_reader, null);
        this.mImageView = (ImageView)this.mContainerView.findViewById(R.id.image_card_reader);
        this.mCardReaderID = (TextView)this.mContainerView.findViewById(R.id.card_reader_id);
        this.mCardReaderName = (TextView)this.mContainerView.findViewById(R.id.card_reader_name);
        this.mProgressSpinner = (ProgressBar)this.mContainerView.findViewById(R.id.progress_spinner);
        this.mCardReaderConnectingStatus = (TextView)this.mContainerView.findViewById(R.id.card_reader_connecting);
        this.mCardReaderInUse = (TextView)this.mContainerView.findViewById(R.id.card_reader_in_use);
        this.addView(this.mContainerView);
    }

    public void switchConnectionProgressBar(boolean progressOn) {
        this.mImageView.setVisibility(progressOn ? 8 : 0);
        this.mProgressSpinner.setVisibility(progressOn ? 0 : 8);
    }

    public void setCardReaderImage(Drawable imgDrawable) {
        this.mImageView.setImageDrawable(imgDrawable);
    }

    public void setCardReaderID(String cardReaderID) {
        this.mCardReaderID.setText((CharSequence)cardReaderID);
    }

    public void setCardReaderName(String cardReaderName) {
        this.mCardReaderName.setText((CharSequence)cardReaderName);
    }

    public void showReaderInUseText() {
        this.mCardReaderInUse.setVisibility(0);
    }

    public void hideReaderInUseText() {
        this.mCardReaderInUse.setVisibility(8);
    }

    public void showConnectingStatusText() {
        this.mCardReaderConnectingStatus.setVisibility(0);
        this.hideReaderInUseText();
    }
}

