/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.scan;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.res.ResourcesCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.CardReaderScanAndDiscoverOptions;
import com.paypal.paypalretailsdk.DiscoveredCardReader;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.RetailSDKException;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.DeviceConnectionActivity;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersContract;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersView;
import java.util.ArrayList;
import java.util.List;

public class ScanReadersPresenter
extends Fragment
implements ScanReadersContract.Presenter {
    private final String LOG_TAG = ScanReadersPresenter.class.getSimpleName();
    private Context mContext;
    private DeviceConnectionActivity mParentActivity;
    private ScanReadersView mView;
    public static CardReaderScanAndDiscoverOptions mScanOptions;
    public static OnScanResult mScanCallBack;
    public static List<DiscoveredCardReader> mDiscoveredReaders;
    public DiscoveredCardReader mSelectedCardReaderFromList;
    private CardReaderScanAndDiscoverOptions.OnCardReaderDiscoveredObserver onCardReaderDiscoveredObserver = new CardReaderScanAndDiscoverOptions.OnCardReaderDiscoveredObserver(){

        @Override
        public void onCardReaderDiscovered(final DiscoveredCardReader device) {
            ScanReadersPresenter.this.mParentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (device != null) {
                        mDiscoveredReaders.add(device);
                        ScanReadersPresenter.this.mView.onPaymentDeviceFound(device);
                    }
                }
            });
        }
    };
    private CardReaderScanAndDiscoverOptions.OnScanCompleteObserver onScanCompleteObserver = new CardReaderScanAndDiscoverOptions.OnScanCompleteObserver(){

        @Override
        public void onScanComplete(final RetailSDKException error) {
            ScanReadersPresenter.this.mParentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ScanReadersPresenter.this.mView.showScanComplete();
                    ScanReadersPresenter.this.mView.activateRefresh();
                    if (error != null) {
                        if (error.getCode().equalsIgnoreCase("8")) {
                            Toast.makeText((Context)ScanReadersPresenter.this.mContext, (int)R.string.bluetooth_disabled, (int)1).show();
                        } else {
                            DeviceConnectionActivity.setScanErrorJsInterfaces(mScanOptions, mScanCallBack);
                            ScanReadersPresenter.this.mParentActivity.replacePresenter("SCAN_NO_DEVICE_FOUND", null);
                        }
                    }
                }
            });
        }
    };
    private CardReaderScanAndDiscoverOptions.OnConnectionStatusObserver connectionStatusObserver = new CardReaderScanAndDiscoverOptions.OnConnectionStatusObserver(){

        @Override
        public void onConnectionStatus(final RetailSDKException error, DiscoveredCardReader device) {
            ScanReadersPresenter.this.mParentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ScanReadersPresenter.this.mSelectedCardReaderFromList == null) {
                        return;
                    }
                    if (error == null) {
                        ScanReadersPresenter.this.mParentActivity.finish();
                        mScanCallBack.doAction(ScanReadersContract.Presenter.ScanMode.done.toString());
                    } else {
                        Bundle bundle = new Bundle();
                        bundle.putString("DEVICE_NAME", ScanReadersPresenter.this.mSelectedCardReaderFromList.getReaderId());
                        bundle.putString("DEVICE_DESCRIPTION", ScanReadersPresenter.this.mSelectedCardReaderFromList.getReaderDescription());
                        bundle.putString("DEV_IMAGE_ID", ScanReadersPresenter.this.mSelectedCardReaderFromList.getReaderImgId());
                        DeviceConnectionActivity.setScanErrorJsInterfaces(mScanOptions, mScanCallBack);
                        ScanReadersPresenter.this.mParentActivity.replacePresenter("SCAN_CONNECT_ERROR", bundle);
                    }
                }
            });
        }
    };

    public static ScanReadersPresenter newInstance(CardReaderScanAndDiscoverOptions options, OnScanResult callback) {
        mScanOptions = options;
        mScanCallBack = callback;
        return new ScanReadersPresenter();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParentActivity = (DeviceConnectionActivity)activity;
        this.mContext = activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mView = new ScanReadersView((Context)this.mParentActivity, this);
        return this.mView;
    }

    public void onStart() {
        super.onStart();
        mScanOptions.addOnCardReaderDiscoveredObserver(this.onCardReaderDiscoveredObserver);
        mScanOptions.addOnScanCompleteObserver(this.onScanCompleteObserver);
        mScanOptions.addOnConnectionStatusObserver(this.connectionStatusObserver);
        mScanOptions.onAddedObserver();
        mDiscoveredReaders = new ArrayList<DiscoveredCardReader>();
    }

    public void onResume() {
        super.onResume();
        this.scanForDevices();
    }

    public void onStop() {
        super.onStop();
    }

    @Override
    public void scanForDevices() {
        this.mView.showScanInProgress();
    }

    @Override
    public void redoScan() {
        TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_FIND_REFRESH_CLICKED, null);
        this.mParentActivity.finish();
        RetailSDK.getDeviceManager().searchAndConnectWithoutCallback();
    }

    @Override
    public Drawable getDrawableForImage(String imageName) {
        Resources res = this.getResources();
        int resourceId = res.getIdentifier(imageName, "drawable", this.mContext.getPackageName());
        return ResourcesCompat.getDrawable((Resources)res, (int)resourceId, null);
    }

    @Override
    public void connectToReader(DiscoveredCardReader paymentDevice) {
        TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_FIND_CONNECT_CLICKED, null);
        this.mSelectedCardReaderFromList = paymentDevice;
        mScanOptions.connectToCardReader(paymentDevice.getReaderId());
    }

    @Override
    public void dismissActivity(ScanReadersContract.Presenter.ScanMode scanMode) {
        if (mScanCallBack != null) {
            mScanCallBack.doAction(scanMode.toString());
        }
        this.mParentActivity.finish();
    }

    public void onDestroy() {
        super.onDestroy();
        mScanOptions.removeOnCardReaderDiscoveredObserver(this.onCardReaderDiscoveredObserver);
        mScanOptions.removeOnScanCompleteObserver(this.onScanCompleteObserver);
        mScanOptions.removeOnConnectionStatusObserver(this.connectionStatusObserver);
        mDiscoveredReaders.clear();
    }

    public static interface OnScanResult {
        public void doAction(String var1);
    }
}

