/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.scan;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.DiscoveredCardReader;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.scan.CardReaderListViewItem;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersContract;
import com.paypal.paypalretailsdk.ui.scan.ScanReadersPresenter;
import java.util.ArrayList;
import java.util.List;

public class ScanReadersView
extends FrameLayout
implements ScanReadersContract.View {
    private Context mContext;
    private ScanReadersContract.Presenter mPresenter;
    private FrameLayout mContainerFrameLayout;
    private ImageView mCancelDialogImage;
    private TextView mTitleView;
    private ListView mCardReaderListView;
    private ProgressBar mProgressBar;
    private ImageView mRefreshImage;
    private CardReaderListAdapter mCardReaderListAdapter;
    private ArrayList<DiscoveredCardReader> mCardReaders;
    private ArrayList<String> mStaticList;

    public ScanReadersView(Context context, ScanReadersPresenter scanReadersPresenter) {
        super(context);
        this.mContext = context;
        this.setPresenter(scanReadersPresenter);
        this.initLayout();
    }

    @Override
    public void setPresenter(ScanReadersContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mContainerFrameLayout = (FrameLayout)layoutInflater.inflate(R.layout.dialog_card_reader_scanner, null);
        this.mCancelDialogImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.image_x);
        this.mTitleView = (TextView)this.mContainerFrameLayout.findViewById(R.id.dialog_title);
        this.mProgressBar = (ProgressBar)this.mContainerFrameLayout.findViewById(R.id.progress_spinner);
        this.mCardReaderListView = (ListView)this.mContainerFrameLayout.findViewById(R.id.listview_card_readers);
        this.mRefreshImage = (ImageView)this.mContainerFrameLayout.findViewById(R.id.scan_again);
        this.mCancelDialogImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.READER_FIND_CLOSED, null);
                ScanReadersView.this.mPresenter.dismissActivity(ScanReadersContract.Presenter.ScanMode.cancel);
            }
        });
        this.addView((View)this.mContainerFrameLayout);
        this.initCardReaderList();
    }

    private void initCardReaderList() {
        this.mCardReaders = new ArrayList();
        this.mCardReaderListAdapter = new CardReaderListAdapter(this.mContext, this.mCardReaders);
        this.mCardReaderListView.setAdapter((ListAdapter)this.mCardReaderListAdapter);
        this.mCardReaderListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ScanReadersView.this.mCardReaderListView.setOnItemClickListener(null);
                ScanReadersView.this.cardReaderListItemSelected((DiscoveredCardReader)ScanReadersView.this.mCardReaderListAdapter.getItem(position), view);
            }
        });
        this.updateTitleForCardReadersFound(0);
    }

    @Override
    public void showScanInProgress() {
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void showScanComplete() {
        this.mProgressBar.setVisibility(8);
    }

    @Override
    public void activateRefresh() {
        this.mRefreshImage.setVisibility(0);
        this.mRefreshImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ScanReadersView.this.mPresenter.scanForDevices();
                ScanReadersView.this.mRefreshImage.setVisibility(8);
                ScanReadersView.this.mPresenter.redoScan();
            }
        });
    }

    @Override
    public void deactiveRefresh() {
        this.mRefreshImage.setVisibility(8);
    }

    @Override
    public void showScanFailed() {
    }

    @Override
    public void onPaymentDeviceFound(DiscoveredCardReader pd) {
        this.mCardReaders.add(pd);
        this.mCardReaderListAdapter.notifyDataSetChanged();
        this.updateTitleForCardReadersFound(this.mCardReaders.size());
    }

    private void cardReaderListItemSelected(DiscoveredCardReader pd, View cardReaderListItemView) {
        this.deactiveRefresh();
        ((CardReaderListViewItem)cardReaderListItemView).switchConnectionProgressBar(true);
        ((CardReaderListViewItem)cardReaderListItemView).showConnectingStatusText();
        this.mPresenter.connectToReader(pd);
    }

    private void updateTitleForCardReadersFound(int numberOfFoundCardReaders) {
        this.mTitleView.setText((CharSequence)String.format(this.mContext.getString(R.string.sdk_dialog_title_card_reader_found), numberOfFoundCardReaders == 0 ? " " : " " + numberOfFoundCardReaders));
    }

    public class CardReaderListAdapter
    extends ArrayAdapter<DiscoveredCardReader> {
        private Context mContext;
        private List<DiscoveredCardReader> mDiscoveredCardReaderList;

        public CardReaderListAdapter(@NonNull Context context, ArrayList<DiscoveredCardReader> paymentDevices) {
            super(context, 0, paymentDevices);
            this.mContext = context;
            this.mDiscoveredCardReaderList = paymentDevices;
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            boolean connected;
            DiscoveredCardReader pd = (DiscoveredCardReader)this.getItem(position);
            boolean bl = connected = pd != null && pd.getIsConnected() != false;
            if (convertView == null) {
                convertView = new CardReaderListViewItem(this.mContext);
            }
            if (pd != null) {
                ((CardReaderListViewItem)((Object)convertView)).setCardReaderID(pd.getReaderId());
                ((CardReaderListViewItem)((Object)convertView)).setCardReaderName(pd.getReaderDescription());
                ((CardReaderListViewItem)((Object)convertView)).setCardReaderImage(ScanReadersView.this.mPresenter.getDrawableForImage(pd.getReaderImgId()));
                if (connected) {
                    ((CardReaderListViewItem)((Object)convertView)).setBackgroundColor(ScanReadersView.this.getResources().getColor(R.color.sdk_blue_connected_reader));
                    ((CardReaderListViewItem)((Object)convertView)).showReaderInUseText();
                } else {
                    ((CardReaderListViewItem)((Object)convertView)).setBackgroundColor(ScanReadersView.this.getResources().getColor(R.color.sdk_white));
                    ((CardReaderListViewItem)((Object)convertView)).hideReaderInUseText();
                }
            }
            return convertView;
        }
    }
}

