/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.signature;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Base64;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.paypal.paypalretailsdk.R;
import com.paypal.paypalretailsdk.RetailSDK;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.signature.SignatureCanvas;
import com.paypal.paypalretailsdk.ui.signature.SignaturePresenter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class SignatureActivity
extends RetailSDKBaseActivity {
    private SignatureCanvas mSignatureCanvas;
    private ImageView mClearSignature;
    private TextView mSignHereTextView;
    private TextView mDoneButton;
    private TextView mCancelButton;
    private TextView mAmountDetailsView;
    private TextView mFooterTextView;
    private boolean mCanHitDoneButton = true;

    @Override
    public void initComponents(Bundle savedInstanceState) {
        boolean isTabletMode = RetailSDK.getAppState().getIsTabletMode();
        this.requestWindowFeature(1);
        this.setRequestedOrientation(6);
        this.setContentView(R.layout.retail_sdk_activity_signature_retail);
        this.mCancelButton = (TextView)this.findViewById(R.id.ab_left_button);
        this.mCancelButton.setText((CharSequence)this.getString(R.string.sdk_actvy_signature_cancel));
        this.mCancelButton.setVisibility(0);
        this.mDoneButton = (TextView)this.findViewById(R.id.ab_right_button);
        this.mDoneButton.setText((CharSequence)this.getString(R.string.sdk_actvy_signature_done));
        this.mDoneButton.setVisibility(0);
        this.mDoneButton.setEnabled(false);
        this.mDoneButton.setTextColor(this.getResources().getColor(R.color.sdk_button_disabled));
        this.mAmountDetailsView = (TextView)this.findViewById(R.id.ab_title);
        this.mSignHereTextView = (TextView)this.findViewById(R.id.sign_here_retail);
        this.mFooterTextView = (TextView)this.findViewById(R.id.id_agreement_txt_retail);
        this.mClearSignature = (ImageView)this.findViewById(R.id.id_cancel_sig_retail);
        this.mSignatureCanvas = (SignatureCanvas)this.findViewById(R.id.signature_retail);
        this.mSignatureCanvas.setSignatureListener(new MySignatureListener(this));
        this.mDoneButton.setOnClickListener((View.OnClickListener)new DoneButtonListener(this));
        this.mClearSignature.setOnClickListener((View.OnClickListener)new ClearSignatureListener(this));
        this.mCancelButton.setOnClickListener((View.OnClickListener)new CancelButtonListener());
    }

    @Override
    protected RetailSDKBasePresenter getPresenter() {
        return SignaturePresenter.getInstance();
    }

    public void setTitleText(final String title) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SignatureActivity.this.mAmountDetailsView.setText((CharSequence)title);
            }
        });
    }

    public void setWatermark(final String watermark) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SignatureActivity.this.mSignHereTextView.setText((CharSequence)watermark);
            }
        });
    }

    public void setFooter(final String footer) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SignatureActivity.this.mFooterTextView.setText((CharSequence)footer);
            }
        });
    }

    public void setCancelButtonText(final String cancel) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SignatureActivity.this.mCancelButton.setText((CharSequence)cancel);
            }
        });
    }

    public void onResume() {
        super.onResume();
    }

    public void onBackPressed() {
        this.getPresenter().handleBackPressed();
    }

    private void signatureProvided() {
        this.mDoneButton.setEnabled(true);
        this.mDoneButton.setTextColor(-1);
        this.mClearSignature.setVisibility(0);
        this.mSignHereTextView.setVisibility(8);
    }

    private void clearSignature() {
        this.mDoneButton.setEnabled(false);
        this.mDoneButton.setTextColor(this.getResources().getColor(R.color.sdk_button_disabled));
        this.mClearSignature.setVisibility(8);
        this.mSignHereTextView.setVisibility(0);
    }

    public void setVisibilityOfCancelButton(boolean isVisible) {
        if (isVisible) {
            this.mCancelButton.setVisibility(0);
            this.mCancelButton.setEnabled(true);
        } else {
            this.mCancelButton.setVisibility(8);
            this.mCancelButton.setEnabled(false);
        }
    }

    protected void onDestroy() {
        this.mDoneButton.setOnClickListener(null);
        this.mCancelButton.setOnClickListener(null);
        this.mClearSignature.setOnClickListener(null);
        this.mSignatureCanvas = null;
        super.onDestroy();
    }

    private static class ClearSignatureListener
    implements View.OnClickListener {
        private final WeakReference<SignatureActivity> _activityWeakReference;

        public ClearSignatureListener(SignatureActivity signatureActivity) {
            this._activityWeakReference = new WeakReference<SignatureActivity>(signatureActivity);
        }

        public void onClick(View view) {
            ((SignatureActivity)((Object)this._activityWeakReference.get())).mSignatureCanvas.clear();
        }
    }

    private static class MySignatureListener
    implements SignatureCanvas.SignatureListener {
        private final WeakReference<SignatureActivity> _activityWeakReference;

        public MySignatureListener(SignatureActivity signatureActivity) {
            this._activityWeakReference = new WeakReference<SignatureActivity>(signatureActivity);
        }

        @Override
        public void onSignaturePresent(boolean signature) {
            if (signature) {
                ((SignatureActivity)((Object)this._activityWeakReference.get())).signatureProvided();
            } else {
                ((SignatureActivity)((Object)this._activityWeakReference.get())).clearSignature();
            }
        }
    }

    private static class DoneButtonListener
    implements View.OnClickListener {
        private final WeakReference<SignatureActivity> _activityWeakReference;

        public DoneButtonListener(SignatureActivity signatureActivity) {
            this._activityWeakReference = new WeakReference<SignatureActivity>(signatureActivity);
        }

        public void onClick(View view) {
            if (((SignatureActivity)((Object)this._activityWeakReference.get())).mCanHitDoneButton) {
                ((SignatureActivity)((Object)this._activityWeakReference.get())).mCanHitDoneButton = false;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ((SignatureActivity)((Object)this._activityWeakReference.get())).mSignatureCanvas.getBitmap().compress(Bitmap.CompressFormat.WEBP, 50, (OutputStream)stream);
                byte[] bytes = stream.toByteArray();
                String encoded = Base64.encodeToString((byte[])bytes, (int)0);
                SignaturePresenter.getInstance().onSignatureBitmapReceived(encoded);
            }
        }
    }

    private static class CancelButtonListener
    implements View.OnClickListener {
        private CancelButtonListener() {
        }

        public void onClick(View v) {
            SignaturePresenter.getInstance().cancelTransaction();
        }
    }
}

