/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.signature;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.EmbossMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class SignatureCanvas
extends View {
    private static final String LOG_TAG = SignatureCanvas.class.getSimpleName();
    private boolean created = false;
    private Paint mPaint;
    private int backgroundColor = 15263457;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Path mPath = new Path();
    private Paint mBitmapPaint = new Paint(4);
    public SignatureListener listener;
    private boolean signaturePresent;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 4.0f;

    public SignatureCanvas(Context c, AttributeSet a) {
        super(c, a);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(10.0f);
        EmbossMaskFilter mEmboss = new EmbossMaskFilter(new float[]{1.0f, 1.0f, 1.0f}, 0.4f, 6.0f, 3.5f);
        this.mPaint.setMaskFilter((MaskFilter)mEmboss);
        this.signaturePresent = false;
        this.listener = null;
    }

    public Bitmap getBitmap() {
        Bitmap returnBitmap = Bitmap.createBitmap((int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas returnCanvas = new Canvas(returnBitmap);
        returnCanvas.drawColor(-1);
        returnCanvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mBitmapPaint);
        return returnBitmap;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (!this.created && w > 0 && h > 0) {
            this.mBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mBitmap);
            this.created = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(this.backgroundColor);
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mBitmapPaint);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void clear() {
        this.mPath = new Path();
        this.mCanvas.drawColor(this.backgroundColor);
        this.mBitmap = Bitmap.createBitmap((int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
        this.invalidate();
        this.signaturePresent = false;
        this.listener.onSignaturePresent(false);
    }

    private void touch_start(float x, float y) {
        this.mPath.moveTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    private void touch_move(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.mPath.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.mX = x;
            this.mY = y;
        }
    }

    private void touch_up() {
        this.mPath.lineTo(this.mX, this.mY);
        this.mCanvas.drawPath(this.mPath, this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.touch_start(x, y);
                this.invalidate();
                break;
            }
            case 2: {
                if (!this.signaturePresent) {
                    try {
                        this.listener.onSignaturePresent(true);
                        this.signaturePresent = true;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                this.touch_move(x, y);
                this.invalidate();
                break;
            }
            case 1: {
                this.touch_up();
                this.invalidate();
            }
        }
        return true;
    }

    public void setSignatureListener(SignatureListener listener) {
        this.listener = listener;
    }

    public static interface SignatureListener {
        public void onSignaturePresent(boolean var1);
    }
}

