/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.paypalretailsdk.ui.signature;

import android.content.Context;
import android.content.Intent;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import com.paypal.paypalretailsdk.PayPalRetailObject;
import com.paypal.paypalretailsdk.reporting.TrackingService;
import com.paypal.paypalretailsdk.ui.RetailSDKBaseActivity;
import com.paypal.paypalretailsdk.ui.RetailSDKBasePresenter;
import com.paypal.paypalretailsdk.ui.signature.SignatureActivity;
import java.util.HashMap;

public class SignaturePresenter
extends RetailSDKBasePresenter {
    protected static SignaturePresenter _instance;
    private SignatureActivity mActivity;

    public static SignaturePresenter getInstance() {
        if (_instance == null) {
            _instance = new SignaturePresenter();
        }
        return _instance;
    }

    private SignaturePresenter() {
    }

    @Override
    public Intent createActivityIntent(V8Object options, HashMap<String, String> extraData) {
        return new Intent((Context)this.getCurrentActivity(), SignatureActivity.class);
    }

    @Override
    public void onLayoutInitialized(RetailSDKBaseActivity activity) {
        this.mActivity = (SignatureActivity)activity;
        String title = this.getV8OptionsStringValue("title");
        String signHere = this.getV8OptionsStringValue("signHere");
        String footer = this.getV8OptionsStringValue("footer");
        String cancel = this.getV8OptionsStringValue("cancel");
        if (title != null) {
            this.mActivity.setTitleText(title);
        }
        if (signHere != null) {
            this.mActivity.setWatermark(signHere);
        }
        if (footer != null) {
            this.mActivity.setFooter(footer);
        }
        if (cancel != null) {
            this.mActivity.setCancelButtonText(cancel);
        } else {
            this.mActivity.setVisibilityOfCancelButton(false);
        }
        TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_SIGNATURE, null);
    }

    public void cancelTransaction() {
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (SignaturePresenter.this.mJsCallback != null) {
                    V8Array args = PayPalRetailObject.getEngine().createJsArray();
                    args.pushUndefined().pushUndefined().push(true);
                    SignaturePresenter.this.mJsCallback.call(SignaturePresenter.this.mImpl, args);
                }
            }
        });
    }

    public void onSignatureBitmapReceived(final String bitmap) {
        TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_SIGNATURE_DONE, null);
        PayPalRetailObject.getEngine().getExecutor().runNoWait(new Runnable(){

            @Override
            public void run() {
                if (SignaturePresenter.this.mJsCallback != null) {
                    SignaturePresenter.this.finishActivity();
                    V8Array args = PayPalRetailObject.getEngine().createJsArray();
                    args.pushUndefined().push(bitmap);
                    SignaturePresenter.this.mJsCallback.call(SignaturePresenter.this.mImpl, args);
                    SignaturePresenter.this.release();
                }
            }
        });
    }

    @Override
    public void handleBackPressed() {
        TrackingService.reportEvent((Event)MParticleConstants.MParticleEvents.TRANSACTION_SIGNATURE_CANCEL, null);
        this.cancelTransaction();
    }

    @Override
    public void finishActivityImplementation() {
        super.finishActivityImplementation();
        this.mActivity.finish();
    }
}

