/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation;

import android.content.Context;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventListener;
import com.paypal.instrumentation.IReportingEnum;
import com.paypal.instrumentation.TrackingListener;
import com.paypal.instrumentation.TrackingService;
import com.paypal.instrumentation.adjust.AdjustService;
import com.paypal.instrumentation.domain.AdditionalReportingInfo;
import com.paypal.instrumentation.domain.Error;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.domain.Link;
import com.paypal.instrumentation.domain.Page;
import com.paypal.instrumentation.domain.ReportingConfigs;
import com.paypal.instrumentation.domain.ReportingContext;
import com.paypal.instrumentation.firebase.FirebaseAnalyticsService;
import com.paypal.instrumentation.fpti.FPTIService;
import com.paypal.instrumentation.mParticle.MParticleAnalyticsService;
import com.paypal.instrumentation.networking.NetworkEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrackingServiceDispatcher
implements TrackingService,
ModelEventListener {
    private static final String LOG_TAG = TrackingServiceDispatcher.class.getName();
    public TrackingService adjustService;
    public TrackingService fptiService;
    public TrackingService firebaseService;
    public TrackingService mParticleAnalyticsService;
    public ReportingContext reportingContext;
    private static TrackingServiceDispatcher trackingServiceDispatcher;
    private List<TrackingService> serviceList;
    private Context context;

    private TrackingServiceDispatcher() {
        this.serviceList = new ArrayList<TrackingService>();
    }

    private TrackingServiceDispatcher(Context context, Boolean trackingEnabled, NetworkEnvironment networkEnvironment, List<TrackingService.TrackingServices> trackingServices) {
        if (!trackingEnabled.booleanValue()) {
            return;
        }
        this.context = context;
        this.reportingContext = this.getReportingContext();
        this.adjustService = this.getAdjustService();
        this.fptiService = this.getFPTIService(networkEnvironment);
        this.firebaseService = this.getFirebaseService();
        this.mParticleAnalyticsService = this.getMParticleAnalyticsService();
        this.serviceList = new ArrayList<TrackingService>();
        for (TrackingService.TrackingServices services : trackingServices) {
            switch (services) {
                case FPTI: {
                    this.serviceList.add(this.fptiService);
                    break;
                }
                case ADJUST: {
                    this.serviceList.add(this.adjustService);
                    break;
                }
                case FIREBASE: {
                    this.serviceList.add(this.firebaseService);
                    break;
                }
                case MPARTICLE: {
                    this.serviceList.add(this.mParticleAnalyticsService);
                }
            }
        }
    }

    public static TrackingServiceDispatcher create(Context context, Boolean trackingEnabled, NetworkEnvironment networkEnvironment, List<TrackingService.TrackingServices> trackingServices) {
        if (trackingServiceDispatcher == null) {
            trackingServiceDispatcher = new TrackingServiceDispatcher(context, trackingEnabled, networkEnvironment, trackingServices);
        }
        return trackingServiceDispatcher;
    }

    public static TrackingServiceDispatcher getInstance() {
        if (trackingServiceDispatcher == null) {
            trackingServiceDispatcher = new TrackingServiceDispatcher();
        }
        return trackingServiceDispatcher;
    }

    protected TrackingService getAdjustService() {
        return new AdjustService(this.context);
    }

    protected TrackingService getFPTIService(NetworkEnvironment networkEnvironment) {
        return new FPTIService(this.reportingContext, networkEnvironment);
    }

    protected TrackingService getFirebaseService() {
        return new FirebaseAnalyticsService(this.context);
    }

    protected TrackingService getMParticleAnalyticsService() {
        return new MParticleAnalyticsService(this.context);
    }

    private ReportingContext getReportingContext() {
        return new ReportingContext("", "Android", "MerchAppAndroid", "MerchApp", "mobile", "", 1111, "", "Android", "", "", "", "24", "", "", "");
    }

    @Override
    public void addListener(TrackingListener listener) {
        if (this.fptiService == null) {
            return;
        }
        this.fptiService.addListener(listener);
    }

    @Override
    public void removeListener(TrackingListener listener) {
        if (this.fptiService == null) {
            return;
        }
        this.fptiService.removeListener(listener);
    }

    @Override
    public void startService(ReportingConfigs configs) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.startService(configs);
        }
    }

    @Override
    public void logPageView(Page page) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logPageView(page);
        }
    }

    @Override
    public void logErrorPageView(Error error) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logErrorPageView(error);
        }
    }

    @Override
    public void logNetworkError(String api, String errorCode, String correlationId) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logNetworkError(api, errorCode, correlationId);
        }
    }

    @Override
    public void logLink(Link link) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logLink(link);
        }
    }

    @Override
    public void logEvent(Event event, AdditionalReportingInfo additionalReportingInfo) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logEvent(event, additionalReportingInfo);
        }
    }

    @Override
    public void logUserAttributes(Map<IReportingEnum, Object> attributes) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logUserAttributes(attributes);
        }
    }

    @Override
    public void logHandledException(Exception exception) {
        for (TrackingService trackingService : this.serviceList) {
            try {
                trackingService.logHandledException(exception);
            }
            catch (Exception ex) {
                Logging.e((String)LOG_TAG, (String)ex.getMessage());
            }
        }
    }

    @Override
    public void beginTransaction(String transactionName) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.beginTransaction(transactionName);
        }
    }

    @Override
    public void endTransaction(String transactionName) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.endTransaction(transactionName);
        }
    }

    @Override
    public void failTransaction(String transactionName) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.failTransaction(transactionName);
        }
    }

    @Override
    public void setUserMetadata(String payerId, String merchantCountryCode) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.setUserMetadata(payerId, merchantCountryCode);
        }
    }

    @Override
    public void logTransactionComplete() {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.logTransactionComplete();
        }
    }

    @Override
    public void startTracking(boolean isFirstStartup) {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.startTracking(isFirstStartup);
        }
    }

    @Override
    public void onLogin() {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.onLogin();
        }
    }

    @Override
    public void onLogout() {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.onLogout();
        }
    }

    @Override
    public void onPause() {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.onPause();
        }
    }

    @Override
    public void onResume() {
        for (TrackingService trackingService : this.serviceList) {
            trackingService.onResume();
        }
    }

    public void modelChanged(ModelChangeEvent event) {
    }
}

