/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.adjust;

import android.content.Context;
import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustConfig;
import com.paypal.instrumentation.AbstractTrackingService;
import com.paypal.instrumentation.adjust.AdjustConstants;
import com.paypal.instrumentation.domain.AdditionalReportingInfo;
import com.paypal.instrumentation.domain.AdjustEvent;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.domain.ReportingConfigs;
import java.util.Map;

public class AdjustService
extends AbstractTrackingService {
    private Context context;

    public AdjustService(Context context) {
        this.context = context;
    }

    @Override
    public void startService(ReportingConfigs reportingConfigs) {
        String environment = reportingConfigs.getEnvironment() != null ? (String)reportingConfigs.getEnvironment().getValue() : "sandbox";
        String apiKey = reportingConfigs.getAdjustAPIKey() != null ? (String)reportingConfigs.getAdjustAPIKey().getValue() : "";
        AdjustConfig config = new AdjustConfig(this.context, apiKey, environment);
        Adjust.onCreate((AdjustConfig)config);
    }

    @Override
    public void logEvent(Event event, AdditionalReportingInfo info) {
        if (event instanceof AdjustEvent) {
            com.adjust.sdk.AdjustEvent adjustEvent = new com.adjust.sdk.AdjustEvent(event.getString());
            if (info != null) {
                Map<String, String> eventInfo = info.getCustomInfo();
                if (eventInfo.containsKey((Object)AdjustConstants.AMOUNT) && eventInfo.containsKey((Object)AdjustConstants.CURRENCY)) {
                    adjustEvent.setRevenue(Double.valueOf(eventInfo.get((Object)AdjustConstants.AMOUNT)).doubleValue(), eventInfo.get((Object)AdjustConstants.CURRENCY));
                } else if (eventInfo.containsKey((Object)AdjustConstants.AMOUNT) && !eventInfo.containsKey((Object)AdjustConstants.CURRENCY)) {
                    adjustEvent.addCallbackParameter(AdjustConstants.QUANTITY.getString(), eventInfo.get((Object)AdjustConstants.AMOUNT));
                } else if (eventInfo.containsKey((Object)AdjustConstants.PAYER_ID)) {
                    adjustEvent.addCallbackParameter(AdjustConstants.PAYER_ID.getString(), eventInfo.get((Object)AdjustConstants.PAYER_ID));
                }
            }
            Adjust.trackEvent((com.adjust.sdk.AdjustEvent)adjustEvent);
        }
    }
}

