/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.domain;

import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.domain.Country;
import java.util.HashMap;
import java.util.Map;

public class AdditionalReportingInfo {
    private String sessionID;
    private String accountID;
    private String transactionID;
    private Country userCountry;
    private Map<String, String> customInfo;

    private AdditionalReportingInfo() {
    }

    public Optional<String> getSessionID() {
        return this.sessionID == null ? Optional.absent() : Optional.of((Object)this.sessionID);
    }

    public Optional<String> getAccountID() {
        return this.accountID == null ? Optional.absent() : Optional.of((Object)this.accountID);
    }

    public Optional<Country> getUserCountry() {
        return this.userCountry == null ? Optional.absent() : Optional.of((Object)this.userCountry);
    }

    public Optional<String> getTransactionID() {
        return this.transactionID == null ? Optional.absent() : Optional.of((Object)this.transactionID);
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AdditionalReportingInfo additionalInfo) {
        return new Builder(additionalInfo);
    }

    public static class Builder {
        private String sessionID;
        private String accountID;
        private String transactionID;
        private Country userCountry;
        private Map<String, String> customInfo = new HashMap<String, String>();

        private Builder() {
        }

        private Builder(AdditionalReportingInfo additionalInfo) {
            this.setAccountId(additionalInfo.accountID);
            this.setSessionId(additionalInfo.sessionID);
            this.setTransactionId(additionalInfo.transactionID);
            this.setUserCountry(additionalInfo.userCountry);
            this.customInfo = additionalInfo.customInfo;
        }

        public AdditionalReportingInfo build() {
            AdditionalReportingInfo additionalReportingInfo = new AdditionalReportingInfo();
            additionalReportingInfo.accountID = this.accountID;
            additionalReportingInfo.sessionID = this.sessionID;
            additionalReportingInfo.transactionID = this.transactionID;
            additionalReportingInfo.userCountry = this.userCountry;
            additionalReportingInfo.customInfo = this.customInfo;
            return additionalReportingInfo;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionID = sessionId;
            return this;
        }

        public Builder setAccountId(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder setTransactionId(String transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder setUserCountry(Country userCountry) {
            this.userCountry = userCountry;
            return this;
        }

        public Builder addCustominfo(String property, String value) {
            this.customInfo.put(property, value);
            return this;
        }
    }
}

