/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.domain;

import com.paypal.android.instrumentation.base.commons.lang.Action;
import com.paypal.instrumentation.domain.AbstractEvent;
import com.paypal.instrumentation.domain.Error;
import com.paypal.instrumentation.domain.Page;
import java.util.Map;

public class ErrorBuilder {
    private Page _page;
    private String _name;
    private Action<Page, Void> _pageEvaluator;
    private Action<String, Void> _nameEvaluator;
    private static String s_platform;

    public static void setPlatform(String platform) {
        s_platform = platform;
    }

    public ErrorBuilder setPage(Page page) {
        this._page = page;
        return this;
    }

    public ErrorBuilder setName(String name) {
        this._name = name;
        return this;
    }

    public Error create() {
        return new ErrorImpl(this._page, this._name, this._nameEvaluator, this._pageEvaluator);
    }

    static class ErrorImpl
    extends AbstractEvent
    implements Error {
        private final Action<Page, Void> _pageEvaluator;
        private final Action<String, Void> _nameEvaluator;
        private Page _page;
        private String _name;

        ErrorImpl(Page page, String name, Action<String, Void> nameEvaluator, Action<Page, Void> pageEvaluator) {
            this._page = page;
            this._name = name;
            this._nameEvaluator = nameEvaluator;
            this._pageEvaluator = pageEvaluator;
        }

        @Override
        public Page getPage() {
            if (this._pageEvaluator == null) {
                return this._page;
            }
            return (Page)this._pageEvaluator.invoke(null);
        }

        @Override
        public String getName() {
            if (this._nameEvaluator == null) {
                return this._name;
            }
            return (String)this._nameEvaluator.invoke(null);
        }

        @Override
        public Map<String, String> getParameters() {
            Map<String, String> params = super.getParameters();
            String pageName2 = this.getPage().getFullPageName() + ":" + s_platform;
            params.put("pgrp", this.getPage().getFullPageName() + "|" + this.getName());
            params.put("page", pageName2 + "|" + this.getName());
            params.put("e", "im");
            return params;
        }
    }
}

